/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.client.gui.screen.ExtendedButtonWithTooltip;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.menu.ManagerMenu;
import ca.teamdman.sfm.common.net.ServerboundManagerFixPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerResetPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class ManagerScreen
extends AbstractContainerScreen<ManagerMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE_LOCATION = new ResourceLocation("sfm", "textures/gui/container/manager.png");
    private final float STATUS_DURATION = 40.0f;
    private Component status = Component.m_237119_();
    private float statusCountdown = 0.0f;
    private ExtendedButton DiagButton;

    public ManagerScreen(ManagerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ExtendedButton((this.f_96543_ - this.f_97726_) / 2 + 70, (this.f_96544_ - this.f_97727_) / 2 + 37, 100, 16, (Component)Component.m_237115_((String)"gui.sfm.manager.button.import_clipboard"), button -> this.onLoadClipboard()));
        this.m_142416_((GuiEventListener)new ExtendedButton((this.f_96543_ - this.f_97726_) / 2 + 70, (this.f_96544_ - this.f_97727_) / 2 + 37 + 20, 100, 16, (Component)Component.m_237115_((String)"gui.sfm.manager.button.export_clipboard"), button -> this.onSaveClipboard()));
        this.m_142416_((GuiEventListener)new ExtendedButton((this.f_96543_ - this.f_97726_) / 2 + 120, (this.f_96544_ - this.f_97727_) / 2 + 10, 50, 12, (Component)Component.m_237115_((String)"gui.sfm.manager.button.reset"), button -> this.sendReset()));
        this.DiagButton = new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 + 35, (this.f_96544_ - this.f_97727_) / 2 + 48, 12, 14, (Component)Component.m_237115_((String)"!"), button -> {
            if (Screen.m_96638_()) {
                this.sendAttemptFix();
            } else {
                this.onSaveDiagClipboard();
            }
        }, (btn, pose, mx, my) -> this.m_96617_(pose, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.sfm.manager.button.warning.tooltip"), Math.max(this.f_96543_ / 2 - 43, 170)), mx, my));
        this.m_142416_((GuiEventListener)this.DiagButton);
    }

    private void sendReset() {
        SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerResetPacket(((ManagerMenu)this.f_97732_).f_38840_, ((ManagerMenu)this.f_97732_).BLOCK_ENTITY_POSITION));
        this.status = Component.m_237115_((String)"gui.sfm.manager.status.reset");
        this.statusCountdown = 40.0f;
    }

    private void sendAttemptFix() {
        SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerFixPacket(((ManagerMenu)this.f_97732_).f_38840_, ((ManagerMenu)this.f_97732_).BLOCK_ENTITY_POSITION));
        this.status = Component.m_237115_((String)"gui.sfm.manager.status.fix");
        this.statusCountdown = 40.0f;
    }

    private void sendProgram(String program) {
        SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerProgramPacket(((ManagerMenu)this.f_97732_).f_38840_, ((ManagerMenu)this.f_97732_).BLOCK_ENTITY_POSITION, program));
        ((ManagerMenu)this.f_97732_).program = program;
        this.status = Component.m_237115_((String)"gui.sfm.manager.status.loaded_clipboard");
        this.statusCountdown = 40.0f;
    }

    private void onSaveClipboard() {
        try {
            Minecraft.m_91087_().f_91068_.m_90911_(((ManagerMenu)this.f_97732_).program);
            this.status = Component.m_237115_((String)"gui.sfm.manager.status.saved_clipboard");
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean shouldShowDiagButton() {
        ItemStack disk = ((ManagerMenu)this.f_97732_).CONTAINER.m_8020_(0);
        if (!(disk.m_41720_() instanceof DiskItem)) {
            return false;
        }
        List<TranslatableContents> errors = DiskItem.getErrors(disk);
        List<TranslatableContents> warnings = DiskItem.getWarnings(disk);
        return !errors.isEmpty() || !warnings.isEmpty();
    }

    private void onSaveDiagClipboard() {
        try {
            List<TranslatableContents> warnings;
            ItemStack disk = ((ManagerMenu)this.f_97732_).CONTAINER.m_8020_(0);
            if (!(disk.m_41720_() instanceof DiskItem)) {
                return;
            }
            StringBuilder content = new StringBuilder(((ManagerMenu)this.f_97732_).program);
            content.append("\n\n-- Diagnostic info ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm.ss").format(new Date())).append(" --");
            List<TranslatableContents> errors = DiskItem.getErrors(disk);
            if (!errors.isEmpty()) {
                content.append("\n\n-- Errors\n");
                for (TranslatableContents error : errors) {
                    content.append("-- * ").append(I18n.m_118938_((String)error.m_237508_(), (Object[])error.m_237523_())).append("\n");
                }
            }
            if (!(warnings = DiskItem.getWarnings(disk)).isEmpty()) {
                content.append("\n\n-- Warnings\n");
                for (TranslatableContents warning : warnings) {
                    content.append("-- * ").append(I18n.m_118938_((String)warning.m_237508_(), (Object[])warning.m_237523_())).append("\n");
                }
            }
            Minecraft.m_91087_().f_91068_.m_90911_(content.toString());
            this.status = Component.m_237115_((String)"gui.sfm.manager.status.saved_clipboard");
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void onLoadClipboard() {
        try {
            String contents = Minecraft.m_91087_().f_91068_.m_90876_();
            this.sendProgram(contents);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean m_7933_(int p_97765_, int p_97766_, int p_97767_) {
        if (super.m_7933_(p_97765_, p_97766_, p_97767_)) {
            return true;
        }
        if (Screen.m_96630_((int)p_97765_)) {
            this.onLoadClipboard();
            return true;
        }
        if (Screen.m_96632_((int)p_97765_)) {
            this.onSaveClipboard();
            return true;
        }
        return false;
    }

    protected void m_7027_(PoseStack matrixStack, int mx, int my) {
        super.m_7027_(matrixStack, mx, my);
        ManagerBlockEntity.State[] states = ManagerBlockEntity.State.values();
        int key = ((ManagerMenu)this.f_97732_).CONTAINER_DATA.m_6413_(0);
        ManagerBlockEntity.State state = states[key];
        this.f_96547_.m_92889_(matrixStack, (Component)Component.m_237110_((String)"gui.sfm.manager.state", (Object[])new Object[]{Component.m_237115_((String)("gui.sfm.manager.state." + state.name().toLowerCase(Locale.ROOT))).m_130940_(state.COLOR)}), (float)this.f_97728_, 20.0f, 0);
        this.DiagButton.f_93624_ = this.shouldShowDiagButton();
        if (this.statusCountdown <= 0.0f) {
            return;
        }
        float f = this.f_97728_;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(matrixStack, this.status, f, 20.0f + 9.0f + 0.1f, 0);
    }

    public void m_6305_(PoseStack poseStack, int mx, int my, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mx, my, partialTicks);
        this.m_7025_(poseStack, mx, my);
        this.statusCountdown -= partialTicks;
    }

    protected void m_7025_(PoseStack pose, int mx, int my) {
        super.m_7025_(pose, mx, my);
        this.DiagButton.m_7428_(pose, mx, my);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mx, int my) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE_LOCATION);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }
}

