/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.content.builder;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.function.Predicate;
import mekanism.api.robit.RobitSkin;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.content.CrTContentUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister(loaders={"mekanismcontent"})
@ZenCodeType.Name(value="mods.mekanism.content.builder.RobitSkinBuilder")
public class CrTRobitSkinBuilder {
    private final ResourceLocation[] textures;
    @Nullable
    private Predicate<Player> unlockedPredicate;
    @Nullable
    private ResourceLocation model;

    @ZenCodeType.Method
    public static CrTRobitSkinBuilder builder(ResourceLocation ... textures) {
        if (textures.length == 0) {
            throw new IllegalArgumentException("Robit skins require at least one texture!");
        }
        return new CrTRobitSkinBuilder(textures);
    }

    private CrTRobitSkinBuilder(ResourceLocation ... textures) {
        this.textures = textures;
    }

    @ZenCodeType.Method
    public CrTRobitSkinBuilder customModel(ResourceLocation model) {
        this.model = model;
        return this;
    }

    @ZenCodeType.Method
    public CrTRobitSkinBuilder unlockCheck(Predicate<Player> unlockedPredicate) {
        this.unlockedPredicate = unlockedPredicate;
        return this;
    }

    @ZenCodeType.Method
    public void build(String name) {
        RobitSkin skin = this.unlockedPredicate == null && this.model == null ? new RobitSkin(this.textures) : new RobitSkin(this.textures){

            @Override
            @Nullable
            public ResourceLocation getCustomModel() {
                return CrTRobitSkinBuilder.this.model;
            }

            @Override
            public boolean isUnlocked(@NotNull Player player) {
                return CrTRobitSkinBuilder.this.unlockedPredicate == null ? super.isUnlocked(player) : CrTRobitSkinBuilder.this.unlockedPredicate.test(player);
            }
        };
        CrTContentUtils.queueRobitSkinForRegistration(CrTUtils.rl(name), skin);
    }
}

