/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.List;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public class ModuleInhalationPurificationUnit
implements ICustomModule<ModuleInhalationPurificationUnit> {
    private static final ICustomModule.ModuleDamageAbsorbInfo INHALATION_ABSORB_INFO = new ICustomModule.ModuleDamageAbsorbInfo(MekanismConfig.gear.mekaSuitMagicDamageRatio, MekanismConfig.gear.mekaSuitEnergyUsageMagicReduce);
    private IModuleConfigItem<Boolean> beneficialEffects;
    private IModuleConfigItem<Boolean> neutralEffects;
    private IModuleConfigItem<Boolean> harmfulEffects;

    @Override
    public void init(IModule<ModuleInhalationPurificationUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.beneficialEffects = configItemCreator.createConfigItem("beneficial_effects", MekanismLang.MODULE_PURIFICATION_BENEFICIAL, new ModuleBooleanData(false));
        this.neutralEffects = configItemCreator.createConfigItem("neutral_effects", MekanismLang.MODULE_PURIFICATION_NEUTRAL, new ModuleBooleanData());
        this.harmfulEffects = configItemCreator.createConfigItem("harmful_effects", MekanismLang.MODULE_PURIFICATION_HARMFUL, new ModuleBooleanData());
    }

    @Override
    public void tickClient(IModule<ModuleInhalationPurificationUnit> module, Player player) {
        if (!player.m_5833_()) {
            FloatingLong energy;
            FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsagePotionTick.get();
            boolean free = usage.isZero() || player.m_7500_();
            FloatingLong floatingLong = energy = free ? FloatingLong.ZERO : module.getContainerEnergy().copy();
            if (free || energy.greaterOrEqual(usage)) {
                List<MobEffectInstance> effects = player.m_21220_().stream().filter(effect -> this.canHandle(effect.m_19544_().m_19483_())).toList();
                for (MobEffectInstance effect2 : effects) {
                    if (free) {
                        this.speedupEffect(player, effect2);
                        continue;
                    }
                    energy = energy.minusEqual(usage);
                    this.speedupEffect(player, effect2);
                    if (!energy.smallerThan(usage)) continue;
                    break;
                }
            }
        }
    }

    @Override
    public void tickServer(IModule<ModuleInhalationPurificationUnit> module, Player player) {
        IEnergyContainer energyContainer;
        FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsagePotionTick.get();
        boolean free = usage.isZero() || player.m_7500_();
        IEnergyContainer iEnergyContainer = energyContainer = free ? null : module.getEnergyContainer();
        if (free || energyContainer != null && energyContainer.getEnergy().greaterOrEqual(usage)) {
            List<MobEffectInstance> effects = player.m_21220_().stream().filter(effect -> this.canHandle(effect.m_19544_().m_19483_())).toList();
            for (MobEffectInstance effect2 : effects) {
                if (free) {
                    this.speedupEffect(player, effect2);
                    continue;
                }
                if (module.useEnergy((LivingEntity)player, energyContainer, usage, true).isZero()) break;
                this.speedupEffect(player, effect2);
                if (!energyContainer.getEnergy().smallerThan(usage)) continue;
                break;
            }
        }
    }

    @Override
    @Nullable
    public ICustomModule.ModuleDamageAbsorbInfo getDamageAbsorbInfo(IModule<ModuleInhalationPurificationUnit> module, DamageSource damageSource) {
        return damageSource.m_19387_() ? INHALATION_ABSORB_INFO : null;
    }

    private void speedupEffect(Player player, MobEffectInstance effect) {
        for (int i = 0; i < 9; ++i) {
            MekanismUtils.speedUpEffectSafely((LivingEntity)player, effect);
        }
    }

    private boolean canHandle(MobEffectCategory effectType) {
        return switch (effectType) {
            default -> throw new IncompatibleClassChangeError();
            case MobEffectCategory.BENEFICIAL -> this.beneficialEffects.get();
            case MobEffectCategory.HARMFUL -> this.harmfulEffects.get();
            case MobEffectCategory.NEUTRAL -> this.neutralEffects.get();
        };
    }
}

