/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell;

import appeng.api.stacks.AEItemKey;
import appeng.core.AppEng;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class CompressionService {
    public static final CompressionService INSTANCE = new CompressionService();
    private final Set<Object2IntMap<AEItemKey>> compressionChains = new ObjectLinkedOpenHashSet();

    private CompressionService() {
    }

    public Object2IntMap<AEItemKey> getVariants(AEItemKey key, boolean decompress) {
        Optional<Object2IntMap> variantChain = this.compressionChains.stream().filter(chain -> chain.containsKey((Object)key)).findFirst();
        return (Object2IntMap)variantChain.map(chain -> {
            ObjectArrayList keys = new ObjectArrayList((ObjectCollection)chain.keySet());
            if (decompress) {
                Collections.reverse(keys);
            }
            Object2IntLinkedOpenHashMap variants = new Object2IntLinkedOpenHashMap();
            keys.subList(keys.indexOf((Object)key) + 1, keys.size()).forEach(k -> variants.put(k, chain.getInt(k)));
            return variants;
        }).orElseGet(Object2IntLinkedOpenHashMap::new);
    }

    public void load() {
        this.compressionChains.clear();
        MinecraftServer server = AppEng.instance().getCurrentServer();
        List allRecipes = server != null ? server.m_129894_().m_44013_(RecipeType.f_44107_) : new ObjectArrayList();
        List<CraftingRecipe> candidates = Stream.concat(allRecipes.stream().filter(this::isCompressionRecipe), allRecipes.stream().filter(this::isDecompressionRecipe)).toList();
        List<CraftingRecipe> validRecipes = candidates.stream().filter(recipe -> {
            boolean compressible = false;
            boolean decompressible = false;
            Ingredient input = (Ingredient)recipe.m_7527_().get(0);
            ItemStack output = recipe.m_8043_();
            List<CraftingRecipe> checkAgainst = candidates.stream().filter(this.isCompressionRecipe((CraftingRecipe)recipe) ? this::isDecompressionRecipe : this::isCompressionRecipe).toList();
            for (CraftingRecipe candidate : checkAgainst) {
                for (ItemStack item : ((Ingredient)candidate.m_7527_().get(0)).m_43908_()) {
                    if (!item.m_41720_().equals(output.m_41720_())) continue;
                    compressible = true;
                }
                for (ItemStack item : input.m_43908_()) {
                    if (!item.m_41720_().equals(candidate.m_8043_().m_41720_())) continue;
                    decompressible = true;
                }
                if (!compressible || !decompressible) continue;
                break;
            }
            return compressible && decompressible;
        }).toList();
        List<CraftingRecipe> compressed = validRecipes.stream().filter(this::isCompressionRecipe).toList();
        List<CraftingRecipe> decompressed = validRecipes.stream().filter(this::isDecompressionRecipe).toList();
        compressed.forEach(recipe -> {
            Item baseVariant = recipe.m_8043_().m_41720_();
            if (this.compressionChains.stream().noneMatch(chain -> chain.containsKey((Object)AEItemKey.of((ItemLike)baseVariant)))) {
                Object2IntLinkedOpenHashMap decompressionChain = new Object2IntLinkedOpenHashMap();
                Pair<Item, Integer> lowerVariant = this.getSubsequentVariant(baseVariant, decompressed);
                while (lowerVariant != null) {
                    decompressionChain.put((Object)AEItemKey.of((ItemLike)((ItemLike)lowerVariant.first())), ((Integer)lowerVariant.second()).intValue());
                    lowerVariant = this.getSubsequentVariant((Item)lowerVariant.first(), decompressed);
                }
                Object2IntLinkedOpenHashMap compressionChain = new Object2IntLinkedOpenHashMap();
                Pair<Item, Integer> higherVariant = this.getSubsequentVariant(baseVariant, compressed);
                while (higherVariant != null) {
                    compressionChain.put((Object)AEItemKey.of((ItemLike)((ItemLike)higherVariant.first())), ((Integer)higherVariant.second()).intValue());
                    higherVariant = this.getSubsequentVariant((Item)higherVariant.first(), compressed);
                }
                Object2IntLinkedOpenHashMap fullChain = new Object2IntLinkedOpenHashMap();
                ObjectArrayList decompressionKeys = new ObjectArrayList((ObjectCollection)decompressionChain.keySet());
                Collections.reverse(decompressionKeys);
                decompressionKeys.forEach(k -> fullChain.put(k, decompressionChain.getInt(k)));
                fullChain.put((Object)AEItemKey.of((ItemLike)baseVariant), fullChain.isEmpty() ? compressionChain.getInt(compressionChain.firstKey()) : fullChain.getInt(fullChain.lastKey()));
                fullChain.putAll((Map)compressionChain);
                this.compressionChains.add((Object2IntMap<AEItemKey>)fullChain);
            }
        });
    }

    private boolean isCompressionRecipe(CraftingRecipe recipe) {
        return (recipe.m_7527_().size() == 4 || recipe.m_7527_().size() == 9) && recipe.m_7527_().stream().distinct().limit(2L).count() == 1L && recipe.m_8043_().m_41613_() == 1;
    }

    private boolean isDecompressionRecipe(CraftingRecipe recipe) {
        return (recipe.m_8043_().m_41613_() == 4 || recipe.m_8043_().m_41613_() == 9) && recipe.m_7527_().size() == 1;
    }

    private Pair<Item, Integer> getSubsequentVariant(Item item, List<CraftingRecipe> recipes) {
        for (CraftingRecipe recipe : recipes) {
            for (ItemStack input : ((Ingredient)recipe.m_7527_().get(0)).m_43908_()) {
                if (!input.m_41720_().equals(item)) continue;
                return Pair.of((Object)recipe.m_8043_().m_41720_(), (Object)(this.isCompressionRecipe(recipe) ? recipe.m_7527_().size() : recipe.m_8043_().m_41613_()));
            }
        }
        return null;
    }
}

