/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell;

import appeng.api.stacks.AEKey;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.core.localization.Tooltips;
import gripe._90.megacells.definition.MEGATranslations;
import gripe._90.megacells.item.MEGABulkCell;
import gripe._90.megacells.item.cell.BulkCellInventory;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BulkCellHandler
implements ICellHandler {
    public static final BulkCellHandler INSTANCE = new BulkCellHandler();

    private BulkCellHandler() {
    }

    public boolean isCell(ItemStack is) {
        return is != null && is.m_41720_() instanceof MEGABulkCell;
    }

    @Nullable
    public BulkCellInventory getCellInventory(ItemStack is, @Nullable ISaveProvider container) {
        Objects.requireNonNull(is, "Cannot create cell inventory for null itemstack");
        Item item = is.m_41720_();
        if (!(item instanceof MEGABulkCell)) {
            return null;
        }
        MEGABulkCell cell = (MEGABulkCell)item;
        return new BulkCellInventory(cell, is, container);
    }

    public void addCellInformationToTooltip(ItemStack is, List<Component> lines) {
        BulkCellInventory handler = this.getCellInventory(is, null);
        if (handler == null) {
            return;
        }
        AEKey storedItem = handler.getStoredItem();
        AEKey filterItem = handler.getFilterItem();
        if (storedItem != null) {
            lines.add((Component)Tooltips.of((Component)MEGATranslations.Contains.text(new Object[]{storedItem.getDisplayName()})));
            long quantity = handler.getStoredQuantity();
            lines.add((Component)Tooltips.of((Component)MEGATranslations.Quantity.text(new Object[]{quantity < Long.MAX_VALUE ? Tooltips.ofNumber((long)quantity) : MEGATranslations.ALot.text().m_130948_(Tooltips.NUMBER_TEXT)})));
        } else {
            lines.add((Component)Tooltips.of((Component)MEGATranslations.Empty.text()));
        }
        if (filterItem != null) {
            if (storedItem == null) {
                lines.add((Component)Tooltips.of((Component)MEGATranslations.PartitionedFor.text(new Object[]{filterItem.getDisplayName()})));
            } else if (!storedItem.equals(filterItem)) {
                lines.add((Component)MEGATranslations.MismatchedFilter.text().m_130940_(ChatFormatting.DARK_RED));
            }
        } else {
            lines.add((Component)Tooltips.of((Component)MEGATranslations.NotPartitioned.text()));
        }
        lines.add((Component)Tooltips.of((Component)MEGATranslations.Compression.text(new Object[]{handler.compressionEnabled ? MEGATranslations.Enabled.text().m_130940_(ChatFormatting.GREEN) : MEGATranslations.Disabled.text().m_130940_(ChatFormatting.RED)})));
    }
}

