/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.world.feature;

import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.world.feature.ForceFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class ForceFeatureConfigs {
    private static final BlockState FORCE_LOG = ((Block)ForceRegistry.FORCE_LOG.get()).m_49966_();
    private static final BlockState FORCE_LEAVES = ((Block)ForceRegistry.FORCE_LEAVES.get()).m_49966_();
    private static final BlockState FORCE_ORE = ((Block)ForceRegistry.POWER_ORE.get()).m_49966_();
    private static final BlockState DEEPSLATE_FORCE_ORE = ((Block)ForceRegistry.DEEPSLATE_POWER_ORE.get()).m_49966_();
    private static final List<OreConfiguration.TargetBlockState> ORE_FORCE_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)FORCE_ORE), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)DEEPSLATE_FORCE_ORE));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_FORCE = FeatureUtils.m_206488_((String)"forcecraft:ore_force", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_FORCE_TARGET_LIST, 6));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_FORCE_BURIED = FeatureUtils.m_206488_((String)"forcecraft:ore_force_buried", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_FORCE_TARGET_LIST, 6, 1.0f));
    public static final Holder<PlacedFeature> PLACED_ORE_FORCE = PlacementUtils.m_206509_((String)"forcecraft:ore_force", ORE_FORCE, ForceFeatureConfigs.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-24), (VerticalAnchor)VerticalAnchor.m_158922_((int)48))));
    public static final Holder<PlacedFeature> PLACED_ORE_FORCE_BURIED = PlacementUtils.m_206509_((String)"forcecraft:ore_force_buried", ORE_FORCE_BURIED, ForceFeatureConfigs.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
    public static final Holder<ConfiguredFeature<TreeConfiguration, ?>> FORCE_TREE = FeatureUtils.m_206488_((String)"forcecraft:force_tree", (Feature)((Feature)ForceFeatures.FORCE_TREE.get()), (FeatureConfiguration)ForceFeatureConfigs.createForceTree().m_68251_());
    private static final BeehiveDecorator BEEHIVE_005 = new BeehiveDecorator(0.05f);
    public static final Holder<ConfiguredFeature<TreeConfiguration, ?>> FORCE_TREE_WITH_MORE_BEEHIVES_CONFIG = FeatureUtils.m_206488_((String)"forcecraft:force_tree_with_bees", (Feature)((Feature)ForceFeatures.FORCE_TREE.get()), (FeatureConfiguration)ForceFeatureConfigs.createForceTree().m_68249_(List.of(BEEHIVE_005)).m_68251_());
    public static final Holder<PlacedFeature> PLACED_FORCE_TREE = PlacementUtils.m_206509_((String)"forcecraft:force_tree", FORCE_TREE, (List)VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)3), (Block)((Block)ForceRegistry.FORCE_SAPLING.get())));
    public static final Holder<PlacedFeature> PLACED_FORCE_TREE_BEES_002 = PlacementUtils.m_206509_((String)"forcecraft:force_tree_bees_002", FORCE_TREE_WITH_MORE_BEEHIVES_CONFIG, (List)VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)3), (Block)((Block)ForceRegistry.FORCE_SAPLING.get())));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_FORCE = FeatureUtils.m_206488_((String)"forcecraft:trees_force", (Feature)Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PLACED_FORCE_TREE_BEES_002, 0.2f)), PLACED_FORCE_TREE));

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier1, PlacementModifier modifier2) {
        return List.of(modifier1, InSquarePlacement.m_191715_(), modifier2, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return ForceFeatureConfigs.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier);
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(BlockState trunkState, BlockState foliageState, int baseHeight, int heightRandA, int heightRandB, int p_195152_) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)trunkState), (TrunkPlacer)new StraightTrunkPlacer(baseHeight, heightRandA, heightRandB), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)foliageState), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)p_195152_), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createForceTree() {
        return ForceFeatureConfigs.createStraightBlobTree(FORCE_LOG, FORCE_LEAVES, 4, 2, 0, 2).m_68244_();
    }

    public static void initialize() {
    }
}

