/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.util;

import java.util.function.Predicate;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerUtils {
    public static ItemStack getFirstItem(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasItems(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return false;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public static boolean isFull(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return true;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!stack.m_41619_() && stack.m_41613_() >= stack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return true;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static int getUsedSlots(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return 0;
        }
        int usedSlots = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ++usedSlots;
        }
        return usedSlots;
    }

    public static boolean extractStackFromPlayer(Inventory inventory, IItemHandler targetHandler, Predicate<ItemStack> stackPredicate) {
        if (targetHandler != null) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (!stackPredicate.test(stack)) continue;
                ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)stack, (boolean)false);
                inventory.m_6836_(i, restStack);
                return true;
            }
        }
        return false;
    }

    public static ItemStack getAndSplit(IItemHandler itemhandler, int index, int amount) {
        return index >= 0 && index < itemhandler.getSlots() && !itemhandler.getStackInSlot(index).m_41619_() && amount > 0 ? itemhandler.getStackInSlot(index).m_41620_(amount) : ItemStack.f_41583_;
    }

    public static ItemStack getAndRemove(IItemHandler itemhandler, int index) {
        if (index >= 0 && index < itemhandler.getSlots() && itemhandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)itemhandler;
            modifiable.setStackInSlot(index, ItemStack.f_41583_);
            return modifiable.getStackInSlot(index);
        }
        return ItemStack.f_41583_;
    }
}

