/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.storage;

import com.mrbysco.forcecraft.capabilities.pack.PackItemStackHandler;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class PackStorage {
    private final UUID uuid;
    private final PackItemStackHandler inventory;
    private final LazyOptional<IItemHandler> optional;

    public PackStorage(UUID uuid) {
        this.uuid = uuid;
        this.inventory = new PackItemStackHandler();
        this.optional = LazyOptional.of(() -> this.inventory);
    }

    public PackStorage(CompoundTag nbt) {
        this.uuid = nbt.m_128342_("uuid");
        this.inventory = new PackItemStackHandler();
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        this.optional = LazyOptional.of(() -> this.inventory);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public LazyOptional<IItemHandler> getOptional() {
        return this.optional;
    }

    public PackItemStackHandler getInventory() {
        return this.inventory;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("uuid", this.uuid);
        nbt.m_128359_("sUUID", this.uuid.toString());
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        return nbt;
    }
}

