/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrbysco.forcecraft.items.ExperienceTomeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;

public class TransmutationRecipe
implements CraftingRecipe {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeItems;
    private final boolean isSimple;

    public TransmutationRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.recipeItems = recipeItemsIn;
        this.isSimple = recipeItemsIn.stream().allMatch(Ingredient::isSimple);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ForceRecipeSerializers.TRANSMUTATION_SERIALIZER.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_() {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean m_5598_() {
        return false;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        StackedContents recipeitemhelper = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int stacks = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            ++stacks;
            if (itemstack.m_41720_() instanceof ForceRodItem) {
                if (this.isSimple) {
                    recipeitemhelper.m_36468_(itemstack, 1);
                    continue;
                }
                inputs.add(itemstack);
                continue;
            }
            if (itemstack.m_41720_() instanceof ExperienceTomeItem) {
                if (itemstack.m_41782_() && itemstack.m_41783_().m_128451_("Experience") < 100) {
                    return false;
                }
                ItemStack experienceTome = new ItemStack((ItemLike)ForceRegistry.EXPERIENCE_TOME.get());
                CompoundTag nbt = experienceTome.m_41784_();
                nbt.m_128405_("Experience", 100);
                experienceTome.m_41751_(nbt);
                if (this.isSimple) {
                    recipeitemhelper.m_36468_(experienceTome, 1);
                    continue;
                }
                inputs.add(experienceTome);
                continue;
            }
            if (itemstack.m_41768_()) continue;
            if (this.isSimple) {
                recipeitemhelper.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return stacks == this.recipeItems.size() && (this.isSimple ? recipeitemhelper.m_36475_((Recipe)this, (IntList)null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack resultStack = this.recipeOutput.m_41777_();
        for (int j = 0; j < inv.m_6643_(); ++j) {
            Map enchantmentMap;
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41720_() instanceof ExperienceTomeItem) {
                CompoundTag tag = itemstack.m_41784_();
                int experience = tag.m_128451_("Experience");
                int count = Math.min((int)((float)experience / 100.0f), 64);
                resultStack.m_41764_(count);
            }
            if (!(itemstack.m_41720_() instanceof EnchantedBookItem) || !(resultStack.m_41720_() instanceof ExperienceBottleItem) || (enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)itemstack)).isEmpty()) continue;
            int amount = 0;
            for (Map.Entry entry : enchantmentMap.entrySet()) {
                amount += ((Integer)entry.getValue()).intValue();
            }
            resultStack.m_41764_(Mth.m_14045_((int)amount, (int)1, (int)64));
        }
        return resultStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack1;
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)itemstack.getCraftingRemainingItem());
                continue;
            }
            if (itemstack.m_41720_() instanceof ForceRodItem) {
                itemstack1 = itemstack.m_41777_();
                ForceRodItem rod = (ForceRodItem)itemstack1.m_41720_();
                int damage = rod.damageItem(itemstack1, 1);
                if (itemstack1.m_41720_().getDamage(itemstack1) >= itemstack1.m_41776_()) {
                    itemstack1.m_41774_(1);
                    continue;
                }
                itemstack1.m_41721_(itemstack1.m_41773_() + damage);
                nonnulllist.set(i, (Object)itemstack1);
                continue;
            }
            if (!(itemstack.m_41720_() instanceof ExperienceTomeItem)) continue;
            itemstack1 = itemstack.m_41777_();
            CompoundTag tag = itemstack.m_41784_();
            int experience = tag.m_128451_("Experience");
            int count = (int)((float)experience / 100.0f);
            int newExperience = count > 64 ? experience - 6400 : experience - count * 100;
            tag.m_128405_("Experience", newExperience);
            itemstack1.m_41751_(tag);
            nonnulllist.set(i, (Object)itemstack1);
        }
        return nonnulllist;
    }

    public static class SerializerTransmutationRecipe
    implements RecipeSerializer<TransmutationRecipe> {
        public TransmutationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = SerializerTransmutationRecipe.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new TransmutationRecipe(recipeId, s, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public TransmutationRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            int i = buffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemstack = buffer.m_130267_();
            return new TransmutationRecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf buffer, TransmutationRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.recipeOutput);
        }
    }
}

