/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.forcerod.ForceRodCapability;
import com.mrbysco.forcecraft.capabilities.forcerod.IForceRodModifier;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.items.nonburnable.InertCoreItem;
import com.mrbysco.forcecraft.items.nonburnable.NonBurnableItemEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ForceRodItem
extends BaseItem
implements IForceChargingTool {
    public List<Reference.MODIFIERS> applicableModifiers = new ArrayList<Reference.MODIFIERS>();

    public ForceRodItem(Item.Properties properties) {
        super(properties.m_41503_(75));
        this.setApplicableModifiers();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        Player player = context.m_43723_();
        InteractionHand handIn = context.m_43724_();
        ItemStack stack = context.m_43722_();
        if (!level.f_46443_ && player != null) {
            if (level.m_8055_(pos).m_60734_() instanceof FireBlock) {
                level.m_7471_(pos, false);
                List list = level.m_45976_(ItemEntity.class, new AABB(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_82363_(0.5, 1.0, 0.5));
                boolean bw = false;
                for (ItemEntity itemEntity : list) {
                    if (itemEntity == null || !(itemEntity.m_32055_().m_41720_() instanceof InertCoreItem)) continue;
                    NonBurnableItemEntity bottledWither = new NonBurnableItemEntity(level, pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_(), new ItemStack((ItemLike)ForceRegistry.BOTTLED_WITHER.get(), itemEntity.m_32055_().m_41613_()));
                    level.m_7967_((Entity)bottledWither);
                    stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                    bw = true;
                }
                if (bw) {
                    for (ItemEntity itemEntity : list) {
                        if (itemEntity == null || !(itemEntity.m_32055_().m_41720_() instanceof InertCoreItem)) continue;
                        itemEntity.m_146870_();
                    }
                }
            } else {
                List list = level.m_45976_(ItemEntity.class, new AABB(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_82363_(0.5, 1.0, 0.5));
                for (ItemEntity itemEntity : list) {
                    if (itemEntity == null || !(itemEntity.m_32055_().m_41720_() instanceof ArmorItem)) continue;
                    if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40402_() == EquipmentSlot.CHEST) {
                        if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.IRON) {
                            itemEntity.m_146870_();
                            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42416_, 6)));
                            stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        } else if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.GOLD) {
                            itemEntity.m_146870_();
                            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42417_, 6)));
                            stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        } else if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.LEATHER) {
                            itemEntity.m_146870_();
                            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)ForceRegistry.FORCE_CHEST.get(), 1)));
                            stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        }
                    }
                    if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40402_() == EquipmentSlot.LEGS) {
                        if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.IRON) {
                            itemEntity.m_146870_();
                            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42416_, 5)));
                            stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        } else if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.GOLD) {
                            itemEntity.m_146870_();
                            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42417_, 5)));
                            stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        } else if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.LEATHER) {
                            itemEntity.m_146870_();
                            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)ForceRegistry.FORCE_LEGS.get(), 1)));
                            stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        }
                    }
                    if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40402_() == EquipmentSlot.FEET) {
                        if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.IRON) {
                            itemEntity.m_146870_();
                            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42416_, 3)));
                            stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        } else if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.GOLD) {
                            itemEntity.m_146870_();
                            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42417_, 3)));
                            stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        } else if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.LEATHER) {
                            itemEntity.m_146870_();
                            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)ForceRegistry.FORCE_BOOTS.get(), 1)));
                            stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        }
                    }
                    if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40402_() != EquipmentSlot.HEAD) continue;
                    if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.IRON) {
                        itemEntity.m_146870_();
                        level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42416_, 4)));
                        stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        continue;
                    }
                    if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() == ArmorMaterials.GOLD) {
                        itemEntity.m_146870_();
                        level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42417_, 4)));
                        stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                        continue;
                    }
                    if (((ArmorItem)itemEntity.m_32055_().m_41720_()).m_40401_() != ArmorMaterials.LEATHER) continue;
                    itemEntity.m_146870_();
                    level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)ForceRegistry.FORCE_HELMET.get(), 1)));
                    stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                }
            }
        }
        stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).ifPresent(cap -> {
            if (cap.hasEnderModifier()) {
                if (player.m_6144_()) {
                    cap.setHomeLocation(GlobalPos.m_122643_((ResourceKey)player.f_19853_.m_46472_(), (BlockPos)player.m_20183_()));
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237115_((String)"forcecraft.ender_rod.location.set").m_130940_(ChatFormatting.DARK_PURPLE), true);
                    }
                } else if (cap.getHomeLocation() != null) {
                    cap.teleportPlayerToLocation(player, cap.getHomeLocation());
                    stack.m_41622_(1, (LivingEntity)player, playerIn -> player.m_21190_(handIn));
                    player.m_36335_().m_41524_((Item)this, 10);
                    level.m_6263_((Player)null, player.f_19854_, player.f_19855_, player.f_19856_, SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
                    player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
        });
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn != null) {
            stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).ifPresent(cap -> {
                if (cap.getHealingLevel() > 0) {
                    int healingLevel = cap.getHealingLevel();
                    playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, healingLevel - 1, false, false));
                    stack.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(handIn));
                    playerIn.m_36335_().m_41524_((Item)this, 10);
                }
                if (cap.hasCamoModifier()) {
                    playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 1000, 0, false, false));
                    stack.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(handIn));
                    playerIn.m_36335_().m_41524_((Item)this, 10);
                }
                if (cap.hasEnderModifier()) {
                    if (playerIn.m_6144_()) {
                        cap.setHomeLocation(GlobalPos.m_122643_((ResourceKey)playerIn.f_19853_.m_46472_(), (BlockPos)playerIn.m_20183_()));
                    } else if (cap.getHomeLocation() != null) {
                        cap.teleportPlayerToLocation(playerIn, cap.getHomeLocation());
                        stack.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(handIn));
                        playerIn.m_36335_().m_41524_((Item)this, 10);
                        level.m_6263_((Player)null, playerIn.f_19854_, playerIn.f_19855_, playerIn.f_19856_, SoundEvents.f_11852_, playerIn.m_5720_(), 1.0f, 1.0f);
                        playerIn.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    }
                }
                if (cap.hasSightModifier()) {
                    playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 1000, 0, false, false));
                    stack.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(handIn));
                    playerIn.m_36335_().m_41524_((Item)this, 10);
                }
                if (cap.hasLight()) {
                    playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 1000, 0, false, false));
                    stack.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(handIn));
                    playerIn.m_36335_().m_41524_((Item)this, 10);
                }
                if (cap.getSpeedLevel() > 0) {
                    playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, cap.getSpeedLevel() - 1, false, false));
                    stack.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(handIn));
                    playerIn.m_36335_().m_41524_((Item)this, 10);
                }
            });
        }
        return super.m_7203_(level, playerIn, handIn);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand handIn) {
        if (playerIn != null) {
            stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).ifPresent(cap -> {
                if (cap.hasLight()) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2400, 0, false, false));
                    stack.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(handIn));
                    playerIn.m_36335_().m_41524_((Item)this, 10);
                }
            });
        }
        return super.m_6880_(stack, playerIn, target, handIn);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (CapabilityHandler.CAPABILITY_FORCEROD == null) {
            return null;
        }
        return new ForceRodCapability();
    }

    public void setApplicableModifiers() {
        this.applicableModifiers.add(Reference.MODIFIERS.MOD_HEALING);
        this.applicableModifiers.add(Reference.MODIFIERS.MOD_ENDER);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        IForceRodModifier cap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = ForceRodCapability.writeNBT(cap);
            nbt.m_128365_("forcecraft", (Tag)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null || !nbt.m_128441_("forcecraft")) {
            return;
        }
        IForceRodModifier cap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = nbt.m_128469_("forcecraft");
            ForceRodCapability.readNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ForceRodCapability.attachInformation(stack, lores);
        super.m_7373_(stack, level, lores, flagIn);
    }
}

