/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.google.common.collect.Lists;
import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.capabilities.toolmodifier.ToolModCapability;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.registry.material.ModToolTiers;
import com.mrbysco.forcecraft.util.ForceUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForceAxeItem
extends AxeItem
implements IForceChargingTool {
    public ForceAxeItem(Item.Properties properties) {
        super(ModToolTiers.FORCE, 0.0f, -3.1f, properties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (CapabilityHandler.CAPABILITY_TOOLMOD == null) {
            return null;
        }
        return new ToolModCapability();
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        IToolModifier toolModifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (toolModifierCap != null && toolModifierCap.hasLumberjack() && player != null && ForceUtils.isTree(player.m_20193_(), pos)) {
            return ForceAxeItem.fellTree(stack, pos, player);
        }
        return false;
    }

    public static boolean fellTree(ItemStack stack, BlockPos pos, Player player) {
        if (player.m_20193_().f_46443_) {
            return true;
        }
        MinecraftForge.EVENT_BUS.register((Object)new TreeChopTask(stack, pos, player, 10));
        return true;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = ToolModCapability.writeNBT(cap);
            nbt.m_128365_("forcecraft", (Tag)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null || !nbt.m_128441_("forcecraft")) {
            return;
        }
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = nbt.m_128469_("forcecraft");
            ToolModCapability.readNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ToolModCapability.attachInformation(stack, lores);
        super.m_7373_(stack, level, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public static class TreeChopTask {
        public final Level world;
        public final Player player;
        public final ItemStack tool;
        public final int blocksPerTick;
        public Queue<BlockPos> blocks = Lists.newLinkedList();
        public Set<BlockPos> visited = new HashSet<BlockPos>();

        public TreeChopTask(ItemStack tool, BlockPos start, Player player, int blocksPerTick) {
            this.world = player.m_20193_();
            this.player = player;
            this.tool = tool;
            this.blocksPerTick = blocksPerTick;
            this.blocks.add(start);
        }

        @SubscribeEvent
        public void chop(TickEvent.LevelTickEvent event) {
            if (event.side.isClient()) {
                this.finish();
                return;
            }
            if (event.level.m_46472_().m_135782_().equals((Object)this.world.m_46472_().m_135782_())) {
                return;
            }
            int left = this.blocksPerTick;
            while (left > 0) {
                if (this.blocks.isEmpty()) {
                    this.finish();
                    return;
                }
                BlockPos pos = this.blocks.remove();
                if (!this.visited.add(pos) || !ForceUtils.isLog(this.world, pos)) continue;
                for (Direction facing : new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
                    BlockPos pos2 = pos.m_121945_(facing);
                    if (this.visited.contains(pos2)) continue;
                    this.blocks.add(pos2);
                }
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        BlockPos pos2 = pos.m_7918_(-1 + x, 1, -1 + z);
                        if (this.visited.contains(pos2)) continue;
                        this.blocks.add(pos2);
                    }
                }
                ForceUtils.breakExtraBlock(this.tool, this.world, this.player, pos, pos);
                --left;
            }
        }

        private void finish() {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

