/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.experiencetome.ExperienceTomeCapability;
import com.mrbysco.forcecraft.util.ForceUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ExperienceTomeItem
extends Item {
    public static final int CAPACITY = Integer.MAX_VALUE;

    public ExperienceTomeItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"forcecraft.tooltip.press_shift"));
            return;
        }
        tooltip.add((Component)Component.m_237113_((String)(Float.toString(ExperienceTomeItem.getExperience(stack)) + " / " + Float.toString(ExperienceTomeItem.getMaxExperience(stack)))));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (CapabilityHandler.CAPABILITY_EXPTOME == null) {
            return null;
        }
        return new ExperienceTomeCapability();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ForceUtils.isFakePlayer((Entity)player) || hand != InteractionHand.MAIN_HAND || world.f_46443_) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        int curLevel = player.f_36078_;
        if (player.m_6144_()) {
            int exp = ExperienceTomeItem.getExtraPlayerExperience(player) > 0 ? Math.min(ExperienceTomeItem.getTotalExpForLevel(player.f_36078_ + 1) - ExperienceTomeItem.getTotalExpForLevel(player.f_36078_) - ExperienceTomeItem.getExtraPlayerExperience(player), ExperienceTomeItem.getExperience(stack)) : Math.min(ExperienceTomeItem.getTotalExpForLevel(player.f_36078_ + 1) - ExperienceTomeItem.getTotalExpForLevel(player.f_36078_), ExperienceTomeItem.getExperience(stack));
            ExperienceTomeItem.setPlayerExperience(player, ExperienceTomeItem.getPlayerExperience(player) + exp);
            if (player.f_36078_ < curLevel + 1 && ExperienceTomeItem.getPlayerExperience(player) >= ExperienceTomeItem.getTotalExpForLevel(curLevel + 1)) {
                ExperienceTomeItem.setPlayerLevel(player, curLevel + 1);
            }
            ExperienceTomeItem.modifyExperience(stack, -exp);
        } else if (ExperienceTomeItem.getExtraPlayerExperience(player) > 0) {
            int exp = Math.min(ExperienceTomeItem.getExtraPlayerExperience(player), ExperienceTomeItem.getSpace(stack));
            ExperienceTomeItem.setPlayerExperience(player, ExperienceTomeItem.getPlayerExperience(player) - exp);
            if (player.f_36078_ < curLevel) {
                ExperienceTomeItem.setPlayerLevel(player, curLevel);
            }
            ExperienceTomeItem.modifyExperience(stack, exp);
        } else if (player.f_36078_ > 0) {
            int exp = Math.min(ExperienceTomeItem.getTotalExpForLevel(player.f_36078_) - ExperienceTomeItem.getTotalExpForLevel(player.f_36078_ - 1), ExperienceTomeItem.getSpace(stack));
            ExperienceTomeItem.setPlayerExperience(player, ExperienceTomeItem.getPlayerExperience(player) - exp);
            if (player.f_36078_ < curLevel - 1) {
                ExperienceTomeItem.setPlayerLevel(player, curLevel - 1);
            }
            ExperienceTomeItem.modifyExperience(stack, exp);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public static int getPlayerExperience(Player player) {
        return ExperienceTomeItem.getTotalExpForLevel(player.f_36078_) + ExperienceTomeItem.getExtraPlayerExperience(player);
    }

    public static int getLevelPlayerExperience(Player player) {
        return ExperienceTomeItem.getTotalExpForLevel(player.f_36078_);
    }

    public static int getExtraPlayerExperience(Player player) {
        return Math.round(player.f_36080_ * (float)player.m_36323_());
    }

    public static void setPlayerExperience(Player player, int exp) {
        player.f_36078_ = 0;
        player.f_36080_ = 0.0f;
        player.f_36079_ = 0;
        ExperienceTomeItem.addExperienceToPlayer(player, exp);
    }

    public static void setPlayerLevel(Player player, int level) {
        player.f_36078_ = level;
        player.f_36080_ = 0.0f;
    }

    public static void addExperienceToPlayer(Player player, int exp) {
        int i = Integer.MAX_VALUE - player.f_36079_;
        if (exp > i) {
            exp = i;
        }
        player.f_36080_ += (float)exp / (float)player.m_36323_();
        player.f_36079_ += exp;
        while (player.f_36080_ >= 1.0f) {
            player.f_36080_ = (player.f_36080_ - 1.0f) * (float)player.m_36323_();
            ExperienceTomeItem.addExperienceLevelToPlayer(player, 1);
            player.f_36080_ /= (float)player.m_36323_();
        }
    }

    public static void addExperienceLevelToPlayer(Player player, int levels) {
        player.f_36078_ += levels;
        if (player.f_36078_ < 0) {
            player.f_36078_ = 0;
            player.f_36080_ = 0.0f;
            player.f_36079_ = 0;
        }
    }

    public static int getTotalExpForLevel(int level) {
        return level >= 32 ? (9 * level * level - 325 * level + 4440) / 2 : (level >= 17 ? (5 * level * level - 81 * level + 720) / 2 : level * level + 6 * level);
    }

    public static void modifyExperience(ItemStack stack, int exp) {
        int storedExp = ExperienceTomeItem.getExperience(stack) + exp;
        if (storedExp > ExperienceTomeItem.getMaxExperience(stack)) {
            storedExp = ExperienceTomeItem.getMaxExperience(stack);
        } else if (storedExp < 0) {
            storedExp = 0;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Experience", storedExp);
        stack.m_41751_(tag);
    }

    public static int getExperience(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_().m_128451_("Experience");
    }

    public static int getMaxExperience(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public static int getSpace(ItemStack stack) {
        return ExperienceTomeItem.getMaxExperience(stack) - ExperienceTomeItem.getExperience(stack);
    }
}

