/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.registry.ForceSounds;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class FairyEntity
extends PathfinderMob
implements FlyingAnimal {
    public FairyEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new LookHelperController((Mob)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(8, (Goal)new WanderGoal());
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void m_6123_(Player playerEntity) {
        this.m_5496_(this.collideSound(playerEntity), 1.0f, 1.0f);
        playerEntity.m_5634_(Float.MAX_VALUE);
        this.m_146870_();
    }

    public static boolean canSpawnOn(EntityType<? extends Mob> typeIn, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.m_7495_();
        return reason == MobSpawnType.SPAWNER || level.m_8055_(blockpos).m_60643_((BlockGetter)level, blockpos, typeIn) && level.m_45524_(pos, 0) > 8;
    }

    public SoundEvent collideSound(Player playerEntity) {
        int randomInt = this.f_19853_.f_46441_.m_188503_(100);
        if (UUID.fromString("7135da42-d327-47bb-bb04-5ba4e212fb32").equals(playerEntity.m_20148_())) {
            return (SoundEvent)ForceSounds.FAIRY_PICKUP.get();
        }
        if (randomInt <= 1 && UUID.fromString("10755ea6-9721-467a-8b5c-92adf689072c").equals(playerEntity.m_20148_())) {
            return (SoundEvent)ForceSounds.FAIRY_LISTEN_SPECIAL.get();
        }
        if (randomInt <= 10) {
            return (SoundEvent)ForceSounds.FAIRY_LISTEN.get();
        }
        return (SoundEvent)ForceSounds.FAIRY_PICKUP.get();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19796_.m_188501_() < 0.05f && this.m_20184_() != Vec3.f_82478_) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.addParticle(this.f_19853_, this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)ParticleTypes.f_123759_);
            }
        }
    }

    private void addParticle(Level level, double posX, double posX2, double posZ, double posZ2, double posY, ParticleOptions particleData) {
        level.m_7106_(particleData, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)posX, (double)posX2), posY - (double)0.2f, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)posZ, (double)posZ2), 0.0, 0.0, 0.0);
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    static class LookHelperController
    extends LookControl {
        public LookHelperController(Mob entityIn) {
            super(entityIn);
        }

        public void m_8128_() {
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FairyEntity.this.f_21344_.m_26571_() && FairyEntity.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return FairyEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vector3d = this.getRandomLocation();
            if (vector3d != null) {
                FairyEntity.this.f_21344_.m_26536_(FairyEntity.this.f_21344_.m_7864_(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vector3d = FairyEntity.this.m_20252_(0.0f);
            Vec3 vector3d2 = HoverRandomPos.m_148465_((PathfinderMob)FairyEntity.this, (int)8, (int)7, (double)vector3d.f_82479_, (double)vector3d.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vector3d2 != null ? vector3d2 : AirAndWaterRandomPos.m_148357_((PathfinderMob)FairyEntity.this, (int)8, (int)4, (int)-2, (double)vector3d.f_82479_, (double)vector3d.f_82481_, (double)1.5707963705062866);
        }
    }
}

