/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities;

import com.mrbysco.forcecraft.blocks.engine.ForceEngineBlock;
import com.mrbysco.forcecraft.capabilities.FluidHandlerWrapper;
import com.mrbysco.forcecraft.capabilities.ItemStackHandlerWrapper;
import com.mrbysco.forcecraft.menu.engine.ForceEngineMenu;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ForceEngineBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int MAX_FLUID = 10000;
    protected FluidTank tankFuel = new FluidTank(10000){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!ForceEngineBlockEntity.this.isFluidEqual((FluidTank)this, resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = this.getFluidAmount() - resource.getAmount() < 0 ? this.getFluidAmount() : resource.getAmount();
                return new FluidStack(this.getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            ForceEngineBlockEntity.this.refreshClient();
        }

        public boolean isFluidValid(FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.m_205067_(ForceTags.FORCE) || fluid.m_205067_(FluidTags.f_13132_) || fluid.m_205067_(ForceTags.FUEL) || fluid.m_205067_(ForceTags.BIOFUEL);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.m_205067_(ForceTags.FORCE) || fluid.m_205067_(FluidTags.f_13132_) || fluid.m_205067_(ForceTags.FUEL) || fluid.m_205067_(ForceTags.BIOFUEL);
        }
    };
    protected FluidTank tankThrottle = new FluidTank(10000){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!ForceEngineBlockEntity.this.isFluidEqual((FluidTank)this, resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = this.getFluidAmount() - resource.getAmount() < 0 ? this.getFluidAmount() : resource.getAmount();
                return new FluidStack(this.getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            ForceEngineBlockEntity.this.refreshClient();
        }

        public boolean isFluidValid(FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.m_6212_((Fluid)Fluids.f_76193_) || fluid.m_205067_(ForceTags.MILK);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid.m_6212_((Fluid)Fluids.f_76193_) || fluid.m_205067_(ForceTags.MILK);
        }
    };
    private FluidHandlerWrapper tankWrapper = new FluidHandlerWrapper(this.tankThrottle, this.tankFuel);
    private LazyOptional<IFluidHandler> tankWrapperCap = LazyOptional.of(() -> this.tankWrapper);
    public final ItemStackHandler inputHandler = new ItemStackHandler(2){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && stack.m_41741_() > 1) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            IFluidHandler fluidCap = (IFluidHandler)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
            if (slot == 0) {
                FluidStack fluidStack;
                if (fluidCap != null && !(fluidStack = fluidCap.getFluidInTank(0)).isEmpty()) {
                    Fluid fluid = fluidStack.getFluid();
                    return fluid.m_205067_(ForceTags.FORCE) || fluid.m_205067_(FluidTags.f_13132_) || fluid.m_205067_(ForceTags.FUEL) || fluid.m_205067_(ForceTags.BIOFUEL);
                }
                return stack.m_204117_(ForceTags.FORGE_GEM) || stack.m_204117_(Tags.Items.NETHER_STARS) || fluidCap != null && fluidCap.getFluidInTank(0).getFluid().m_205067_(ForceTags.FORCE);
            }
            if (slot == 1) {
                FluidStack fluidStack;
                if (fluidCap != null && !(fluidStack = fluidCap.getFluidInTank(0)).isEmpty()) {
                    Fluid fluid = fluidStack.getFluid();
                    return fluid.m_6212_((Fluid)Fluids.f_76193_) || fluid.m_205067_(ForceTags.MILK);
                }
                return false;
            }
            return false;
        }
    };
    public final ItemStackHandler outputHandler = new ItemStackHandler(2){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && stack.m_41741_() > 1) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    };
    private ItemStackHandlerWrapper stackWrapper = new ItemStackHandlerWrapper(this.inputHandler, this.outputHandler);
    private LazyOptional<IItemHandler> stackWrapperCap = LazyOptional.of(() -> this.stackWrapper);
    private static final int FLUID_PER_GEM = 500;
    public int processTime = 0;
    public int maxProcessTime = 20;
    public int throttleTime = 0;
    public int maxThrottleTime = 10;
    private Fluid cachedFuel;
    private Fluid cachedThrottle;
    public float generating = 0.0f;

    public ForceEngineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public ForceEngineBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ForceRegistry.FORCE_ENGINE_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.processTime = nbt.m_128451_("processTime");
        this.maxProcessTime = nbt.m_128451_("maxProcessTime");
        this.throttleTime = nbt.m_128451_("throttleTime");
        this.maxThrottleTime = nbt.m_128451_("maxThrottleTime");
        this.generating = nbt.m_128457_("generating");
        this.stackWrapper.deserializeNBT(nbt.m_128469_("stackHandler"));
        this.tankWrapper.deserializeNBT(nbt.m_128469_("fluid"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("processTime", this.processTime);
        compound.m_128405_("maxProcessTime", this.maxProcessTime);
        compound.m_128405_("throttleTime", this.throttleTime);
        compound.m_128405_("maxThrottleTime", this.maxThrottleTime);
        compound.m_128350_("generating", this.generating);
        compound.m_128365_("stackHandler", (Tag)this.stackWrapper.serializeNBT());
        compound.m_128365_("fluid", (Tag)this.tankWrapper.serializeNBT());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"forcecraft.container.force_engine");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
        return new ForceEngineMenu(id, playerInv, this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ForceEngineBlockEntity forceEngine) {
        if (!forceEngine.inputHandler.getStackInSlot(0).m_41619_()) {
            forceEngine.processFuelSlot();
            forceEngine.refreshClient();
        }
        if (!forceEngine.inputHandler.getStackInSlot(1).m_41619_()) {
            forceEngine.processThrottleSlot();
            forceEngine.refreshClient();
        }
        if (forceEngine.isActive() && forceEngine.canWork()) {
            forceEngine.checkFluids();
            if (forceEngine.getFuelAmount() > 0) {
                ++forceEngine.processTime;
                forceEngine.insertPower();
                if (forceEngine.processTime >= forceEngine.maxProcessTime) {
                    forceEngine.tankFuel.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    forceEngine.processTime = 0;
                }
            }
            if (forceEngine.getThrottleAmount() > 0) {
                ++forceEngine.throttleTime;
                if (forceEngine.throttleTime >= forceEngine.maxThrottleTime) {
                    forceEngine.tankThrottle.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    forceEngine.throttleTime = 0;
                }
            }
            forceEngine.refreshClient();
        } else if (forceEngine.processTime != 0) {
            forceEngine.processTime = 0;
        }
    }

    public void checkFluids() {
        if (this.cachedFuel == null || !this.getFuelFluid().m_6212_(this.cachedFuel)) {
            this.cachedFuel = this.getFuelFluid();
            this.reevaluateValues();
        }
        if (this.cachedThrottle == null || !this.getThrottleFluid().m_6212_(this.cachedThrottle)) {
            this.cachedThrottle = this.getThrottleFluid();
            this.reevaluateValues();
        }
    }

    public void reevaluateValues() {
        if (this.cachedFuel != null) {
            FluidStack fuelStack = this.getFuelFluidStack();
            this.processTime = 0;
            this.maxProcessTime = this.getTimePerFuelMB(fuelStack);
            this.generating = this.getPowerForFluid(fuelStack);
            this.throttleTime = 0;
            this.maxThrottleTime = this.getTimePerThrottleMB(this.getThrottleFluidStack());
        }
        this.refreshClient();
    }

    private float getThrottleValue() {
        FluidStack throttleStack = this.getThrottleFluidStack();
        if (!throttleStack.isEmpty()) {
            Fluid fluid = throttleStack.getFluid();
            if (fluid.m_205067_(ForceTags.MILK)) {
                return 2.5f;
            }
            if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
                return 2.0f;
            }
        }
        return 1.0f;
    }

    public int getPowerForFluid(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            float throttleValue = this.getThrottleValue();
            Fluid fluid = fluidStack.getFluid();
            if (fluid.m_205067_(ForceTags.FORCE)) {
                return (int)(20.0f * throttleValue);
            }
            if (fluid.m_205067_(FluidTags.f_13132_)) {
                return (int)(5.0f * throttleValue);
            }
            if (fluid.m_205067_(ForceTags.FUEL)) {
                return (int)(10.0f * throttleValue);
            }
            if (fluid.m_205067_(ForceTags.BIOFUEL)) {
                return (int)(15.0f * throttleValue);
            }
        }
        return 0;
    }

    public int getTimePerFuelMB(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            if (fluid.m_205067_(ForceTags.FORCE)) {
                return 20;
            }
            if (fluid.m_205067_(FluidTags.f_13132_)) {
                return 20;
            }
            if (fluid.m_205067_(ForceTags.FUEL)) {
                return 20;
            }
            if (fluid.m_205067_(ForceTags.BIOFUEL)) {
                return 20;
            }
        }
        return 0;
    }

    public int getTimePerThrottleMB(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            if (fluid.m_205067_(ForceTags.MILK)) {
                return 5;
            }
            if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
                return 5;
            }
        }
        return 0;
    }

    public boolean isActive() {
        return this.m_58900_().m_60734_() instanceof ForceEngineBlock && (Boolean)this.m_58900_().m_61143_((Property)ForceEngineBlock.ACTIVE) != false;
    }

    public Direction getFacing() {
        if (this.m_58900_().m_60734_() instanceof ForceEngineBlock) {
            return (Direction)this.m_58900_().m_61143_((Property)ForceEngineBlock.f_52588_);
        }
        return Direction.NORTH;
    }

    public boolean canWork() {
        IEnergyStorage cap;
        BlockPos offsetPos = this.f_58858_.m_121945_(this.getFacing());
        BlockEntity tile = this.f_58857_.m_7702_(offsetPos);
        if (tile != null && (cap = (IEnergyStorage)tile.getCapability(ForgeCapabilities.ENERGY, this.getFacing().m_122424_()).orElse(null)) != null) {
            return cap.canReceive() && cap.getEnergyStored() < cap.getMaxEnergyStored() && !this.tankFuel.getFluid().isEmpty();
        }
        return false;
    }

    public void insertPower() {
        IEnergyStorage cap;
        BlockPos offsetPos = this.f_58858_.m_121945_(this.getFacing());
        BlockEntity tile = this.f_58857_.m_7702_(offsetPos);
        if (tile != null && (cap = (IEnergyStorage)tile.getCapability(ForgeCapabilities.ENERGY, this.getFacing().m_122424_()).orElse(null)) != null && cap.canReceive() && cap.getEnergyStored() < cap.getMaxEnergyStored()) {
            cap.receiveEnergy((int)this.generating, false);
        }
    }

    private void processFuelSlot() {
        FluidActionResult result;
        ItemStack slotStack = this.stackWrapper.getStackInSlot(0);
        if (slotStack.m_204117_(ForceTags.FORGE_GEM)) {
            FluidStack force = new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 500);
            if (this.getFuelAmount() + force.getAmount() <= this.tankFuel.getCapacity()) {
                this.fillFuel(force, IFluidHandler.FluidAction.EXECUTE);
                slotStack.m_41774_(1);
            }
        } else if (slotStack.m_204117_(Tags.Items.NETHER_STARS)) {
            FluidStack force = new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 5000);
            ItemStack extraSlot = this.outputHandler.getStackInSlot(0);
            if (this.getFuelAmount() + force.getAmount() <= this.tankFuel.getCapacity() && extraSlot.m_41613_() < this.inputHandler.getSlotLimit(1)) {
                this.fillFuel(force, IFluidHandler.FluidAction.EXECUTE);
                slotStack.m_41774_(1);
                if (this.outputHandler.getStackInSlot(0).m_41619_()) {
                    this.outputHandler.setStackInSlot(0, new ItemStack((ItemLike)ForceRegistry.INERT_CORE.get()));
                } else {
                    extraSlot.m_41764_(extraSlot.m_41613_() + 1);
                }
            }
        } else if (this.outputHandler.getStackInSlot(0).m_41619_() && (result = FluidUtil.tryEmptyContainer((ItemStack)slotStack, (IFluidHandler)this.tankFuel, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
            slotStack.m_41774_(1);
            this.outputHandler.setStackInSlot(0, result.getResult());
        }
    }

    public int fillFuel(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack resourceCopy = resource.copy();
        if (action.execute() && (this.tankFuel.getFluid().isEmpty() || this.tankFuel.getFluid().isFluidEqual(resource))) {
            this.tankFuel.fill(resourceCopy, action);
        }
        return resource.getAmount();
    }

    private void processThrottleSlot() {
        FluidActionResult result;
        ItemStack slotStack = this.inputHandler.getStackInSlot(1);
        if (this.outputHandler.getStackInSlot(1).m_41619_() && (result = FluidUtil.tryEmptyContainer((ItemStack)slotStack, (IFluidHandler)this.tankThrottle, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
            slotStack.m_41774_(1);
            this.outputHandler.setStackInSlot(1, result.getResult());
        }
    }

    public int fillThrottle(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack resourceCopy = resource.copy();
        if (action.execute() && (this.tankThrottle.getFluid().isEmpty() || this.tankThrottle.getFluid().isFluidEqual(resource))) {
            this.tankThrottle.fill(resourceCopy, action);
        }
        return resource.getAmount();
    }

    public Fluid getFuelFluid() {
        return this.getFuelFluidStack().getFluid();
    }

    public FluidStack getFuelFluidStack() {
        return this.tankFuel.getFluid();
    }

    public int getFuelAmount() {
        return this.tankFuel.getFluidAmount();
    }

    public void setFuelAmount(int amount) {
        if (amount > 0) {
            if (!this.tankFuel.getFluid().isEmpty()) {
                this.tankFuel.getFluid().setAmount(amount);
            }
        } else {
            this.tankFuel.setFluid(FluidStack.EMPTY);
        }
    }

    public Fluid getThrottleFluid() {
        return this.getThrottleFluidStack().getFluid();
    }

    public FluidStack getThrottleFluidStack() {
        return this.tankThrottle.getFluid();
    }

    public int getThrottleAmount() {
        return this.tankThrottle.getFluidAmount();
    }

    public void setThrottleAmount(int amount) {
        if (amount > 0) {
            if (!this.tankThrottle.getFluid().isEmpty()) {
                this.tankThrottle.getFluid().setAmount(amount);
            }
        } else {
            this.tankThrottle.setFluid(FluidStack.EMPTY);
        }
    }

    protected boolean isFluidEqual(FluidTank fluidTank, FluidStack fluid) {
        return this.isFluidEqual(fluidTank, fluid.getFluid());
    }

    protected boolean isFluidEqual(FluidTank fluidTank, Fluid fluid) {
        return fluidTank.getFluid().getFluid().equals(fluid);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    private void refreshClient() {
        this.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.stackWrapperCap.cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankWrapperCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.stackWrapperCap.invalidate();
        this.tankWrapperCap.invalidate();
    }
}

