/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei;

import com.buuz135.industrial.api.recipe.ore.OreFluidEntryFermenter;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntryRaw;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntrySieve;
import com.buuz135.industrial.block.generator.MycelialGeneratorBlock;
import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.generator.tile.BioReactorTile;
import com.buuz135.industrial.block.resourceproduction.tile.MaterialStoneWorkFactoryTile;
import com.buuz135.industrial.fluid.OreTitaniumFluidType;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.gui.transporter.GuiTransporter;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.plugin.jei.category.BioReactorRecipeCategory;
import com.buuz135.industrial.plugin.jei.category.DissolutionChamberCategory;
import com.buuz135.industrial.plugin.jei.category.FermentationStationCategory;
import com.buuz135.industrial.plugin.jei.category.FluidExtractorCategory;
import com.buuz135.industrial.plugin.jei.category.FluidSieveCategory;
import com.buuz135.industrial.plugin.jei.category.LaserDrillFluidCategory;
import com.buuz135.industrial.plugin.jei.category.LaserDrillOreCategory;
import com.buuz135.industrial.plugin.jei.category.OreWasherCategory;
import com.buuz135.industrial.plugin.jei.category.StoneWorkCategory;
import com.buuz135.industrial.plugin.jei.category.StoneWorkGeneratorCategory;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorCategory;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.plugin.jei.machineproduce.MachineProduceCategory;
import com.buuz135.industrial.plugin.jei.machineproduce.MachineProduceWrapper;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.recipe.StoneWorkGenerateRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.util.RecipeUtil;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

@JeiPlugin
public class JEICustomPlugin
implements IModPlugin {
    private static IRecipesGui recipesGui;
    private BioReactorRecipeCategory bioReactorRecipeCategory;
    private LaserDrillOreCategory laserRecipeOreCategory;
    private LaserDrillFluidCategory laserDrillFluidCategory;
    private FluidExtractorCategory fluidExtractorCategory;
    private DissolutionChamberCategory dissolutionChamberJEICategory;
    private List<MycelialGeneratorCategory> mycelialGeneratorCategories;
    private StoneWorkCategory stoneWorkCategory;
    private MachineProduceCategory machineProduceCategory;
    private StoneWorkGeneratorCategory stoneWorkGeneratorCategory;
    private OreWasherCategory oreWasherCategory;
    private FermentationStationCategory fermentationStationCategory;
    private FluidSieveCategory fluidSieveCategory;

    public static void showUses(ItemStack stack) {
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)ModuleTool.INFINITY_DRILL.get(), (Item)ModuleTool.INFINITY_SAW.get(), (Item)ModuleTool.INFINITY_HAMMER.get(), (Item)ModuleTool.INFINITY_TRIDENT.get(), (Item)ModuleTool.INFINITY_BACKPACK.get(), (Item)ModuleTool.INFINITY_LAUNCHER.get(), (Item)ModuleTool.INFINITY_NUKE.get(), (Item)ModuleCore.EFFICIENCY_ADDON_1.get(), (Item)ModuleCore.EFFICIENCY_ADDON_2.get(), (Item)ModuleCore.SPEED_ADDON_1.get(), (Item)ModuleCore.SPEED_ADDON_2.get(), (Item)ModuleCore.PROCESSING_ADDON_1.get()});
        Arrays.stream(ModuleCore.RANGE_ADDONS).map(RegistryObject::get).forEach(xva$0 -> registration.useNbtForSubtypes(new Item[]{xva$0}));
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(GuiConveyor.class, (IGhostIngredientHandler)new IGhostIngredientHandler<GuiConveyor>(){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargets(GuiConveyor guiConveyor, I i, boolean b) {
                if (i instanceof ItemStack) {
                    return guiConveyor.getGhostSlots().stream().map(ghostSlot -> new IGhostIngredientHandler.Target<I>(){
                        final /* synthetic */ IFilter.GhostSlot val$ghostSlot;
                        {
                            this.val$ghostSlot = ghostSlot;
                        }

                        public Rect2i getArea() {
                            return this.val$ghostSlot.getArea();
                        }

                        public void accept(I stack) {
                            this.val$ghostSlot.accept((ItemStack)stack);
                        }
                    }).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }

            public void onComplete() {
            }
        });
        registration.addGhostIngredientHandler(GuiTransporter.class, (IGhostIngredientHandler)new IGhostIngredientHandler<GuiTransporter>(){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargets(GuiTransporter guiConveyor, I i, boolean b) {
                if (i instanceof ItemStack) {
                    return guiConveyor.getGhostSlots().stream().map(ghostSlot -> new IGhostIngredientHandler.Target<I>(){
                        final /* synthetic */ IFilter.GhostSlot val$ghostSlot;
                        {
                            this.val$ghostSlot = ghostSlot;
                        }

                        public Rect2i getArea() {
                            return this.val$ghostSlot.getArea();
                        }

                        public void accept(I stack) {
                            this.val$ghostSlot.accept((ItemStack)stack);
                        }
                    }).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }

            public void onComplete() {
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.bioReactorRecipeCategory = new BioReactorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), "Bioreactor accepted items");
        registry.addRecipeCategories(new IRecipeCategory[]{this.bioReactorRecipeCategory});
        this.fluidExtractorCategory = new FluidExtractorCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fluidExtractorCategory});
        this.dissolutionChamberJEICategory = new DissolutionChamberCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.dissolutionChamberJEICategory});
        this.laserRecipeOreCategory = new LaserDrillOreCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.laserRecipeOreCategory});
        this.laserDrillFluidCategory = new LaserDrillFluidCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.laserDrillFluidCategory});
        this.mycelialGeneratorCategories = new ArrayList<MycelialGeneratorCategory>();
        for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
            MycelialGeneratorCategory category = new MycelialGeneratorCategory(type, registry.getJeiHelpers().getGuiHelper());
            this.mycelialGeneratorCategories.add(category);
            registry.addRecipeCategories(new IRecipeCategory[]{category});
        }
        this.stoneWorkCategory = new StoneWorkCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.stoneWorkCategory});
        this.machineProduceCategory = new MachineProduceCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.machineProduceCategory});
        this.stoneWorkGeneratorCategory = new StoneWorkGeneratorCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.stoneWorkGeneratorCategory});
        this.oreWasherCategory = new OreWasherCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.oreWasherCategory});
        this.fermentationStationCategory = new FermentationStationCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fermentationStationCategory});
        this.fluidSieveCategory = new FluidSieveCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fluidSieveCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(IndustrialRecipeTypes.FLUID_EXTRACTOR, RecipeUtil.getRecipes((Level)Minecraft.m_91087_().f_91073_, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.FLUID_EXTRACTOR_TYPE.get())));
        registration.addRecipes(IndustrialRecipeTypes.DISSOLUTION, RecipeUtil.getRecipes((Level)Minecraft.m_91087_().f_91073_, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.DISSOLUTION_TYPE.get())));
        registration.addRecipes(IndustrialRecipeTypes.BIOREACTOR, this.generateBioreactorRecipes());
        registration.addRecipes(IndustrialRecipeTypes.LASER_ORE, RecipeUtil.getRecipes((Level)Minecraft.m_91087_().f_91073_, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.LASER_DRILL_TYPE.get())).stream().filter(laserDrillOreRecipe -> !laserDrillOreRecipe.output.m_43947_()).collect(Collectors.toList()));
        registration.addRecipes(IndustrialRecipeTypes.LASER_FLUID, RecipeUtil.getRecipes((Level)Minecraft.m_91087_().f_91073_, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.LASER_DRILL_FLUID_TYPE.get())));
        for (int i = 0; i < IMycelialGeneratorType.TYPES.size(); ++i) {
            registration.addRecipes(this.mycelialGeneratorCategories.get(i).getRecipeType(), IMycelialGeneratorType.TYPES.get(i).getRecipes().stream().sorted(Comparator.comparingInt(value -> ((MycelialGeneratorRecipe)value).getTicks() * ((MycelialGeneratorRecipe)value).getPowerTick()).reversed()).collect(Collectors.toList()));
        }
        ArrayList<StoneWorkCategory.Wrapper> perfectStoneWorkWrappers = new ArrayList<StoneWorkCategory.Wrapper>();
        for (StoneWorkGenerateRecipe generatorRecipe : RecipeUtil.getRecipes((Level)Minecraft.m_91087_().f_91073_, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.STONEWORK_GENERATE_TYPE.get()))) {
            List<StoneWorkCategory.Wrapper> wrappers = this.findAllStoneWorkOutputs(generatorRecipe.output, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>());
            for (StoneWorkCategory.Wrapper workWrapper : new ArrayList<StoneWorkCategory.Wrapper>(wrappers)) {
                if (!perfectStoneWorkWrappers.stream().noneMatch(stoneWorkWrapper -> workWrapper.getOutput().m_41656_(stoneWorkWrapper.getOutput()))) continue;
                boolean isSomoneShorter = false;
                for (StoneWorkCategory.Wrapper workWrapperCompare : new ArrayList<StoneWorkCategory.Wrapper>(wrappers)) {
                    if (!workWrapper.getOutput().m_41656_(workWrapperCompare.getOutput())) continue;
                    ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction> workWrapperCompareModes = new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(workWrapperCompare.getModes());
                    workWrapperCompareModes.removeIf(mode -> mode.getAction().equalsIgnoreCase("none"));
                    ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction> workWrapperModes = new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(workWrapper.getModes());
                    workWrapperModes.removeIf(mode -> mode.getAction().equalsIgnoreCase("none"));
                    if (workWrapperModes.size() <= workWrapperCompareModes.size()) continue;
                    isSomoneShorter = true;
                    break;
                }
                if (isSomoneShorter) continue;
                perfectStoneWorkWrappers.add(workWrapper);
            }
        }
        registration.addRecipes(IndustrialRecipeTypes.STONE_WORK, perfectStoneWorkWrappers);
        registration.addRecipes(this.machineProduceCategory.getRecipeType(), Arrays.asList(new MachineProduceWrapper((Block)((RegistryObject)ModuleCore.LATEX_PROCESSING.getLeft()).get(), new ItemStack((ItemLike)ModuleCore.TINY_DRY_RUBBER.get())), new MachineProduceWrapper((Block)((RegistryObject)ModuleResourceProduction.SLUDGE_REFINER.getLeft()).get(), IndustrialTags.Items.SLUDGE_OUTPUT), new MachineProduceWrapper((Block)((RegistryObject)ModuleAgricultureHusbandry.SEWAGE_COMPOSTER.getLeft()).get(), new ItemStack((ItemLike)ModuleCore.FERTILIZER.get())), new MachineProduceWrapper((Block)((RegistryObject)ModuleResourceProduction.DYE_MIXER.getLeft()).get(), (TagKey<Item>)Tags.Items.DYES), new MachineProduceWrapper((Block)((RegistryObject)ModuleResourceProduction.SPORES_RECREATOR.getLeft()).get(), (TagKey<Item>)Tags.Items.MUSHROOMS), new MachineProduceWrapper((Block)((RegistryObject)ModuleResourceProduction.SPORES_RECREATOR.getLeft()).get(), new ItemStack((ItemLike)Items.f_41954_), new ItemStack((ItemLike)Items.f_41955_)), new MachineProduceWrapper((Block)((RegistryObject)ModuleAgricultureHusbandry.MOB_CRUSHER.getLeft()).get(), new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), 1000)), new MachineProduceWrapper((Block)((RegistryObject)ModuleAgricultureHusbandry.SLAUGHTER_FACTORY.getLeft()).get(), new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), 1000)), new MachineProduceWrapper((Block)((RegistryObject)ModuleAgricultureHusbandry.SLAUGHTER_FACTORY.getLeft()).get(), new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 1000)), new MachineProduceWrapper((Block)((RegistryObject)ModuleAgricultureHusbandry.ANIMAL_RANCHER.getLeft()).get(), new FluidStack((Fluid)ForgeMod.MILK.get(), 1000)), new MachineProduceWrapper((Block)((RegistryObject)ModuleAgricultureHusbandry.SEWER.getLeft()).get(), new FluidStack((Fluid)ModuleCore.SEWAGE.getSourceFluid().get(), 1000)), new MachineProduceWrapper((Block)((RegistryObject)ModuleAgricultureHusbandry.PLANT_GATHERER.getLeft()).get(), new FluidStack((Fluid)ModuleCore.SLUDGE.getSourceFluid().get(), 1000)), new MachineProduceWrapper((Block)((RegistryObject)ModuleResourceProduction.WATER_CONDENSATOR.getLeft()).get(), new FluidStack((Fluid)Fluids.f_76193_, 1000))));
        registration.addRecipes(IndustrialRecipeTypes.STONE_WORK_GENERATOR, RecipeUtil.getRecipes((Level)Minecraft.m_91087_().f_91073_, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.STONEWORK_GENERATE_TYPE.get())));
        ArrayList washer = new ArrayList();
        ArrayList fluidEntryFermenters = new ArrayList();
        ArrayList fluidSieve = new ArrayList();
        ForgeRegistries.ITEMS.tags().getTagNames().map(itemTagKey -> itemTagKey.f_203868_()).filter(resourceLocation -> resourceLocation.toString().startsWith("forge:raw_materials/") && OreTitaniumFluidType.isValid(resourceLocation)).forEach(resourceLocation -> {
            TagKey tag = ForgeRegistries.ITEMS.tags().createTagKey(resourceLocation);
            TagKey dust = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation(resourceLocation.toString().replace("forge:raw_materials/", "forge:dusts/")));
            washer.add(new OreFluidEntryRaw((TagKey<Item>)tag, new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), 100), OreTitaniumFluidType.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation)));
            fluidEntryFermenters.add(new OreFluidEntryFermenter(OreTitaniumFluidType.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation), OreTitaniumFluidType.getFluidWithTag(ModuleCore.FERMENTED_ORE_MEAT, 200, resourceLocation)));
            fluidSieve.add(new OreFluidEntrySieve(OreTitaniumFluidType.getFluidWithTag(ModuleCore.FERMENTED_ORE_MEAT, 100, resourceLocation), TagUtil.getItemWithPreference((TagKey)dust), (TagKey<Item>)ItemTags.f_13137_));
        });
        registration.addRecipes(IndustrialRecipeTypes.ORE_WASHER, washer);
        registration.addRecipes(IndustrialRecipeTypes.FERMENTER, fluidEntryFermenters);
        registration.addRecipes(IndustrialRecipeTypes.ORE_SIEVE, fluidSieve);
    }

    private List<BioReactorRecipeCategory.ReactorRecipeWrapper> generateBioreactorRecipes() {
        ArrayList<BioReactorRecipeCategory.ReactorRecipeWrapper> recipes = new ArrayList<BioReactorRecipeCategory.ReactorRecipeWrapper>();
        for (TagKey<Item> itemTag : BioReactorTile.VALID) {
            recipes.add(new BioReactorRecipeCategory.ReactorRecipeWrapper(itemTag, new FluidStack((Fluid)ModuleCore.BIOFUEL.getSourceFluid().get(), 80)));
        }
        return recipes;
    }

    public ItemStack getStoneWorkOutputFrom(ItemStack stack, MaterialStoneWorkFactoryTile.StoneWorkAction mode) {
        return mode.getWork().apply((Level)Minecraft.m_91087_().f_91073_, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)9));
    }

    public ItemStack getStoneWorkOutputFrom(ItemStack stack, List<MaterialStoneWorkFactoryTile.StoneWorkAction> modes) {
        for (MaterialStoneWorkFactoryTile.StoneWorkAction mode : modes) {
            if (!(stack = this.getStoneWorkOutputFrom(stack.m_41777_(), mode)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public List<StoneWorkCategory.Wrapper> findAllStoneWorkOutputs(ItemStack parent, List<MaterialStoneWorkFactoryTile.StoneWorkAction> usedModes) {
        ArrayList<StoneWorkCategory.Wrapper> wrappers = new ArrayList<StoneWorkCategory.Wrapper>();
        if (usedModes.size() >= 4) {
            return wrappers;
        }
        for (MaterialStoneWorkFactoryTile.StoneWorkAction mode : MaterialStoneWorkFactoryTile.ACTION_RECIPES) {
            if (mode.getAction().equals("none")) continue;
            ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction> usedModesInternal = new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModes);
            usedModesInternal.add(mode);
            ItemStack output = this.getStoneWorkOutputFrom(parent, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModesInternal));
            if (output.m_41619_()) continue;
            wrappers.add(new StoneWorkCategory.Wrapper(parent, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModesInternal), output.m_41777_()));
            wrappers.addAll(this.findAllStoneWorkOutputs(parent, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModesInternal)));
        }
        return wrappers;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleCore.FLUID_EXTRACTOR.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.FLUID_EXTRACTOR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleCore.DISSOLUTION_CHAMBER.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.DISSOLUTION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleGenerator.BIOREACTOR.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.BIOREACTOR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.ORE_LASER_BASE.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.LASER_ORE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.LASER_DRILL.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.LASER_ORE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.FLUID_LASER_BASE.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.LASER_FLUID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.LASER_DRILL.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.LASER_FLUID});
        for (Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> mycelialGenerator : ModuleGenerator.MYCELIAL_GENERATORS) {
            for (MycelialGeneratorCategory mycelialGeneratorCategory : this.mycelialGeneratorCategories) {
                if (!((MycelialGeneratorBlock)((Object)((RegistryObject)mycelialGenerator.getLeft()).get())).getType().equals(mycelialGeneratorCategory.getType())) continue;
                registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)mycelialGenerator.getLeft()).get()), new RecipeType[]{mycelialGeneratorCategory.getRecipeType()});
            }
        }
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.MATERIAL_STONEWORK_FACTORY.getLeft()).get()), new RecipeType[]{this.stoneWorkCategory.getRecipeType(), this.stoneWorkGeneratorCategory.getRecipeType()});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.POTION_BREWER.getLeft()).get()), new RecipeType[]{RecipeTypes.BREWING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleMisc.ENCHANTMENT_APPLICATOR.getLeft()).get()), new RecipeType[]{RecipeTypes.ANVIL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.RESOURCEFUL_FURNACE.getLeft()).get()), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.WASHING_FACTORY.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.ORE_WASHER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.FERMENTATION_STATION.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.FERMENTER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((RegistryObject)ModuleResourceProduction.FLUID_SIEVING_MACHINE.getLeft()).get()), new RecipeType[]{IndustrialRecipeTypes.ORE_SIEVE});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("industrialforegoing", "default");
    }
}

