/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.logistics.block.display.AllDisplayBehaviours;
import com.simibubi.create.content.logistics.block.display.DisplayBehaviour;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.SingleLineDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplaySection;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.HourGlassBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimeData;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimesManager;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.ClockBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.HangingSignBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BlackboardItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;

public class CreateCompatImpl {
    public static void setup() {
        try {
            AllMovementBehaviours.registerBehaviour((Block)ModRegistry.BAMBOO_SPIKES.get(), (MovementBehaviour)new BambooSpikesBehavior());
            AllMovementBehaviours.registerBehaviour((Block)ModRegistry.HOURGLASS.get(), (MovementBehaviour)new HourglassBehavior());
            AllMovementBehaviours.registerBehaviour((Block)ModRegistry.PULLEY_BLOCK.get(), (MovementBehaviour)new PulleyBehavior());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("notice_board_display_target"), (DisplayBehaviour)new NoticeBoardDisplayTarget()), ModRegistry.NOTICE_BOARD_TILE.get());
            DisplayBehaviour textHolderTarget = AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("text_holder_display_target"), (DisplayBehaviour)new TextHolderDisplayTarget());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)textHolderTarget, ModRegistry.SIGN_POST_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)textHolderTarget, ModRegistry.HANGING_SIGN_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)textHolderTarget, ModRegistry.DOORMAT_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)textHolderTarget, ModRegistry.DOORMAT_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("speaker_block_display_target"), (DisplayBehaviour)new SpeakerBlockDisplayTarget()), ModRegistry.SPEAKER_BLOCK_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("blackboard_display_target"), (DisplayBehaviour)new BlackboardDisplayTarget()), ModRegistry.BLACKBOARD_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("globe_display_source"), (DisplayBehaviour)new GlobeDisplaySource()), ModRegistry.GLOBE_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("notice_board_display_source"), (DisplayBehaviour)new NoticeBoardDisplaySource()), ModRegistry.NOTICE_BOARD_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("clock_source"), (DisplayBehaviour)new ClockDisplaySource()), ModRegistry.CLOCK_BLOCK_TILE.get());
            DisplayBehaviour itemDisplaySource = AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("item_display_source"), (DisplayBehaviour)new ItemDisplayDisplaySource());
            AllDisplayBehaviours.assignBlock((DisplayBehaviour)itemDisplaySource, (Block)ModRegistry.PEDESTAL.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)itemDisplaySource, ModRegistry.ITEM_SHELF_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)itemDisplaySource, ModRegistry.STATUE_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)itemDisplaySource, ModRegistry.HOURGLASS_TILE.get());
            AllDisplayBehaviours.assignTile((DisplayBehaviour)AllDisplayBehaviours.register((ResourceLocation)Supplementaries.res("fluid_tank_source"), (DisplayBehaviour)new FluidFillLevelDisplaySource()), ModRegistry.JAR_TILE.get());
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to register supplementaries create behaviors: " + e);
        }
    }

    public static void setupClient() {
        PonderRegistry.TAGS.forTag(PonderTag.DISPLAY_TARGETS).add((ItemLike)ModRegistry.NOTICE_BOARD.get());
        PonderRegistry.TAGS.forTag(PonderTag.DISPLAY_TARGETS).add((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(WoodTypeRegistry.OAK_TYPE));
        PonderRegistry.TAGS.forTag(PonderTag.DISPLAY_TARGETS).add((ItemLike)ModRegistry.HANGING_SIGNS.get(WoodTypeRegistry.OAK_TYPE));
        PonderRegistry.TAGS.forTag(PonderTag.DISPLAY_TARGETS).add((ItemLike)ModRegistry.SPEAKER_BLOCK.get());
        PonderRegistry.TAGS.forTag(PonderTag.DISPLAY_TARGETS).add((ItemLike)ModRegistry.BLACKBOARD.get());
        PonderRegistry.TAGS.forTag(PonderTag.DISPLAY_SOURCES).add((ItemLike)ModRegistry.NOTICE_BOARD.get());
        PonderRegistry.TAGS.forTag(PonderTag.DISPLAY_SOURCES).add((ItemLike)ModRegistry.GLOBE_ITEM.get());
        PonderRegistry.TAGS.forTag(PonderTag.DISPLAY_SOURCES).add((ItemLike)ModRegistry.PEDESTAL.get());
        PonderRegistry.TAGS.forTag(PonderTag.DISPLAY_SOURCES).add((ItemLike)ModRegistry.JAR.get());
    }

    private static void changeState(MovementContext context, BlockState newState) {
        Map blocks = context.contraption.getBlocks();
        if (blocks.containsKey(context.localPos)) {
            context.state = newState;
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)blocks.get(context.localPos);
            StructureTemplate.StructureBlockInfo newInfo = new StructureTemplate.StructureBlockInfo(info.f_74675_, newState, info.f_74677_);
            blocks.replace(context.localPos, newInfo);
        }
    }

    private static Rotation isClockWise(UnaryOperator<Vec3> rot, Direction dir) {
        Vec3 v = MthUtils.V3itoV3((Vec3i)dir.m_122436_());
        Vec3 v2 = (Vec3)rot.apply(v);
        double dot = v2.m_82526_(new Vec3(0.0, 1.0, 0.0));
        if (dot > 0.0) {
            return Rotation.CLOCKWISE_90;
        }
        if (dot < 0.0) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return Rotation.NONE;
    }

    private static ItemStack getDisplayedItem(DisplayLinkContext context, BlockEntity source, Predicate<ItemStack> predicate) {
        if (source instanceof ItemDisplayTile) {
            ItemDisplayTile display = (ItemDisplayTile)source;
            ItemStack stack = display.getDisplayedItem();
            if (predicate.test(stack)) {
                return stack;
            }
        } else {
            for (int i = 0; i < 32; ++i) {
                BlockPos pos = context.getSourcePos();
                TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)TileEntityBehaviour.get((BlockGetter)context.level(), (BlockPos)pos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour == null) break;
                MutableObject stackHolder = new MutableObject();
                behaviour.handleCenteredProcessingOnAllItems(0.25f, tis -> {
                    stackHolder.setValue((Object)tis.stack);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                });
                ItemStack stack = (ItemStack)stackHolder.getValue();
                if (stack == null || !predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    private static class BambooSpikesBehavior
    implements MovementBehaviour {
        private static final BambooSpikesBlockTile DUMMY = new BambooSpikesBlockTile(BlockPos.f_121853_, ModRegistry.BAMBOO_SPIKES.get().m_49966_());

        private BambooSpikesBehavior() {
        }

        public boolean isSameDir(MovementContext context) {
            return VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.m_61143_((Property)BambooSpikesBlock.FACING)));
        }

        public boolean renderAsNormalTileEntity() {
            return true;
        }

        public void tick(MovementContext context) {
            this.damageEntities(context);
        }

        public void damageEntities(MovementContext context) {
            Level world = context.world;
            Vec3 pos = context.position;
            DamageSource damageSource = BambooSpikesBlock.getDamageSource(world);
            block0: for (Entity entity : world.m_45976_(Entity.class, new AABB(pos.m_82520_(-0.5, -0.5, -0.5), pos.m_82520_(0.5, 0.5, 0.5)))) {
                Player player;
                if (entity instanceof ItemEntity || entity instanceof AbstractContraptionEntity || entity instanceof Player && (player = (Player)entity).m_7500_()) continue;
                if (entity instanceof AbstractMinecart) {
                    for (Entity passenger : entity.m_146897_()) {
                        AbstractContraptionEntity ace;
                        if (!(passenger instanceof AbstractContraptionEntity) || (ace = (AbstractContraptionEntity)passenger).getContraption() != context.contraption) continue;
                        continue block0;
                    }
                }
                if (entity.m_6084_() && entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (!world.f_46443_) {
                        double pow = 5.0 * Math.pow(context.relativeMotion.m_82553_(), 0.4) + 1.0;
                        float damage = !this.isSameDir(context) ? 1.0f : (float)Mth.m_14008_((double)pow, (double)2.0, (double)6.0);
                        entity.m_6469_(damageSource, damage);
                        this.doTileStuff(context, world, livingEntity);
                    }
                }
                if (world.f_46443_ != entity instanceof Player) continue;
                Vec3 motionBoost = context.motion.m_82520_(0.0, context.motion.m_82553_() / 4.0, 0.0);
                int maxBoost = 4;
                if (motionBoost.m_82553_() > (double)maxBoost) {
                    motionBoost = motionBoost.m_82546_(motionBoost.m_82541_().m_82490_(motionBoost.m_82553_() - (double)maxBoost));
                }
                entity.m_20256_(entity.m_20184_().m_82549_(motionBoost));
                entity.f_19864_ = true;
            }
        }

        private void doTileStuff(MovementContext context, @Nonnull Level world, LivingEntity le) {
            CompoundTag com = context.tileData;
            if (com == null) {
                return;
            }
            long lastTicked = com.m_128454_("LastTicked");
            if (!this.isOnCooldown(world, lastTicked)) {
                DUMMY.m_142466_(com);
                if (DUMMY.interactWithEntity(le, world)) {
                    CreateCompatImpl.changeState(context, (BlockState)context.state.m_61124_((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
                }
                com = DUMMY.m_187480_();
                lastTicked = world.m_46467_();
                com.m_128356_("LastTicked", lastTicked);
                context.tileData = com;
            }
        }

        public boolean isOnCooldown(Level world, long lastTicked) {
            return world.m_46467_() - lastTicked < 20L;
        }
    }

    private static class HourglassBehavior
    implements MovementBehaviour {
        private HourglassTimeData sandData;
        private float progress;
        private float prevProgress;
        private TextureAtlasSprite cachedTexture;

        private HourglassBehavior() {
        }

        public void tick(MovementContext context) {
            UnaryOperator rot = context.rotation;
            BlockState state = context.state;
            Direction dir = (Direction)state.m_61143_((Property)HourGlassBlock.FACING);
            Rotation rotation = CreateCompatImpl.isClockWise(rot, dir);
            CompoundTag com = context.tileData;
            HourglassTimeData prevSandData = this.sandData;
            NonNullList l = NonNullList.m_122779_();
            ContainerHelper.m_18980_((CompoundTag)com, (NonNullList)l);
            this.sandData = HourglassTimesManager.getData(((ItemStack)l.get(0)).m_41720_());
            if (prevSandData != this.sandData && context.world.f_46443_) {
                this.cachedTexture = this.sandData.computeSprite((ItemStack)l.get(0), context.world);
            }
            this.progress = com.m_128457_("Progress");
            this.prevProgress = com.m_128457_("PrevProgress");
            if (!this.sandData.isEmpty()) {
                this.prevProgress = this.progress;
                if (rotation == Rotation.CLOCKWISE_90 && this.progress != 1.0f) {
                    this.progress = Math.min(this.progress + this.sandData.getIncrement(), 1.0f);
                } else if (rotation == Rotation.COUNTERCLOCKWISE_90 && this.progress != 0.0f) {
                    this.progress = Math.max(this.progress - this.sandData.getIncrement(), 0.0f);
                }
            }
            com.m_128473_("Progress");
            com.m_128473_("PrevProgress");
            com.m_128350_("Progress", this.progress);
            com.m_128350_("PrevProgress", this.prevProgress);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
            float partialTicks = 1.0f;
            if (this.sandData.isEmpty()) {
                return;
            }
            Vec3 v = context.position;
            if (v == null) {
                v = new Vec3(0.0, 0.0, 0.0);
            }
            BlockPos pos = new BlockPos(v);
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)context.world, (BlockPos)pos);
            float h = Mth.m_14179_((float)partialTicks, (float)this.prevProgress, (float)this.progress);
            Direction dir = (Direction)context.state.m_61143_((Property)HourGlassBlock.FACING);
            HourGlassBlockTileRenderer.renderSand(matrices.getModelViewProjection(), buffer, light, 0, this.cachedTexture, h, dir);
        }
    }

    private static class PulleyBehavior
    implements MovementBehaviour {
        private static final PulleyBlockTile DUMMY = new PulleyBlockTile(BlockPos.f_121853_, ModRegistry.PULLEY_BLOCK.get().m_49966_());

        private PulleyBehavior() {
        }

        public void visitNewPosition(MovementContext context, BlockPos pos) {
            BlockState state = context.state;
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)PulleyBlock.f_55923_);
            if (axis == Direction.Axis.Y) {
                return;
            }
            CreateCompatImpl.changeState(context, (BlockState)state.m_61122_((Property)PulleyBlock.FLIPPED));
            Direction dir = null;
            BlockPos center = context.contraption.anchor;
            if (axis == Direction.Axis.X) {
                dir = Direction.NORTH;
            } else if (axis == Direction.Axis.Z) {
                dir = Direction.WEST;
            }
            if (dir == null) {
                return;
            }
            DUMMY.m_142466_(context.tileData);
            DUMMY.m_142339_(context.world);
            Rotation rot = context.relativeMotion.m_82553_() > 0.0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
            DUMMY.handleRotation(rot, pos);
            context.tileData = DUMMY.m_187480_();
        }
    }

    private static class NoticeBoardDisplayTarget
    extends DisplayTarget {
        private NoticeBoardDisplayTarget() {
        }

        public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
            NoticeBoardBlockTile lectern;
            ItemStack book;
            BlockEntity te = context.getTargetTE();
            if (te instanceof NoticeBoardBlockTile && !(book = (lectern = (NoticeBoardBlockTile)te).getDisplayedItem()).m_41619_()) {
                if (book.m_150930_(Items.f_42614_)) {
                    book = this.signBook(book);
                    lectern.setDisplayedItem(book);
                }
                if (book.m_150930_(Items.f_42615_)) {
                    ListTag tag = book.m_41783_().m_128437_("pages", 8);
                    boolean changed = false;
                    for (int i = 0; i - line < text.size() && i < 50; ++i) {
                        if (tag.size() <= i) {
                            tag.add((Object)StringTag.m_129297_((String)(i < line ? "" : Component.Serializer.m_130703_((Component)((Component)text.get(i - line))))));
                        } else if (i >= line) {
                            if (i - line == 0) {
                                NoticeBoardDisplayTarget.reserve((int)i, (BlockEntity)lectern, (DisplayLinkContext)context);
                            }
                            if (i - line > 0 && this.isReserved(i - line, (BlockEntity)lectern, context)) break;
                            tag.set(i, (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)((Component)text.get(i - line)))));
                        }
                        changed = true;
                    }
                    book.m_41783_().m_128365_("pages", (Tag)tag);
                    lectern.setDisplayedItem(book);
                    if (changed) {
                        context.level().m_7260_(context.getTargetPos(), lectern.m_58900_(), lectern.m_58900_(), 2);
                    }
                }
            }
        }

        public DisplayTargetStats provideStats(DisplayLinkContext context) {
            return new DisplayTargetStats(50, 256, (DisplayTarget)this);
        }

        public Component getLineOptionText(int line) {
            return Lang.translateDirect((String)"display_target.page", (Object[])new Object[]{line + 1});
        }

        private ItemStack signBook(ItemStack book) {
            ItemStack written = new ItemStack((ItemLike)Items.f_42615_);
            CompoundTag compoundtag = book.m_41783_();
            if (compoundtag != null) {
                written.m_41751_(compoundtag.m_6426_());
            }
            written.m_41700_("author", (Tag)StringTag.m_129297_((String)"Data Gatherer"));
            written.m_41700_("filtered_title", (Tag)StringTag.m_129297_((String)"Printed Book"));
            written.m_41700_("title", (Tag)StringTag.m_129297_((String)"Printed Book"));
            return written;
        }
    }

    private static class TextHolderDisplayTarget
    extends DisplayTarget {
        private TextHolderDisplayTarget() {
        }

        public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
            BlockEntity te = context.getTargetTE();
            if (te instanceof ITextHolderProvider) {
                HangingSignBlockTile hs;
                ITextHolderProvider th = (ITextHolderProvider)te;
                TextHolder textHolder = th.getTextHolder();
                boolean changed = false;
                if (th instanceof HangingSignBlockTile && ((hs = (HangingSignBlockTile)th).isEmpty() || hs.hasFakeItem())) {
                    BlockEntity source = context.getSourceTE();
                    ItemStack copyStack = CreateCompatImpl.getDisplayedItem(context, source, i -> !i.m_41619_());
                    hs.setItem(copyStack);
                    hs.setFakeItem(true);
                    changed = true;
                } else {
                    for (int i2 = 0; i2 < text.size() && i2 + line < textHolder.size(); ++i2) {
                        if (i2 == 0) {
                            TextHolderDisplayTarget.reserve((int)(i2 + line), (BlockEntity)te, (DisplayLinkContext)context);
                        }
                        if (i2 > 0 && this.isReserved(i2 + line, te, context)) break;
                        textHolder.setLine(i2 + line, (Component)text.get(i2));
                        changed = true;
                    }
                }
                if (changed) {
                    context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
                }
            }
        }

        public DisplayTargetStats provideStats(DisplayLinkContext context) {
            TextHolder textHolder = ((ITextHolderProvider)context.getTargetTE()).getTextHolder();
            return new DisplayTargetStats(textHolder.size(), textHolder.getMaxLineCharacters(), (DisplayTarget)this);
        }
    }

    private static class SpeakerBlockDisplayTarget
    extends DisplayTarget {
        private SpeakerBlockDisplayTarget() {
        }

        public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
            BlockEntity te = context.getTargetTE();
            if (te instanceof SpeakerBlockTile) {
                SpeakerBlockTile tile = (SpeakerBlockTile)te;
                if (text.size() > 0) {
                    SpeakerBlockDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
                    tile.setMessage(text.get(0).getString());
                    context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
                }
            }
        }

        public DisplayTargetStats provideStats(DisplayLinkContext context) {
            return new DisplayTargetStats(1, 32, (DisplayTarget)this);
        }
    }

    private static class BlackboardDisplayTarget
    extends DisplayTarget {
        private static final Pattern PATTERN = Pattern.compile("\\((\\d\\d?),(\\d\\d?)\\)->(\\S+)");

        private BlackboardDisplayTarget() {
        }

        public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
            BlockEntity te = context.getTargetTE();
            if (te instanceof BlackboardBlockTile) {
                BlackboardBlockTile tile = (BlackboardBlockTile)te;
                if (text.size() > 0 && !tile.isWaxed()) {
                    BlockEntity source = context.getSourceTE();
                    if (!this.parseText(text.get(0).getString(), tile)) {
                        ItemStack copyStack = CreateCompatImpl.getDisplayedItem(context, source, i -> i.m_41720_() instanceof BlackboardItem);
                        if (!copyStack.m_41619_() && BlackboardDisplayTarget.copyBlackboard(line, context, te, tile, copyStack)) {
                            return;
                        }
                        long[] pixels = BlackboardBlockTile.unpackPixelsFromStringWhiteOnly(text.get(0).getString());
                        tile.setPixels(BlackboardBlockTile.unpackPixels(pixels));
                    }
                    context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
                    BlackboardDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
                }
            }
        }

        private boolean parseText(String string, BlackboardBlockTile tile) {
            Matcher m = PATTERN.matcher(string);
            if (m.matches()) {
                int x = Integer.parseInt(m.group(1));
                int y = Integer.parseInt(m.group(2));
                DyeColor dye = DyeColor.m_41057_((String)m.group(3), null);
                if (x >= 0 && x <= 15 && y >= 0 && y <= 15 && dye != null) {
                    if (dye != DyeColor.WHITE && dye != DyeColor.BLACK && !CommonConfigs.Building.BLACKBOARD_COLOR.get().booleanValue()) {
                        return false;
                    }
                    tile.setPixel(x, y, BlackboardBlock.colorToByte(dye));
                    return true;
                }
            }
            return false;
        }

        private static boolean copyBlackboard(int line, DisplayLinkContext context, BlockEntity te, BlackboardBlockTile tile, ItemStack stack) {
            CompoundTag cmp = stack.m_41737_("BlockEntityTag");
            if (cmp != null && cmp.m_128441_("Pixels")) {
                tile.setPixels(BlackboardBlockTile.unpackPixels(cmp.m_128467_("Pixels")));
                context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
                BlackboardDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
                return true;
            }
            return false;
        }

        public DisplayTargetStats provideStats(DisplayLinkContext context) {
            return new DisplayTargetStats(1, 32, (DisplayTarget)this);
        }
    }

    private static class GlobeDisplaySource
    extends SingleLineDisplaySource {
        public static final MutableComponent EMPTY = Components.literal((String)"--,--");

        private GlobeDisplaySource() {
        }

        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            BlockEntity blockEntity = context.getSourceTE();
            if (blockEntity instanceof GlobeBlockTile) {
                GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
                BlockPos pos = context.getSourcePos();
                return Component.m_237113_((String)("X: " + pos.m_123341_() + ", Z: " + pos.m_123343_()));
            }
            return EMPTY;
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }

        protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
            return "Instant";
        }

        protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
            return new FlapDisplaySection((float)size * 7.0f, "instant", false, false);
        }

        protected String getTranslationKey() {
            return "world_position";
        }
    }

    private static class NoticeBoardDisplaySource
    extends SingleLineDisplaySource {
        private NoticeBoardDisplaySource() {
        }

        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            BlockEntity blockEntity = context.getSourceTE();
            if (blockEntity instanceof NoticeBoardBlockTile) {
                NoticeBoardBlockTile tile = (NoticeBoardBlockTile)blockEntity;
                tile.updateText();
                return Component.m_237113_((String)tile.getText());
            }
            return Component.m_237119_();
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return false;
        }

        protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
            return "Instant";
        }

        protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
            return new FlapDisplaySection((float)size * 7.0f, "instant", false, false);
        }

        protected String getTranslationKey() {
            return "notice_board";
        }
    }

    private static class ClockDisplaySource
    extends SingleLineDisplaySource {
        public static final MutableComponent EMPTY_TIME = Components.literal((String)"--:--");

        private ClockDisplaySource() {
        }

        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            Level level = context.level();
            if (level instanceof ServerLevel) {
                ServerLevel sLevel = (ServerLevel)level;
                BlockEntity blockEntity = context.getSourceTE();
                if (blockEntity instanceof ClockBlockTile) {
                    ClockBlockTile tile = (ClockBlockTile)blockEntity;
                    boolean c12 = context.sourceConfig().m_128451_("Cycle") == 0;
                    boolean isNatural = sLevel.m_6042_().f_63858_();
                    int dayTime = (int)(sLevel.m_46468_() % 24000L);
                    int hours = (dayTime / 1000 + 6) % 24;
                    int minutes = dayTime % 1000 * 60 / 1000;
                    MutableComponent suffix = Lang.translateDirect((String)("generic.daytime." + (hours > 11 ? "pm" : "am")), (Object[])new Object[0]);
                    minutes = minutes / 5 * 5;
                    if (c12 && (hours %= 12) == 0) {
                        hours = 12;
                    }
                    if (!isNatural) {
                        hours = Create.RANDOM.nextInt(70) + 24;
                        minutes = Create.RANDOM.nextInt(40) + 60;
                    }
                    MutableComponent component = Components.literal((String)((hours < 10 ? " " : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + (c12 ? " " : "")));
                    return c12 ? component.m_7220_((Component)suffix) : component;
                }
            }
            return EMPTY_TIME;
        }

        protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
            return "Instant";
        }

        protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
            return new FlapDisplaySection((float)size * 7.0f, "instant", false, false);
        }

        protected String getTranslationKey() {
            return "time_of_day";
        }

        @OnlyIn(value=Dist.CLIENT)
        public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
            super.initConfigurationWidgets(context, builder, isFirstLine);
            if (!isFirstLine) {
                builder.addSelectionScrollInput(0, 60, (si, l) -> si.forOptions(Lang.translatedOptions((String)"display_source.time", (String[])new String[]{"12_hour", "24_hour"})).titled(Lang.translateDirect((String)"display_source.time.format", (Object[])new Object[0])), "Cycle");
            }
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }
    }

    private static class ItemDisplayDisplaySource
    extends SingleLineDisplaySource {
        private ItemDisplayDisplaySource() {
        }

        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            ItemDisplayTile te;
            MutableComponent combined = EMPTY_LINE.m_6881_();
            BlockEntity blockEntity = context.getSourceTE();
            if (blockEntity instanceof ItemDisplayTile && !(te = (ItemDisplayTile)blockEntity).m_7983_()) {
                combined = combined.m_7220_(te.getDisplayedItem().m_41786_());
            }
            return combined;
        }

        public int getPassiveRefreshTicks() {
            return 20;
        }

        protected String getTranslationKey() {
            return "item_name";
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }

        protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
            return "Number";
        }
    }

    private static class FluidFillLevelDisplaySource
    extends PercentOrProgressBarDisplaySource {
        private FluidFillLevelDisplaySource() {
        }

        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            BlockEntity blockEntity;
            if (context.sourceConfig().m_128451_("Mode") == 2 && (blockEntity = context.getSourceTE()) instanceof ISoftFluidTankProvider) {
                ISoftFluidTankProvider tp = (ISoftFluidTankProvider)blockEntity;
                return Components.literal((String)(tp.getSoftFluidTank().getCount() + " mBtl"));
            }
            return super.provideLine(context, stats);
        }

        protected Float getProgress(DisplayLinkContext context) {
            BlockEntity te = context.getSourceTE();
            if (te instanceof ISoftFluidTankProvider) {
                ISoftFluidTankProvider tp = (ISoftFluidTankProvider)te;
                return Float.valueOf(tp.getSoftFluidTank().getHeight(1.0f));
            }
            return null;
        }

        protected boolean progressBarActive(DisplayLinkContext context) {
            return context.sourceConfig().m_128451_("Mode") == 1;
        }

        protected String getTranslationKey() {
            return "fluid_amount";
        }

        @OnlyIn(value=Dist.CLIENT)
        public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
            super.initConfigurationWidgets(context, builder, isFirstLine);
            if (!isFirstLine) {
                builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(Lang.translatedOptions((String)"display_source.fill_level", (String[])new String[]{"percent", "progress_bar", "fluid_amount"})).titled(Lang.translateDirect((String)"display_source.fill_level.display", (Object[])new Object[0])), "Mode");
            }
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }
    }
}

