/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils.forge;

import com.mojang.datafixers.util.Pair;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.KeyLockableTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CuriosCompat;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ItemsUtilImpl {
    public static boolean extractFromContainerItemIntoSlot(Player player, ItemStack containerStack, Slot slot) {
        Pair<IItemHandler, BlockEntity> handlerAndTe;
        if (slot.m_8010_(player) && (handlerAndTe = ItemsUtilImpl.getItemHandler(containerStack, player)) != null) {
            IItemHandler handler = (IItemHandler)handlerAndTe.getFirst();
            for (int s = 0; s < handler.getSlots(); ++s) {
                ItemStack selected = handler.getStackInSlot(s);
                if (selected.m_41619_()) continue;
                ItemStack dropped = handler.extractItem(s, 1, false);
                if (slot.m_5857_(dropped)) {
                    slot.m_5852_(dropped);
                    CompoundTag newTag = new CompoundTag();
                    newTag.m_128365_("BlockEntityTag", (Tag)((BlockEntity)handlerAndTe.getSecond()).m_187482_());
                    containerStack.m_41751_(newTag);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean addToContainerItem(Player player, ItemStack containerStack, ItemStack stack, Slot slot, boolean simulate, boolean inSlot) {
        Pair<IItemHandler, BlockEntity> handlerAndTe;
        if (slot.m_8010_(player) && (handlerAndTe = ItemsUtilImpl.getItemHandler(containerStack, player)) != null) {
            boolean success;
            IItemHandler handler = (IItemHandler)handlerAndTe.getFirst();
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)simulate);
            boolean bl = success = result.m_41619_() || result.m_41613_() != stack.m_41613_();
            if (success) {
                if (simulate) {
                    return true;
                }
                CompoundTag newTag = new CompoundTag();
                newTag.m_128365_("BlockEntityTag", (Tag)((BlockEntity)handlerAndTe.getSecond()).m_187482_());
                if (inSlot) {
                    stack.m_41764_(result.m_41613_());
                    ItemStack newStack = containerStack.m_41777_();
                    if (slot.m_5857_(newStack)) {
                        newStack.m_41751_(newTag);
                        slot.m_5852_(newStack);
                        return true;
                    }
                } else {
                    int i = stack.m_41613_() - result.m_41613_();
                    slot.m_150647_(i, i, player);
                    containerStack.m_41751_(newTag);
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static Pair<IItemHandler, BlockEntity> getItemHandler(ItemStack containerStack, Player player) {
        BlockEntity te;
        CompoundTag cmp;
        CompoundTag tag = containerStack.m_41783_();
        if (tag != null && !(cmp = tag.m_128469_("BlockEntityTag")).m_128441_("LootTable") && (te = ItemsUtil.loadBlockEntityFromItem(cmp.m_6426_(), containerStack.m_41720_())) != null) {
            SafeBlockTile safe;
            if (te instanceof SafeBlockTile && !(safe = (SafeBlockTile)te).canPlayerOpen(player, false)) {
                return null;
            }
            LazyOptional handlerHolder = te.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            if (handlerHolder.isPresent()) {
                return Pair.of((Object)((IItemHandler)handlerHolder.orElseGet(EmptyHandler::new)), (Object)te);
            }
        }
        return null;
    }

    public static float getEncumbermentFromInventory(ItemStack stack, ServerPlayer player) {
        float amount = 0.0f;
        AtomicReference reference = new AtomicReference();
        player.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(reference::set);
        if (reference.get() != null) {
            for (int idx = 0; idx < ((IItemHandler)reference.get()).getSlots(); ++idx) {
                ItemStack slotItem = ((IItemHandler)reference.get()).getStackInSlot(idx);
                amount += SackItem.getEncumber(slotItem);
            }
            if (CompatHandler.QUARK) {
                ItemStack backpack = player.m_6844_(EquipmentSlot.CHEST);
                amount += QuarkCompat.getEncumbermentFromBackpack(backpack);
            }
        }
        return amount;
    }

    public static KeyLockableTile.KeyStatus hasKeyInInventory(Player player, String key) {
        if (key == null) {
            return KeyLockableTile.KeyStatus.CORRECT_KEY;
        }
        KeyLockableTile.KeyStatus found = KeyLockableTile.KeyStatus.NO_KEY;
        if (CompatHandler.CURIOS && (found = CuriosCompat.isKeyInCurio(player, key)) == KeyLockableTile.KeyStatus.CORRECT_KEY) {
            return found;
        }
        AtomicReference itemHandler = new AtomicReference();
        player.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(itemHandler::set);
        if (itemHandler.get() != null) {
            for (int idx = 0; idx < ((IItemHandler)itemHandler.get()).getSlots(); ++idx) {
                ItemStack stack = ((IItemHandler)itemHandler.get()).getStackInSlot(idx);
                if (!stack.m_204117_(ModTags.KEY)) continue;
                found = KeyLockableTile.KeyStatus.INCORRECT_KEY;
                if (!KeyLockableTile.isCorrectKey(stack, key)) continue;
                return KeyLockableTile.KeyStatus.CORRECT_KEY;
            }
        }
        return found;
    }

    public static ItemStack removeFirstStackFromInventory(Level level, BlockPos pos, Direction dir, BlockEntity tile) {
        IItemHandler itemHandler = (IItemHandler)CapabilityHandler.get((ICapabilityProvider)tile, ForgeCapabilities.ITEM_HANDLER, dir);
        if (itemHandler != null) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack extracted;
                ItemStack itemstack = itemHandler.getStackInSlot(slot);
                if (itemstack.m_41619_() || (extracted = itemHandler.extractItem(slot, 1, false)).m_41619_()) continue;
                tile.m_6596_();
                return extracted.m_41777_();
            }
        }
        return ItemStack.f_41583_;
    }
}

