/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_markers;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomDataHolder;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class WeatheredMap {
    private static final String ANTIQUE_KEY = "antique";
    private static final ResourceLocation ANTIQUE_ID;
    private static final MaterialColor ANTIQUE_LIGHT;
    private static final MaterialColor ANTIQUE_DARK;
    private static final Object2ObjectArrayMap<MaterialColor, MaterialColor> ANTIQUE_COLORS;

    public static void setup() {
        MapDecorationRegistry.registerCustomMapSavedData((ResourceLocation)ANTIQUE_ID, Boolean.TYPE, t -> t.m_128471_(ANTIQUE_KEY), (t, b) -> t.m_128379_(ANTIQUE_KEY, b.booleanValue()), WeatheredMap::update, WeatheredMap::onTooltip);
    }

    public static Component onTooltip(MapItemSavedData data, ItemStack stack, boolean antique) {
        if (antique) {
            return Component.m_237115_((String)"filled_map.antique.tooltip").m_130940_(ChatFormatting.GRAY);
        }
        return null;
    }

    public static boolean update(MapItemSavedData data, Entity entity, boolean antique) {
        if (!antique) {
            return false;
        }
        Level level = entity.f_19853_;
        if (level.m_46472_() != data.f_77887_ || !(entity instanceof Player)) {
            return false;
        }
        int scale = 1 << data.f_77890_;
        int mapX = data.f_77885_;
        int mapZ = data.f_77886_;
        int playerX = Mth.m_14107_((double)(entity.m_20185_() - (double)mapX)) / scale + 64;
        int playerZ = Mth.m_14107_((double)(entity.m_20189_() - (double)mapZ)) / scale + 64;
        int centerY = 128 / scale;
        if (level.m_6042_().f_63856_()) {
            centerY /= 2;
        }
        MapItemSavedData.HoldingPlayer player = data.m_77916_((Player)entity);
        ++player.f_77960_;
        boolean flag = false;
        for (int pixelX = playerX - centerY + 1; pixelX < playerX + centerY; ++pixelX) {
            if ((pixelX & 0xF) != (player.f_77960_ & 0xF) && !flag) continue;
            flag = false;
            double somethingY = 0.0;
            for (int pixelZ = playerZ - centerY - 1; pixelZ < playerZ + centerY; ++pixelZ) {
                if (pixelX < 0 || pixelZ < -1 || pixelX >= 128 || pixelZ >= 128) continue;
                int offsetX = pixelX - playerX;
                int offsetZ = pixelZ - playerZ;
                boolean outRadius = offsetX * offsetX + offsetZ * offsetZ > (centerY - 2) * (centerY - 2);
                int worldX = (mapX / scale + pixelX - 64) * scale;
                int worldZ = (mapZ / scale + pixelZ - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                LevelChunk levelchunk = level.m_46745_(new BlockPos(worldX, 0, worldZ));
                if (levelchunk.m_6430_()) continue;
                ChunkPos chunkpos = levelchunk.m_7697_();
                int chunkCoordX = worldX & 0xF;
                int chunkCoordZ = worldZ & 0xF;
                double maxY = 0.0;
                int distanceFromLand = 8;
                HashMap<BlockPos, Boolean> isWaterMap = new HashMap<BlockPos, Boolean>();
                if (level.m_6042_().f_63856_()) {
                    int l3 = worldX + worldZ * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)Blocks.f_50493_.m_49966_().m_60780_((BlockGetter)level, BlockPos.f_121853_), 10);
                    } else {
                        multiset.add((Object)Blocks.f_50106_.m_49966_().m_60780_((BlockGetter)level, BlockPos.f_121853_), 100);
                    }
                    maxY = 100.0;
                    distanceFromLand = 0;
                } else {
                    BlockPos.MutableBlockPos mutable1 = new BlockPos.MutableBlockPos();
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ - scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ + scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ - scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ + scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX, worldZ - scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX, worldZ + scale)) {
                        --distanceFromLand;
                    }
                    for (int scaleOffsetX = 0; scaleOffsetX < scale; ++scaleOffsetX) {
                        for (int scaleOffsetZ = 0; scaleOffsetZ < scale; ++scaleOffsetZ) {
                            int cY = levelchunk.m_5885_(Heightmap.Types.WORLD_SURFACE, scaleOffsetX + chunkCoordX, scaleOffsetZ + chunkCoordZ) + 1;
                            MaterialColor newColor = null;
                            if (cY <= level.m_141937_() + 1) {
                                newColor = Blocks.f_50752_.m_49966_().m_60780_((BlockGetter)level, (BlockPos)mutable1);
                            } else {
                                BlockState blockState;
                                MaterialColor temp;
                                do {
                                    mutable1.m_122178_(chunkpos.m_45604_() + scaleOffsetX + chunkCoordX, --cY, chunkpos.m_45605_() + scaleOffsetZ + chunkCoordZ);
                                    blockState = levelchunk.m_8055_((BlockPos)mutable1);
                                    temp = blockState.m_60780_((BlockGetter)level, (BlockPos)mutable1);
                                    if (temp == MaterialColor.f_76398_ || temp == MaterialColor.f_76410_ || !blockState.m_60812_((BlockGetter)level, (BlockPos)mutable1).m_83281_()) continue;
                                    newColor = MaterialColor.f_76399_;
                                } while (temp == MaterialColor.f_76398_ && cY > level.m_141937_());
                                if (newColor == null) {
                                    newColor = blockState.m_60780_((BlockGetter)level, (BlockPos)mutable1);
                                }
                            }
                            data.m_77930_((BlockGetter)level, chunkpos.m_45604_() + scaleOffsetX + chunkCoordX, chunkpos.m_45605_() + scaleOffsetZ + chunkCoordZ);
                            maxY += (double)cY / (double)(scale * scale);
                            multiset.add((Object)newColor);
                        }
                    }
                }
                int relativeShade = 1;
                MaterialColor materialcolor = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialColor.f_76398_);
                if (materialcolor == MaterialColor.f_76410_) {
                    materialcolor = MaterialColor.f_76413_;
                    if (distanceFromLand > 7 && pixelZ % 2 == 0) {
                        relativeShade = (pixelX + (int)(Mth.m_14031_((float)((float)pixelZ + 0.0f)) * 7.0f)) / 8 % 5;
                        if (relativeShade == 3) {
                            relativeShade = 1;
                        } else if (relativeShade == 4) {
                            relativeShade = 0;
                        }
                    } else if (distanceFromLand > 7) {
                        materialcolor = ANTIQUE_LIGHT;
                        relativeShade = 2;
                    } else if (distanceFromLand > 5) {
                        relativeShade = 1;
                    } else if (distanceFromLand > 3) {
                        relativeShade = 0;
                    }
                } else if (distanceFromLand > 0) {
                    relativeShade = 3;
                    materialcolor = MaterialColor.f_76362_;
                    if (distanceFromLand > 3) {
                        relativeShade = 1;
                    }
                } else {
                    double depthY = (maxY - somethingY) * 4.0 / (double)(scale + 4) + ((double)(pixelX + pixelZ & 1) - 0.5) * 0.4;
                    if (depthY > 0.6) {
                        relativeShade = 2;
                    }
                    if (depthY < -0.6) {
                        relativeShade = 0;
                    }
                    materialcolor = (MaterialColor)ANTIQUE_COLORS.getOrDefault((Object)materialcolor, (Object)ANTIQUE_DARK);
                }
                somethingY = maxY;
                if (pixelZ < 0 || offsetX * offsetX + offsetZ * offsetZ >= centerY * centerY || outRadius && (pixelX + pixelZ & 1) == 0) continue;
                flag |= data.m_164792_(pixelX, pixelZ, (byte)(materialcolor.f_76397_ * 4 + relativeShade));
            }
        }
        return true;
    }

    private static boolean isWaterAt(Level level, Map<BlockPos, Boolean> map, int scale, int x, int z) {
        BlockPos pos = new BlockPos(x, 0, z);
        return map.computeIfAbsent(pos, p -> {
            int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z) - 1;
            return level.m_6425_(pos.m_6630_(y)).m_76178_();
        });
    }

    public static void setAntique(ServerLevel level, ItemStack stack, boolean on) {
        MapItemSavedData mapitemsaveddata = MapItem.m_42853_((ItemStack)stack, (Level)level);
        if (mapitemsaveddata instanceof ExpandedMapData) {
            ExpandedMapData n;
            CustomDataHolder.Instance instance;
            ExpandedMapData data = (ExpandedMapData)mapitemsaveddata;
            MapItemSavedData newData = data.copy();
            if (newData instanceof ExpandedMapData && (instance = (CustomDataHolder.Instance)(n = (ExpandedMapData)newData).getCustomData().get(ANTIQUE_ID)) != null) {
                CustomDataHolder.Instance antique = instance;
                antique.set((Object)on);
            }
            int mapId = level.m_7354_();
            String mapKey = MapItem.m_42848_((int)mapId);
            level.m_142325_(mapKey, newData);
            stack.m_41784_().m_128405_("map", mapId);
        }
    }

    static {
        MaterialColor materialColor1;
        MaterialColor materialColor;
        ANTIQUE_ID = Supplementaries.res(ANTIQUE_KEY);
        ANTIQUE_COLORS = new Object2ObjectArrayMap();
        try {
            Class<MaterialColor> cl = MaterialColor.class;
            Constructor cons = cl.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
            cons.setAccessible(true);
            materialColor = (MaterialColor)cons.newInstance(62, 13870193);
            materialColor1 = (MaterialColor)cons.newInstance(63, 10976850);
        }
        catch (Exception e) {
            materialColor = MaterialColor.f_76372_;
            materialColor1 = MaterialColor.f_164535_;
            Supplementaries.LOGGER.warn("Failed to add custom map colors for antique map: " + e);
        }
        ANTIQUE_DARK = materialColor1;
        ANTIQUE_LIGHT = materialColor;
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76409_, (Object)MaterialColor.f_76408_);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_164534_, (Object)MaterialColor.f_76408_);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76405_, (Object)MaterialColor.f_76362_);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76408_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76411_, (Object)MaterialColor.f_76411_);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76419_, (Object)MaterialColor.f_76362_);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76388_, (Object)MaterialColor.f_76388_);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76365_, (Object)MaterialColor.f_76388_);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76400_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76412_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76406_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76404_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76401_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MaterialColor.f_76362_, (Object)MaterialColor.f_76384_);
    }
}

