/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc;

import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.api.IAntiqueTextProvider;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AntiqueInkHelper {
    private AntiqueInkHelper() {
    }

    public static boolean isEnabled() {
        return PlatformHelper.getPlatform().isForge() && CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get() != false;
    }

    public static boolean toggleAntiqueInkOnSigns(Level world, Player player, ItemStack stack, boolean newState, BlockPos pos, BlockEntity tile) {
        IAntiqueTextProvider cap = SuppPlatformStuff.getForgeCap(tile, IAntiqueTextProvider.class);
        boolean success = false;
        if (cap != null && cap.hasAntiqueInk() != newState) {
            cap.setAntiqueInk(newState);
            tile.m_6596_();
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                NetworkHandler.CHANNEL.sendToAllClientPlayersInRange((Level)serverLevel, pos, 256.0, (Message)new ClientBoundSyncAntiqueInk(pos, newState));
            }
            success = true;
        }
        if (success) {
            if (newState) {
                world.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public static void setAntiqueInk(BlockEntity tile, boolean ink) {
        IAntiqueTextProvider cap = SuppPlatformStuff.getForgeCap(tile, IAntiqueTextProvider.class);
        if (cap != null) {
            cap.setAntiqueInk(ink);
        }
    }
}

