/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.Vec2i;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.SoapItem;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlackboardBlock
extends WaterBlock
implements EntityBlock,
IWashable {
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_EAST = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_WEST = Utils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty GLOWING = ModBlockProperties.GLOWING;

    public BlackboardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, GLOWING});
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlackboardBlockTile) {
            BlackboardBlockTile tile = (BlackboardBlockTile)blockEntity;
            BlockUtil.addOptionalOwnership(placer, tile);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
        };
    }

    public static byte colorToByte(DyeColor color) {
        return switch (color) {
            case DyeColor.BLACK -> 0;
            case DyeColor.WHITE -> 1;
            case DyeColor.ORANGE -> 15;
            default -> (byte)color.m_41060_();
        };
    }

    public static int colorFromByte(byte b) {
        return switch (b) {
            case 0, 1 -> 0xFFFFFF;
            case 15 -> DyeColor.ORANGE.m_41069_().f_76396_;
            default -> DyeColor.m_41053_((int)b).m_41069_().f_76396_;
        };
    }

    public static Vec2i getHitSubPixel(BlockHitResult hit) {
        Vec3 pos = hit.m_82450_();
        Vec3 v = pos.m_82524_((float)((double)hit.m_82434_().m_122435_() * Math.PI / 180.0));
        double fx = v.f_82479_ % 1.0 * 16.0;
        if (fx < 0.0) {
            fx += 16.0;
        }
        int x = Mth.m_14045_((int)((int)fx), (int)-15, (int)15);
        int y = 15 - (int)Mth.m_14008_((double)Math.abs(v.f_82480_ % 1.0 * 16.0), (double)0.0, (double)15.0);
        if (pos.f_82480_ < 0.0) {
            y = 15 - y;
        }
        return new Vec2i(x, y);
    }

    @Nullable
    public static DyeColor getStackChalkColor(ItemStack stack) {
        boolean hasColor = CommonConfigs.Building.BLACKBOARD_COLOR.get();
        for (DyeColor dyeColor : DyeColor.values()) {
            if (!hasColor && dyeColor != DyeColor.WHITE && dyeColor != DyeColor.BLACK || !stack.m_204117_(ModTags.BLACKBOARD_TAGS.get(dyeColor))) continue;
            return dyeColor;
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlackboardBlockTile te;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlackboardBlockTile && (te = (BlackboardBlockTile)blockEntity).isAccessibleBy(player) && !te.isWaxed()) {
            ItemStack stack = player.m_21120_(handIn);
            Item i = stack.m_41720_();
            if (i instanceof HoneycombItem) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, stack);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                level.m_5898_(player, 3003, pos, 0);
                te.setWaxed(true);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (i == Items.f_151056_ && !((Boolean)state.m_61143_((Property)GLOWING)).booleanValue()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, stack);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                level.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(true)));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (i == Items.f_42532_ && ((Boolean)state.m_61143_((Property)GLOWING)).booleanValue()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, stack);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                level.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false)));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            UseMode mode = CommonConfigs.Building.BLACKBOARD_MODE.get();
            if (hit.m_82434_() == state.m_61143_((Property)FACING) && mode.canManualDraw()) {
                if (i instanceof SoapItem) {
                    return InteractionResult.PASS;
                }
                Vec2i pair = BlackboardBlock.getHitSubPixel(hit);
                int x = pair.x();
                int y = pair.y();
                DyeColor color = BlackboardBlock.getStackChalkColor(stack);
                if (color != null) {
                    byte newColor = BlackboardBlock.colorToByte(color);
                    if (te.getPixel(x, y) != newColor) {
                        te.setPixel(x, y, newColor);
                        te.m_6596_();
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
            if (!level.f_46443_ && mode.canOpenGui()) {
                te.sendOpenGuiPacket(level, pos, player);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BlackboardBlockTile(pPos, pState);
    }

    public ItemStack getBlackboardItem(BlackboardBlockTile te) {
        CompoundTag tag;
        ItemStack itemstack = new ItemStack((ItemLike)this);
        if (!te.isEmpty() && !(tag = te.savePixels(new CompoundTag())).m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)tag);
        }
        return itemstack;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)blockEntity;
            return this.getBlackboardItem(te);
        }
        return super.m_7397_(level, pos, state);
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)blockEntity;
            if (((Boolean)state.m_61143_((Property)GLOWING)).booleanValue()) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false)));
            }
            if (te.isWaxed()) {
                te.setWaxed(false);
                te.m_6596_();
                return true;
            }
            if (!te.isEmpty()) {
                te.clear();
                te.m_6596_();
                return true;
            }
        }
        return false;
    }

    public static enum UseMode {
        BOTH,
        GUI,
        MANUAL;


        public boolean canOpenGui() {
            return this != MANUAL;
        }

        public boolean canManualDraw() {
            return this != GUI;
        }
    }
}

