/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.cap;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADColorizer;
import at.petrak.hexcasting.api.addldata.ADHexHolder;
import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.addldata.ItemDelegatingEntityIotaHolder;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.item.ColorizerItem;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.spell.iota.DoubleIota;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.forge.cap.ForgeImpetusCapability;
import at.petrak.hexcasting.forge.cap.HexCapabilities;
import at.petrak.hexcasting.forge.cap.adimpl.CapEntityIotaHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapItemColorizer;
import at.petrak.hexcasting.forge.cap.adimpl.CapItemHexHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapItemIotaHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapItemMediaHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapStaticIotaHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapStaticMediaHolder;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeCapabilityHandler {
    public static final ResourceLocation IOTA_STORAGE_CAP = HexAPI.modLoc("iota_holder");
    public static final ResourceLocation IOTA_STATIC_CAP = HexAPI.modLoc("iota_item");
    public static final ResourceLocation MEDIA_STORAGE_CAP = HexAPI.modLoc("media_holder");
    public static final ResourceLocation MEDIA_STATIC_CAP = HexAPI.modLoc("media_item");
    public static final ResourceLocation HEX_HOLDER_CAP = HexAPI.modLoc("hex_item");
    public static final ResourceLocation PIGMENT_CAP = HexAPI.modLoc("pigment");
    private static final ResourceLocation IMPETUS_HANDLER = HexAPI.modLoc("impetus_items");

    public static void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(ADMediaHolder.class);
        evt.register(ADIotaHolder.class);
        evt.register(ADHexHolder.class);
        evt.register(ADColorizer.class);
    }

    public static void attachItemCaps(AttachCapabilitiesEvent<ItemStack> evt) {
        Object holder;
        ItemStack stack = (ItemStack)evt.getObject();
        Item item = stack.m_41720_();
        if (item instanceof MediaHolderItem) {
            holder = (MediaHolderItem)item;
            evt.addCapability(MEDIA_STORAGE_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> ForgeCapabilityHandler.lambda$attachItemCaps$0((MediaHolderItem)holder, stack)));
        } else if (stack.m_150930_(HexItems.AMETHYST_DUST)) {
            evt.addCapability(MEDIA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> new CapStaticMediaHolder(HexConfig.common()::dustMediaAmount, 3000, stack)));
        } else if (stack.m_150930_(Items.f_151049_)) {
            evt.addCapability(MEDIA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> new CapStaticMediaHolder(HexConfig.common()::shardMediaAmount, 2000, stack)));
        } else if (stack.m_150930_(HexItems.CHARGED_AMETHYST)) {
            evt.addCapability(MEDIA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> new CapStaticMediaHolder(HexConfig.common()::chargedCrystalMediaAmount, 1000, stack)));
        }
        item = stack.m_41720_();
        if (item instanceof IotaHolderItem) {
            holder = (IotaHolderItem)item;
            evt.addCapability(IOTA_STORAGE_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.IOTA, () -> ForgeCapabilityHandler.lambda$attachItemCaps$4((IotaHolderItem)holder, stack)));
        } else if (stack.m_150930_(Items.f_42687_)) {
            evt.addCapability(IOTA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.IOTA, () -> new CapStaticIotaHolder(s -> new DoubleIota(Math.PI * (double)s.m_41613_()), stack)));
        }
        item = stack.m_41720_();
        if (item instanceof HexHolderItem) {
            holder = (HexHolderItem)item;
            evt.addCapability(HEX_HOLDER_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.STORED_HEX, () -> ForgeCapabilityHandler.lambda$attachItemCaps$7((HexHolderItem)holder, stack)));
        }
        if ((item = stack.m_41720_()) instanceof ColorizerItem) {
            ColorizerItem colorizer = (ColorizerItem)item;
            evt.addCapability(PIGMENT_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.COLOR, () -> new CapItemColorizer(colorizer, stack)));
        }
    }

    public static void attachEntityCaps(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            evt.addCapability(IOTA_STORAGE_CAP, ForgeCapabilityHandler.wrapItemEntityDelegate(item, ItemDelegatingEntityIotaHolder.ToItemEntity::new));
        } else if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            evt.addCapability(IOTA_STORAGE_CAP, ForgeCapabilityHandler.wrapItemEntityDelegate(frame, ItemDelegatingEntityIotaHolder.ToItemFrame::new));
        } else if (entity instanceof EntityWallScroll) {
            EntityWallScroll scroll = (EntityWallScroll)entity;
            evt.addCapability(IOTA_STORAGE_CAP, ForgeCapabilityHandler.wrapItemEntityDelegate(scroll, ItemDelegatingEntityIotaHolder.ToWallScroll::new));
        }
    }

    public static void attachBlockEntityCaps(AttachCapabilitiesEvent<BlockEntity> evt) {
        Object object = evt.getObject();
        if (object instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus impetus = (BlockEntityAbstractImpetus)((Object)object);
            evt.addCapability(IMPETUS_HANDLER, ForgeCapabilityHandler.provide(impetus, ForgeCapabilities.ITEM_HANDLER, () -> new ForgeImpetusCapability(impetus)));
        }
    }

    private static <E extends Entity> SimpleProvider<? super CapEntityIotaHolder.Wrapper> wrapItemEntityDelegate(E entity, Function<E, ItemDelegatingEntityIotaHolder> make) {
        return ForgeCapabilityHandler.provide(entity, HexCapabilities.IOTA, () -> new CapEntityIotaHolder.Wrapper((ItemDelegatingEntityIotaHolder)make.apply(entity)));
    }

    private static <CAP> SimpleProvider<CAP> provide(Entity entity, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return ForgeCapabilityHandler.provide(() -> ((Entity)entity).m_213877_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(BlockEntity be, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return ForgeCapabilityHandler.provide(() -> ((BlockEntity)be).m_58901_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(ItemStack stack, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return ForgeCapabilityHandler.provide(() -> ((ItemStack)stack).m_41619_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(BooleanSupplier invalidated, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return new SimpleProvider<CAP>(invalidated, capability, LazyOptional.of(supplier));
    }

    private static /* synthetic */ ADHexHolder lambda$attachItemCaps$7(HexHolderItem holder, ItemStack stack) {
        return new CapItemHexHolder(holder, stack);
    }

    private static /* synthetic */ ADIotaHolder lambda$attachItemCaps$4(IotaHolderItem holder, ItemStack stack) {
        return new CapItemIotaHolder(holder, stack);
    }

    private static /* synthetic */ ADMediaHolder lambda$attachItemCaps$0(MediaHolderItem holder, ItemStack stack) {
        return new CapItemMediaHolder(holder, stack);
    }

    private record SimpleProvider<CAP>(BooleanSupplier invalidated, Capability<CAP> capability, LazyOptional<CAP> instance) implements ICapabilityProvider
    {
        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (this.invalidated.getAsBoolean()) {
                return LazyOptional.empty();
            }
            return cap == this.capability ? this.instance.cast() : LazyOptional.empty();
        }
    }
}

