/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.particles;

import at.petrak.hexcasting.common.lib.HexParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public record ConjureParticleOptions(int color, boolean isLight) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<ConjureParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ConjureParticleOptions>(){

        public ConjureParticleOptions fromCommand(ParticleType<ConjureParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int color = reader.readInt();
            reader.expect(' ');
            boolean isLight = reader.readBoolean();
            return new ConjureParticleOptions(color, isLight);
        }

        public ConjureParticleOptions fromNetwork(ParticleType<ConjureParticleOptions> type, FriendlyByteBuf buf) {
            int col = buf.readInt();
            boolean isLight = buf.readBoolean();
            return new ConjureParticleOptions(col, isLight);
        }
    };

    public ParticleType<?> m_6012_() {
        return this.isLight ? HexParticles.LIGHT_PARTICLE : HexParticles.CONJURE_PARTICLE;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.color);
        buf.writeBoolean(this.isLight);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %s", this.color, this.isLight);
    }

    public static class Type
    extends ParticleType<ConjureParticleOptions> {
        public static final Codec<ConjureParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(o -> o.color), (App)Codec.BOOL.fieldOf("isLight").forGetter(ConjureParticleOptions::isLight)).apply((Applicative)instance, ConjureParticleOptions::new));

        public Type(boolean pOverrideLimiter) {
            super(pOverrideLimiter, DESERIALIZER);
        }

        public Codec<ConjureParticleOptions> m_7652_() {
            return CODEC;
        }
    }
}

