/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.colorizer;

import at.petrak.hexcasting.api.addldata.ADColorizer;
import at.petrak.hexcasting.api.item.ColorizerItem;
import at.petrak.paucal.api.PaucalAPI;
import at.petrak.paucal.api.contrib.Contributor;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ItemUUIDColorizer
extends Item
implements ColorizerItem {
    public ItemUUIDColorizer(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public int color(ItemStack stack, UUID owner, float time, Vec3 position) {
        List colorList;
        Contributor contributor = PaucalAPI.instance().getContributor(owner);
        if (contributor != null && (colorList = (List)contributor.get("hexcasting:colorizer")) != null) {
            int[] colors = new int[colorList.size()];
            boolean ok = true;
            for (int i = 0; i < colorList.size(); ++i) {
                Object elt = colorList.get(i);
                if (!(elt instanceof Number)) {
                    ok = false;
                    break;
                }
                Number n = (Number)elt;
                colors[i] = n.intValue() | 0xFF000000;
            }
            if (ok) {
                return ADColorizer.morphBetweenColors(colors, new Vec3(0.1, 0.1, 0.1), time / 20.0f / 20.0f, position);
            }
        }
        Random rand = new Random(owner.getLeastSignificantBits() ^ owner.getMostSignificantBits());
        float hue = rand.nextFloat();
        float saturation = rand.nextFloat(0.4f, 1.0f);
        float brightness = rand.nextFloat(0.5f, 1.0f);
        return Color.HSBtoRGB(hue, saturation, brightness);
    }
}

