/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.operators.stack;

import at.petrak.hexcasting.api.spell.Action;
import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.OperatorUtils;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.mishaps.MishapNotEnoughArgs;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lat/petrak/hexcasting/common/casting/operators/stack/OpBitMask;", "Lat/petrak/hexcasting/api/spell/Action;", "()V", "operate", "Lat/petrak/hexcasting/api/spell/OperationResult;", "continuation", "Lat/petrak/hexcasting/api/spell/casting/eval/SpellContinuation;", "stack", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "ravenmind", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "hexcasting-forge-1.19.2"})
public final class OpBitMask
implements Action {
    @NotNull
    public static final OpBitMask INSTANCE = new OpBitMask();

    private OpBitMask() {
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<Iota> stack, @Nullable Iota ravenmind, @NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (stack.size() < 1) {
            throw new MishapNotEnoughArgs(1, 0);
        }
        int mask = OperatorUtils.getPositiveInt$default(stack, CollectionsKt.getLastIndex(stack), 0, 2, null);
        CollectionsKt.removeLast(stack);
        int reqdArgc = 32 - Integer.numberOfLeadingZeros(mask);
        if (stack.size() < reqdArgc) {
            throw new MishapNotEnoughArgs(reqdArgc + 1, stack.size() + 1);
        }
        List out = new ArrayList();
        for (int i = 0; i < reqdArgc; ++i) {
            boolean bit;
            boolean bl = bit = (mask & 1 << i) == 1;
            if (bit) continue;
            out.add(stack.get(CollectionsKt.getLastIndex(stack) - i));
        }
        return new OperationResult(continuation, CollectionsKt.asReversedMutable((List)out), ravenmind, CollectionsKt.emptyList());
    }

    @Override
    public boolean isGreat() {
        return Action.DefaultImpls.isGreat(this);
    }

    @Override
    public boolean getAlwaysProcessGreatSpell() {
        return Action.DefaultImpls.getAlwaysProcessGreatSpell(this);
    }

    @Override
    public boolean getCausesBlindDiversion() {
        return Action.DefaultImpls.getCausesBlindDiversion(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Action.DefaultImpls.getDisplayName(this);
    }
}

