/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.gui;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.client.RenderLib;
import at.petrak.hexcasting.common.misc.PatternTooltip;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Pair;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class PatternTooltipComponent
implements ClientTooltipComponent {
    public static final ResourceLocation PRISTINE_BG = HexAPI.modLoc("textures/gui/scroll.png");
    public static final ResourceLocation ANCIENT_BG = HexAPI.modLoc("textures/gui/scroll_ancient.png");
    public static final ResourceLocation SLATE_BG = HexAPI.modLoc("textures/gui/slate.png");
    private static final float RENDER_SIZE = 128.0f;
    private final HexPattern pattern;
    private final List<Vec2> zappyPoints;
    private final List<Vec2> pathfinderDots;
    private final float scale;
    private final ResourceLocation background;

    public PatternTooltipComponent(PatternTooltip tt) {
        this.pattern = tt.pattern();
        this.background = tt.background();
        Pair<Float, List<Vec2>> pair = RenderLib.getCenteredPattern(this.pattern, 128.0f, 128.0f, 16.0f);
        this.scale = ((Float)pair.getFirst()).floatValue();
        List dots = (List)pair.getSecond();
        this.zappyPoints = RenderLib.makeZappy(dots, RenderLib.findDupIndices(this.pattern.positions()), 10, 0.8f, 0.0f, 0.0f, 0.2f, 0.8f, 0.0);
        this.pathfinderDots = dots.stream().distinct().collect(Collectors.toList());
    }

    @Nullable
    public static ClientTooltipComponent tryConvert(TooltipComponent cmp) {
        if (cmp instanceof PatternTooltip) {
            PatternTooltip ptt = (PatternTooltip)cmp;
            return new PatternTooltipComponent(ptt);
        }
        return null;
    }

    public void m_183452_(Font font, int mouseX, int mouseY, PoseStack ps, ItemRenderer pItemRenderer, int pBlitOffset) {
        int width = this.m_142069_(font);
        int height = this.m_142103_();
        ps.m_85836_();
        ps.m_85837_((double)mouseX, (double)mouseY, 500.0);
        RenderSystem.m_69478_();
        PatternTooltipComponent.renderBG(ps, this.background, pBlitOffset);
        ps.m_85837_(0.0, 0.0, 100.0);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69464_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ps.m_85837_((double)((float)width / 2.0f), (double)((float)height / 2.0f), 1.0);
        Matrix4f mat = ps.m_85850_().m_85861_();
        int outer = -2963256;
        int innerLight = -928275806;
        int innerDark = -936236237;
        RenderLib.drawLineSeq(mat, this.zappyPoints, 6.0f, 0.0f, outer, outer);
        RenderLib.drawLineSeq(mat, this.zappyPoints, 2.4f, 0.0f, innerDark, innerLight);
        RenderLib.drawSpot(mat, this.zappyPoints.get(0), 2.5f, 1.0f, 0.1f, 0.15f, 0.6f);
        for (Vec2 dot : this.pathfinderDots) {
            RenderLib.drawSpot(mat, dot, 1.5f, 0.82f, 0.8f, 0.8f, 0.5f);
        }
        ps.m_85849_();
    }

    private static void renderBG(PoseStack ps, ResourceLocation background, int blitOffset) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)background);
        GuiComponent.m_93143_((PoseStack)ps, (int)0, (int)0, (int)blitOffset, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
    }

    public int m_142069_(Font pFont) {
        return 128;
    }

    public int m_142103_() {
        return 128;
    }
}

