/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.addldata;

import org.jetbrains.annotations.ApiStatus;

public interface ADMediaHolder {
    public static final int CHARGED_AMETHYST_PRIORITY = 1000;
    public static final int AMETHYST_SHARD_PRIORITY = 2000;
    public static final int AMETHYST_DUST_PRIORITY = 3000;
    public static final int BATTERY_PRIORITY = 4000;

    @ApiStatus.OverrideOnly
    public int getMedia();

    @ApiStatus.OverrideOnly
    public int getMaxMedia();

    @ApiStatus.OverrideOnly
    public void setMedia(int var1);

    public boolean canRecharge();

    public boolean canProvide();

    public int getConsumptionPriority();

    public boolean canConstructBattery();

    default public int withdrawMedia(int cost, boolean simulate) {
        int mediaHere = this.getMedia();
        if (cost < 0) {
            cost = mediaHere;
        }
        if (!simulate) {
            int mediaLeft = mediaHere - cost;
            this.setMedia(mediaLeft);
        }
        return Math.min(cost, mediaHere);
    }

    default public int insertMedia(int amount, boolean simulate) {
        int mediaHere = this.getMedia();
        int emptySpace = this.getMaxMedia() - mediaHere;
        if (emptySpace <= 0) {
            return 0;
        }
        if (amount < 0) {
            amount = emptySpace;
        }
        int inserting = Math.min(amount, emptySpace);
        if (!simulate) {
            int newMedia = mediaHere + inserting;
            this.setMedia(newMedia);
        }
        return inserting;
    }
}

