/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;

public final class FramingSawRecipeCache {
    private static final FramingSawRecipeCache SERVER_INSTANCE = new FramingSawRecipeCache();
    private static final FramingSawRecipeCache CLIENT_INSTANCE = new FramingSawRecipeCache();
    private final List<FramingSawRecipe> recipes = new ArrayList<FramingSawRecipe>();
    private final Set<Item> containsAdditive = Sets.newIdentityHashSet();
    private final Object2IntMap<Item> materialValues = new Object2IntOpenCustomHashMap(Util.m_137583_());

    public void update(RecipeManager recipeManager) {
        this.clear();
        this.recipes.addAll(recipeManager.m_44013_((RecipeType)FBContent.recipeTypeFramingSawRecipe.get()));
        this.recipes.sort(FramingSawRecipeCache::sortRecipes);
        this.recipes.forEach(recipe -> {
            ItemStack result = recipe.m_8043_();
            if (recipe.getAdditive() != null) {
                this.containsAdditive.add(result.m_41720_());
            }
            int materialValue = recipe.getMaterialAmount();
            this.materialValues.put((Object)result.m_41720_(), materialValue / result.m_41613_());
        });
        this.recipes.removeIf(FramingSawRecipe::isDisabled);
    }

    public void clear() {
        this.recipes.clear();
        this.containsAdditive.clear();
        this.materialValues.clear();
    }

    public List<FramingSawRecipe> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    public Set<Item> getKnownItems() {
        return this.materialValues.keySet();
    }

    public int getMaterialValue(Item item) {
        return this.materialValues.getOrDefault((Object)item, -1);
    }

    public boolean containsAdditive(Item item) {
        return this.containsAdditive.contains(item);
    }

    public static FramingSawRecipeCache get(boolean client) {
        return client ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Reloader(event.getServerResources()));
    }

    private static int sortRecipes(FramingSawRecipe r1, FramingSawRecipe r2) {
        String ns2;
        String ns1 = ForgeRegistries.ITEMS.getKey((Object)r1.m_8043_().m_41720_()).m_135827_();
        if (!ns1.equals(ns2 = ForgeRegistries.ITEMS.getKey((Object)r2.m_8043_().m_41720_()).m_135827_())) {
            if (ns1.equals("framedblocks")) {
                return -1;
            }
            if (ns2.equals("framedblocks")) {
                return 1;
            }
            return ns1.compareTo(ns2);
        }
        IBlockType t1 = r1.getResultType();
        IBlockType t2 = r2.getResultType();
        return t1.compareTo(t2);
    }

    private record Reloader(ReloadableServerResources serverResources) implements ResourceManagerReloadListener
    {
        public void m_6213_(ResourceManager resourceManager) {
            SERVER_INSTANCE.update(this.serverResources.m_206887_());
        }
    }
}

