/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramingSawBlock;
import xfacthd.framedblocks.common.compat.jei.FramedJeiPlugin;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;

public final class FramingSawRecipeCategory
implements IRecipeCategory<FramingSawRecipe> {
    private static final ResourceLocation BACKGROUND = Utils.rl("textures/gui/framing_saw_jei.png");
    private static final int WIDTH = 82;
    private static final int HEIGHT = 41;
    private static final int WARNING_X = 20;
    private static final int WARNING_Y = 3;
    private static final int WARNING_SIZE = 16;
    private static final float WARNING_SCALE = 0.75f;
    private static final int WARNING_DRAW_SIZE = 12;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable warning;

    public FramingSawRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND, 0, 0, 82, 41);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)FBContent.blockFramingSaw.get()));
        this.warning = guiHelper.drawableBuilder(FramingSawScreen.WARNING_ICON, 8, 8, 16, 16).setTextureSize(32, 32).build();
    }

    public RecipeType<FramingSawRecipe> getRecipeType() {
        return FramedJeiPlugin.FRAMING_SAW_RECIPE_TYPE;
    }

    public Component getTitle() {
        return FramingSawBlock.MENU_TITLE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FramingSawRecipe recipe, IFocusGroup focuses) {
        FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
        Ingredient additive = recipe.getAdditive();
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setSlotName("input");
        IRecipeSlotBuilder additiveSlot = null;
        if (additive != null) {
            additiveSlot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 24);
        }
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 13);
        ItemStack inputStack = focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).map(focus -> (ItemStack)focus.getTypedValue().getIngredient()).filter(stack -> cache.getMaterialValue(stack.m_41720_()) > 0).findFirst().orElse(ItemStack.f_41583_);
        if (focuses.isEmpty()) {
            for (Item input : cache.getKnownItems()) {
                FramingSawRecipeCategory.setRecipe(input, recipe, inputSlot, additiveSlot, outputSlot);
            }
            if (additive != null) {
                builder.createFocusLink(new IIngredientAcceptor[]{inputSlot, additiveSlot, outputSlot});
            } else {
                builder.createFocusLink(new IIngredientAcceptor[]{inputSlot, outputSlot});
            }
        } else if (!inputStack.m_41619_()) {
            FramingSawRecipeCategory.setRecipe(inputStack.m_41720_(), recipe, inputSlot, additiveSlot, outputSlot);
        } else {
            FramingSawRecipeCategory.setRecipe(((Block)FBContent.blockFramedCube.get()).m_5456_(), recipe, inputSlot, additiveSlot, outputSlot);
        }
    }

    private static void setRecipe(Item input, FramingSawRecipe recipe, IRecipeSlotBuilder inputSlot, IRecipeSlotBuilder additiveSlot, IRecipeSlotBuilder outputSlot) {
        IntIntPair counts = recipe.getInputOutputCount(input, true);
        ItemStack inputStack = new ItemStack((ItemLike)input, counts.leftInt());
        ItemStack outputStack = recipe.m_8043_().m_41777_();
        outputStack.m_41764_(counts.rightInt());
        Ingredient additive = recipe.getAdditive();
        if (additive != null) {
            int addCount = recipe.getAdditiveCount() * (counts.rightInt() / recipe.m_8043_().m_41613_());
            Stream.of(additive.m_43908_()).map(ItemStack::m_41777_).peek(s -> s.m_41764_(addCount)).forEach(additiveStack -> FramingSawRecipeCategory.setRecipe(inputStack, additiveStack, outputStack, inputSlot, additiveSlot, outputSlot));
        } else {
            FramingSawRecipeCategory.setRecipe(inputStack, null, outputStack, inputSlot, additiveSlot, outputSlot);
        }
    }

    private static void setRecipe(ItemStack input, ItemStack additive, ItemStack output, IRecipeSlotBuilder inputSlot, IRecipeSlotBuilder additiveSlot, IRecipeSlotBuilder outputSlot) {
        inputSlot.addItemStack(input);
        if (additive != null) {
            additiveSlot.addItemStack(additive);
        }
        outputSlot.addItemStack(output);
    }

    public void draw(FramingSawRecipe recipe, IRecipeSlotsView slots, PoseStack poseStack, double mouseX, double mouseY) {
        ItemStack input = (ItemStack)((IRecipeSlotView)slots.findSlotByName("input").orElseThrow()).getDisplayedItemStack().orElseThrow();
        if (FramingSawRecipeCache.get(true).containsAdditive(input.m_41720_())) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
            poseStack.m_85837_(26.666667938232422, 4.0, 0.0);
            this.warning.draw(poseStack);
            poseStack.m_85849_();
        }
    }

    public List<Component> getTooltipStrings(FramingSawRecipe recipe, IRecipeSlotsView slots, double mouseX, double mouseY) {
        if (mouseX >= 20.0 && mouseY >= 3.0 && mouseX <= 32.0 && mouseY <= 15.0) {
            ItemStack input = (ItemStack)((IRecipeSlotView)slots.findSlotByName("input").orElseThrow()).getDisplayedItemStack().orElseThrow();
            if (FramingSawRecipeCache.get(true).containsAdditive(input.m_41720_())) {
                return List.of(FramingSawScreen.TOOLTIP_LOOSE_ADDITIVE);
            }
        }
        return List.of();
    }
}

