/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.data.CamoContainer;
import xfacthd.framedblocks.api.data.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.client.ClientUtils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.util.DoubleBlockSoundType;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public abstract class FramedDoubleBlockEntity
extends FramedBlockEntity {
    public static final ModelProperty<ModelData> DATA_LEFT = new ModelProperty();
    public static final ModelProperty<ModelData> DATA_RIGHT = new ModelProperty();
    private final FramedBlockData modelData = new FramedBlockData();
    private final DoubleBlockSoundType soundType = new DoubleBlockSoundType(this);
    private Tuple<BlockState, BlockState> blockPair;
    private CamoContainer camoContainer = EmptyCamoContainer.EMPTY;

    public FramedDoubleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.blockPair = AbstractFramedDoubleBlock.getStatePair(state);
        this.modelData.setUseAltModel(true);
    }

    @Override
    public void setCamo(CamoContainer camo, boolean secondary) {
        if (secondary) {
            int light = this.getLightValue();
            this.camoContainer = camo;
            this.m_6596_();
            if (this.getLightValue() != light) {
                this.doLightUpdate();
            }
            if (!this.updateDynamicStates(true, true)) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        } else {
            super.setCamo(camo, false);
        }
    }

    @Override
    public CamoContainer getCamo(BlockState state) {
        if (state == this.blockPair.m_14418_()) {
            return this.getCamo();
        }
        if (state == this.blockPair.m_14419_()) {
            return this.getCamoTwo();
        }
        return EmptyCamoContainer.EMPTY;
    }

    @Override
    protected CamoContainer getCamo(boolean secondary) {
        return secondary ? this.camoContainer : this.getCamo();
    }

    public final CamoContainer getCamoTwo() {
        return this.camoContainer;
    }

    @Override
    public int getLightValue() {
        return Math.max(this.camoContainer.getState().m_60791_(), super.getLightValue());
    }

    @Override
    public void addCamoDrops(List<ItemStack> drops) {
        super.addCamoDrops(drops);
        if (!this.camoContainer.isEmpty()) {
            drops.add(this.camoContainer.toItemStack(ItemStack.f_41583_));
        }
    }

    @Override
    public MaterialColor getMapColor() {
        if (!this.camoContainer.isEmpty()) {
            return this.camoContainer.getState().m_60780_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        return super.getMapColor();
    }

    @Override
    public float[] getCamoBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        float[] localMult;
        float[] superMult = super.getCamoBeaconColorMultiplier(level, pos, beaconPos);
        float[] fArray = localMult = this.camoContainer.isEmpty() ? null : this.camoContainer.getBeaconColorMultiplier(level, pos, beaconPos);
        if (superMult == null) {
            return localMult;
        }
        if (localMult == null) {
            return superMult;
        }
        return new float[]{(superMult[0] + localMult[0]) / 2.0f, (superMult[1] + localMult[1]) / 2.0f, (superMult[2] + localMult[2]) / 2.0f};
    }

    @Override
    public boolean shouldCamoDisplayFluidOverlay(BlockAndTintGetter level, BlockPos pos, FluidState fluid) {
        if (this.camoContainer.isEmpty() || this.camoContainer.getState().shouldDisplayFluidOverlay(level, pos, fluid)) {
            return true;
        }
        return super.shouldCamoDisplayFluidOverlay(level, pos, fluid);
    }

    @Override
    protected boolean isCamoSolid() {
        if (this.camoContainer.isEmpty()) {
            return false;
        }
        return super.isCamoSolid() && this.camoContainer.getState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
    }

    @Override
    public float getCamoExplosionResistance(Explosion explosion) {
        return Math.max(super.getCamoExplosionResistance(explosion), this.camoContainer.getState().getExplosionResistance((BlockGetter)this.f_58857_, this.f_58858_, explosion));
    }

    @Override
    public boolean isCamoFlammable(Direction face) {
        CamoContainer camo = this.getCamo(face);
        if (!(!camo.isEmpty() || this.getCamo().isEmpty() && this.camoContainer.isEmpty())) {
            return !(!this.getCamo().isEmpty() && !this.getCamo().getState().isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face) || !this.camoContainer.isEmpty() && !this.camoContainer.getState().isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face));
        }
        if (!camo.isEmpty()) {
            return camo.getState().isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face);
        }
        return true;
    }

    @Override
    public int getCamoFlammability(Direction face) {
        int flammabilityTwo;
        int flammabilityOne = super.getCamoFlammability(face);
        int n = flammabilityTwo = this.camoContainer.isEmpty() ? -1 : this.camoContainer.getState().getFlammability((BlockGetter)this.f_58857_, this.f_58858_, face);
        if (flammabilityOne == -1) {
            return flammabilityTwo;
        }
        if (flammabilityTwo == -1) {
            return flammabilityOne;
        }
        return Math.min(flammabilityOne, flammabilityTwo);
    }

    @Override
    public int getCamoFireSpreadSpeed(Direction face) {
        int spreadSpeedTwo;
        int spreadSpeedOne = super.getCamoFireSpreadSpeed(face);
        int n = spreadSpeedTwo = this.camoContainer.isEmpty() ? -1 : this.camoContainer.getState().getFireSpreadSpeed((BlockGetter)this.f_58857_, this.f_58858_, face);
        if (spreadSpeedOne == -1) {
            return spreadSpeedOne;
        }
        if (spreadSpeedTwo == -1) {
            return spreadSpeedTwo;
        }
        return Math.min(spreadSpeedOne, spreadSpeedTwo);
    }

    public final DoubleBlockSoundType getSoundType() {
        return this.soundType;
    }

    @Override
    protected abstract boolean hitSecondary(BlockHitResult var1);

    public abstract DoubleSoundMode getSoundMode();

    @Override
    public boolean updateCulling(Direction side, boolean rerender) {
        boolean changed = this.updateCulling(this.getModelDataInternal(), (BlockState)this.blockPair.m_14418_(), side, rerender);
        return changed |= this.updateCulling(this.modelData, (BlockState)this.blockPair.m_14419_(), side, rerender);
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.blockPair = AbstractFramedDoubleBlock.getStatePair(state);
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        nbt.m_128365_("camo_two", (Tag)CamoContainer.save(this.camoContainer));
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        boolean needUpdate = false;
        CamoContainer newCamo = CamoContainer.load(nbt.m_128469_("camo_two"));
        if (!newCamo.equals(this.camoContainer)) {
            int oldLight = this.getLightValue();
            this.camoContainer = newCamo;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.modelData.setCamoState(this.camoContainer.getState());
            needUpdate = true;
            this.updateCulling(true, false);
        }
        boolean newReinforced = nbt.m_128471_("reinforced");
        if (this.isReinforced() != newReinforced) {
            this.modelData.setReinforced(newReinforced);
            needUpdate = true;
        }
        return super.readFromDataPacket(nbt) || needUpdate;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("camo_two", (Tag)CamoContainer.save(this.camoContainer));
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        CamoContainer newCamo = CamoContainer.load(nbt.m_128469_("camo_two"));
        if (!newCamo.equals(this.camoContainer)) {
            this.camoContainer = newCamo;
            this.modelData.setCamoState(this.camoContainer.getState());
            ClientUtils.enqueueClientTask(() -> this.updateCulling(true, true));
        }
        boolean newReinforced = nbt.m_128471_("reinforced");
        if (this.isReinforced() != newReinforced) {
            this.modelData.setReinforced(newReinforced);
        }
    }

    @Override
    public ModelData getModelData() {
        return ModelData.builder().with(DATA_LEFT, (Object)super.getModelData()).with(DATA_RIGHT, (Object)ModelData.builder().with(FramedBlockData.PROPERTY, (Object)this.modelData).build()).build();
    }

    @Override
    protected void initModelData() {
        super.initModelData();
        this.modelData.setCamoState(this.camoContainer.getState());
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("camo_two", (Tag)CamoContainer.save(this.camoContainer));
        super.m_183515_(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CamoContainer camo = CamoContainer.load(nbt.m_128469_("camo_two"));
        if (camo.isEmpty() || this.isValidBlock(camo.getState(), null)) {
            this.camoContainer = camo;
        } else {
            FramedBlocks.LOGGER.warn("Framed Block of type \"{}\" at position {} contains an invalid camo of type \"{}\", removing camo! This might be caused by a config or tag change!", new Object[]{ForgeRegistries.BLOCKS.getKey((Object)this.m_58900_().m_60734_()), this.f_58858_, ForgeRegistries.BLOCKS.getKey((Object)camo.getState().m_60734_())});
        }
    }
}

