/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.door;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.client.ClientUtils;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedDoorBlock
extends DoorBlock
implements IFramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) {
            if (state.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.LEFT) {
                return facing.m_122428_() == dir;
            }
            return facing.m_122427_() == dir;
        }
        return facing.m_122424_() == dir;
    };
    private final BlockType type;
    public static final Material IRON_WOOD = new Material(Material.f_76320_.m_76339_(), Material.f_76320_.m_76332_(), Material.f_76320_.m_76333_(), Material.f_76320_.m_76334_(), Material.f_76320_.m_76337_(), Material.f_76320_.m_76335_(), Material.f_76320_.m_76336_(), Material.f_76320_.m_76338_());

    private FramedDoorBlock(BlockType type, BlockBehaviour.Properties props) {
        super(props);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.SOLID, FramedProperties.GLOWING});
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = this.handleUse(state, level, pos, player, hand, hit);
        if (result.m_19077_()) {
            return result;
        }
        return this.f_60442_ == IRON_WOOD ? InteractionResult.PASS : super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        this.tryApplyCamoImmediately(level, pos, placer, stack);
        this.tryApplyCamoImmediately(level, pos.m_7494_(), placer, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
        if (level.m_5776_()) {
            if (newState == state) {
                this.updateCulling(level, currentPos, facingState, facing, false);
            } else if (newState.m_60795_()) {
                BlockPos pos = currentPos.m_7949_();
                Direction dir = (Direction)state.m_61143_((Property)f_52726_);
                EnumSet<Direction> faces = EnumSet.of(dir.m_122427_(), dir.m_122428_(), state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER ? Direction.UP : Direction.DOWN);
                ClientUtils.enqueueClientTask(3L, () -> {
                    for (Direction face : faces) {
                        BlockEntity patt4526$temp = level.m_7702_(pos.m_121945_(face));
                        if (!(patt4526$temp instanceof FramedBlockEntity)) continue;
                        FramedBlockEntity be = (FramedBlockEntity)patt4526$temp;
                        be.updateCulling(face.m_122424_(), true);
                    }
                });
            }
        }
        return newState;
    }

    protected int m_52811_() {
        return this.f_60442_ == IRON_WOOD ? 1011 : 1012;
    }

    protected int m_52812_() {
        return this.f_60442_ == IRON_WOOD ? 1005 : 1006;
    }

    public boolean m_7923_(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    public static FramedDoorBlock wood() {
        return new FramedDoorBlock(BlockType.FRAMED_DOOR, IFramedBlock.createProperties(BlockType.FRAMED_DOOR));
    }

    public static FramedDoorBlock iron() {
        return new FramedDoorBlock(BlockType.FRAMED_IRON_DOOR, IFramedBlock.createProperties(BlockType.FRAMED_IRON_DOOR, IRON_WOOD).m_60999_());
    }
}

