/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.util.ItemRenderHelper;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.jei.JeiCompat;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.menu.FramingSawMenu;
import xfacthd.framedblocks.common.util.RecipeUtils;

public class FramingSawScreen
extends AbstractContainerScreen<FramingSawMenu> {
    public static final String TOOLTIP_MATERIAL = Utils.translationKey("tooltip", "framing_saw.material");
    public static final Component TOOLTIP_LOOSE_ADDITIVE = Utils.translate("tooltip", "framing_saw.loose_additive");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_item");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_TAG = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_tag");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_item_count");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_MATERIAL_COUNT = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_material_count");
    public static final Component TOOLTIP_HAVE_ITEM_NONE = Utils.translate("tooltip", "framing_saw.have_item_none").m_130940_(ChatFormatting.GOLD);
    public static final String TOOLTIP_PRESS_TO_SHOW = Utils.translationKey("tooltip", "framing_saw.press_to_show");
    private static final ResourceLocation BACKGROUND = Utils.rl("textures/gui/framing_saw.png");
    public static final ResourceLocation WARNING_ICON = new ResourceLocation("forge", "textures/gui/experimental_warning.png");
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 233;
    private static final int RECIPES_X = 48;
    private static final int RECIPES_Y = 18;
    private static final int RECIPE_ROWS = 6;
    private static final int RECIPE_COLS = 8;
    private static final int RECIPE_COUNT = 48;
    private static final int RECIPE_WIDTH = 18;
    private static final int RECIPE_HEIGHT = 18;
    private static final int SCROLL_BAR_X = 195;
    private static final int SCROLL_BAR_Y = 18;
    private static final int SCROLL_BTN_WIDTH = 12;
    private static final int SCROLL_BTN_HEIGHT = 15;
    private static final int SCROLL_BTN_TEX_X = 54;
    private static final int SCROLL_BAR_HEIGHT = 108;
    private static final int WARNING_X = 20;
    private static final int WARNING_Y = 64;
    private final FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
    private final ItemStack cubeStack = new ItemStack((ItemLike)FBContent.blockFramedCube.get());
    private int firstIndex = 0;
    private boolean scrolling = false;
    private float scrollOffset = 0.0f;

    public FramingSawScreen(FramingSawMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        --this.f_97729_;
        this.f_97730_ = 47;
        this.f_97731_ = 139;
        this.f_97726_ = 256;
        this.f_97727_ = 233;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int offset = (int)(93.0f * this.scrollOffset);
        int scrollU = 54 + (this.isScrollBarActive() ? 0 : 12);
        this.m_93228_(poseStack, this.f_97735_ + 195, this.f_97736_ + 18 + offset, scrollU, this.f_97727_, 12, 15);
        ItemStack input = ((FramingSawMenu)this.f_97732_).getInputStack();
        if (!input.m_41619_() && this.cache.containsAdditive(input.m_41720_())) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)WARNING_ICON);
            FramingSawScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 20), (int)(this.f_97736_ + 64), (float)8.0f, (float)8.0f, (int)24, (int)24, (int)32, (int)32);
            RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        }
        int idx = ((FramingSawMenu)this.f_97732_).getSelectedRecipeIndex();
        if (((FramingSawMenu)this.f_97732_).hasRecipeChanged()) {
            this.tryScrollToRecipe(idx);
        }
        int recX = this.f_97735_ + 48;
        int recY = this.f_97736_ + 18;
        int lastIndex = this.firstIndex + 48;
        this.renderButtons(poseStack, mouseX, mouseY, recX, recY, lastIndex);
        this.renderRecipes(recX, recY, lastIndex);
        List<FramingSawRecipe> recipes = this.cache.getRecipes();
        if (idx >= 0 && idx < recipes.size()) {
            Ingredient additive;
            FramingSawRecipe recipe = recipes.get(idx);
            if (input.m_41619_()) {
                ItemRenderHelper.renderFakeItemTransparent(this.cubeStack, this.f_97735_ + 20, this.f_97736_ + 46, 127);
            }
            if ((additive = recipe.getAdditive()) != null && !additive.m_43947_() && ((FramingSawMenu)this.f_97732_).getAdditiveStack().m_41619_()) {
                ItemStack[] items = additive.m_43908_();
                int i = (int)(System.currentTimeMillis() / 1700L) % items.length;
                ItemRenderHelper.renderFakeItemTransparent(items[i], this.f_97735_ + 20, this.f_97736_ + 82, 127);
            }
        }
    }

    private void tryScrollToRecipe(int idx) {
        if (idx != -1 && (idx < this.firstIndex || idx >= this.firstIndex + 48)) {
            int row = idx / 8 - 2;
            int hidden = this.getHiddenRows();
            this.scrollOffset = (float)row / (float)hidden;
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.firstIndex = this.calculateFirstIndex(hidden);
        }
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        if (((FramingSawMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            this.renderItemTooltip(poseStack, mouseX, mouseY, this.f_97734_.m_7993_(), null);
            return;
        }
        ItemStack input = ((FramingSawMenu)this.f_97732_).getInputStack();
        if (!input.m_41619_() && this.m_6774_(20, 64, 16, 16, mouseX, mouseY) && this.cache.containsAdditive(input.m_41720_())) {
            this.m_96602_(poseStack, TOOLTIP_LOOSE_ADDITIVE, mouseX, mouseY);
            return;
        }
        int x = this.f_97735_ + 48;
        int y = this.f_97736_ + 18;
        int last = this.firstIndex + 48;
        List<FramingSawMenu.RecipeHolder> recipes = ((FramingSawMenu)this.f_97732_).getRecipes();
        for (int idx = this.firstIndex; idx < last && idx < recipes.size(); ++idx) {
            int relIdx = idx - this.firstIndex;
            int recX = x + relIdx % 8 * 18;
            int recY = y + relIdx / 8 * 18;
            if (mouseX < recX || mouseX >= recX + 18 || mouseY < recY || mouseY >= recY + 18) continue;
            FramingSawMenu.RecipeHolder recipe = recipes.get(idx);
            ItemStack result = recipe.getRecipe().m_8043_();
            this.renderItemTooltip(poseStack, mouseX, mouseY, result, recipe);
        }
    }

    private void renderItemTooltip(PoseStack poseStack, int mouseX, int mouseY, ItemStack stack, FramingSawMenu.RecipeHolder recipeHolder) {
        ArrayList<Component> components = new ArrayList<Component>(this.m_96555_(stack));
        Optional tooltip = stack.m_150921_();
        int material = this.cache.getMaterialValue(stack.m_41720_());
        if (material > 0) {
            components.add((Component)Component.m_237110_((String)TOOLTIP_MATERIAL, (Object[])new Object[]{material}));
        }
        if (recipeHolder != null) {
            this.appendRecipeFailure(components, recipeHolder);
        }
        this.renderTooltip(poseStack, components, tooltip, mouseX, mouseY, null, stack);
    }

    private void appendRecipeFailure(List<Component> components, FramingSawMenu.RecipeHolder recipeHolder) {
        FramingSawRecipe recipe = recipeHolder.getRecipe();
        FramingSawRecipe.FailReason failReason = recipeHolder.getFailReason();
        if (!failReason.success()) {
            components.add(failReason.translation());
            ItemStack input = ((FramingSawMenu)this.f_97732_).getInputStack();
            boolean listAdditives = false;
            MutableComponent detail = switch (failReason) {
                default -> throw new IncompatibleClassChangeError();
                case FramingSawRecipe.FailReason.MATERIAL_VALUE -> {
                    int matIn = input.m_41619_() ? 0 : this.cache.getMaterialValue(input.m_41720_()) * input.m_41613_();
                    int matReq = recipe.getMaterialAmount();
                    yield Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_MATERIAL_COUNT, (Object[])new Object[]{Component.m_237113_((String)Integer.toString(matIn)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)Integer.toString(matReq)).m_130940_(ChatFormatting.GOLD)});
                }
                case FramingSawRecipe.FailReason.MATERIAL_LCM -> {
                    int cntIn = input.m_41613_();
                    int cntReq = recipe.getInputAndAdditiveCount(input, true).firstInt();
                    yield Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT, (Object[])new Object[]{Component.m_237113_((String)Integer.toString(cntIn)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)Integer.toString(cntReq)).m_130940_(ChatFormatting.GOLD)});
                }
                case FramingSawRecipe.FailReason.MISSING_ADDITIVE -> {
                    listAdditives = true;
                    yield FramingSawScreen.makeHaveButNeedTooltip(TOOLTIP_HAVE_ITEM_NONE, Objects.requireNonNull(recipe.getAdditive()));
                }
                case FramingSawRecipe.FailReason.UNEXPECTED_ADDITIVE -> {
                    Item itemIn = ((FramingSawMenu)this.f_97732_).getAdditiveStack().m_41720_();
                    yield Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM, (Object[])new Object[]{Component.m_237115_((String)itemIn.m_5524_()).m_130940_(ChatFormatting.GOLD), TOOLTIP_HAVE_ITEM_NONE});
                }
                case FramingSawRecipe.FailReason.INCORRECT_ADDITIVE -> {
                    listAdditives = true;
                    Item itemIn = ((FramingSawMenu)this.f_97732_).getAdditiveStack().m_41720_();
                    yield FramingSawScreen.makeHaveButNeedTooltip((Component)Component.m_237115_((String)itemIn.m_5524_()).m_130940_(ChatFormatting.GOLD), Objects.requireNonNull(recipe.getAdditive()));
                }
                case FramingSawRecipe.FailReason.INSUFFICIENT_ADDITIVE -> {
                    int cntIn = ((FramingSawMenu)this.f_97732_).getAdditiveStack().m_41613_();
                    int cntReq = recipe.getInputAndAdditiveCount(input, true).secondInt();
                    yield Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT, (Object[])new Object[]{Component.m_237113_((String)Integer.toString(cntIn)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)Integer.toString(cntReq)).m_130940_(ChatFormatting.GOLD)});
                }
                case FramingSawRecipe.FailReason.NONE -> throw new IllegalStateException("Unreachable");
            };
            components.add((Component)detail.m_130940_(ChatFormatting.RED));
            if (listAdditives && recipe.getAdditive().m_43908_().length > 1) {
                if (FramingSawScreen.m_96638_()) {
                    for (ItemStack option : recipe.getAdditive().m_43908_()) {
                        components.add((Component)Component.m_237113_((String)"- ").m_7220_(option.m_41720_().m_41466_()).m_130940_(ChatFormatting.GOLD));
                    }
                } else {
                    Component keyName = InputConstants.m_84827_((int)340, (int)-1).m_84875_();
                    components.add((Component)Component.m_237110_((String)TOOLTIP_PRESS_TO_SHOW, (Object[])new Object[]{Component.m_237113_((String)"").m_7220_(keyName).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    private static MutableComponent makeHaveButNeedTooltip(Component present, Ingredient additive) {
        Ingredient.Value value;
        ItemStack[] options = additive.m_43908_();
        if (options.length > 1 && (value = RecipeUtils.getSingleIngredientValue(additive)) instanceof Ingredient.TagValue) {
            Ingredient.TagValue value2 = (Ingredient.TagValue)value;
            TagKey<Item> tag = RecipeUtils.getItemTagFromValue(value2);
            return Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_TAG, (Object[])new Object[]{present, Component.m_237113_((String)("#" + tag.f_203868_())).m_130940_(ChatFormatting.GOLD)});
        }
        return Component.m_237110_((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM, (Object[])new Object[]{present, Component.m_237115_((String)options[0].m_41720_().m_5524_()).m_130940_(ChatFormatting.GOLD)});
    }

    private void renderButtons(PoseStack poseStack, int mouseX, int mouseY, int x, int y, int lastIdx) {
        List<FramingSawMenu.RecipeHolder> recipes = ((FramingSawMenu)this.f_97732_).getRecipes();
        for (int idx = this.firstIndex; idx < lastIdx && idx < recipes.size(); ++idx) {
            int relIdx = idx - this.firstIndex;
            int recX = x + relIdx % 8 * 18;
            int recY = y + relIdx / 8 * 18;
            int u = 0;
            boolean hovered = false;
            if (idx == ((FramingSawMenu)this.f_97732_).getSelectedRecipeIndex()) {
                u += 18;
            } else if (mouseX >= recX && mouseY >= recY && mouseX < recX + 18 && mouseY < recY + 18) {
                u += 36;
                hovered = true;
            }
            if (!hovered && !recipes.get(idx).getFailReason().success()) {
                RenderSystem.m_157429_((float)0.9f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.m_93228_(poseStack, recX, recY, u, this.f_97727_, 18, 18);
        }
    }

    private void renderRecipes(int pLeft, int pTop, int lastIndex) {
        List<FramingSawMenu.RecipeHolder> recipes = ((FramingSawMenu)this.f_97732_).getRecipes();
        for (int idx = this.firstIndex; idx < lastIndex && idx < recipes.size(); ++idx) {
            int relIdx = idx - this.firstIndex;
            int x = pLeft + relIdx % 8 * 18 + 1;
            int y = pTop + relIdx / 8 * 18 + 1;
            this.f_96541_.m_91291_().m_115203_(recipes.get(idx).getRecipe().m_8043_(), x, y);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int x = this.f_97735_ + 48;
        int y = this.f_97736_ + 18;
        int lastIdx = this.firstIndex + 48;
        for (int idx = this.firstIndex; idx < lastIdx; ++idx) {
            int relIdx = idx - this.firstIndex;
            double recRelX = mouseX - (double)(x + relIdx % 8 * 18);
            double recRelY = mouseY - (double)(y + relIdx / 8 * 18);
            if (recRelX < 0.0 || recRelY < 0.0 || recRelX > 18.0 || recRelY > 18.0 || !((FramingSawMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, idx)) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
            this.f_96541_.f_91072_.m_105208_(((FramingSawMenu)this.f_97732_).f_38840_, idx);
            return true;
        }
        if (this.isScrollBarActive()) {
            x = this.f_97735_ + 195;
            y = this.f_97736_ + 18;
            if (mouseX >= (double)x && mouseX < (double)(x + 12) && mouseY >= (double)y && mouseY < (double)(y + 108)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            float topY = this.f_97736_ + 18;
            float botY = topY + 108.0f;
            float freeScrollHeight = botY - topY - 15.0f;
            this.scrollOffset = ((float)mouseY - topY - 7.5f) / freeScrollHeight;
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.firstIndex = this.calculateFirstIndex(this.getHiddenRows());
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isScrollBarActive()) {
            int hiddenRows = this.getHiddenRows();
            float offset = (float)delta / (float)hiddenRows;
            this.scrollOffset = Mth.m_14036_((float)(this.scrollOffset - offset), (float)0.0f, (float)1.0f);
            this.firstIndex = this.calculateFirstIndex(hiddenRows);
        }
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (JeiCompat.isShowRecipePressed(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            Window window = Objects.requireNonNull(this.f_96541_).m_91268_();
            MouseHandler mouseHandler = this.f_96541_.f_91067_;
            double mouseX = mouseHandler.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
            double mouseY = mouseHandler.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_();
            double x = this.f_97735_ + 48;
            double y = this.f_97736_ + 18;
            if (mouseX >= x && mouseX <= x + 144.0 && mouseY >= y && mouseY <= y + 108.0) {
                int col = (int)((mouseX - x) / 18.0);
                int row = (int)((mouseY - y) / 18.0);
                int idx = row * 8 + col + this.firstIndex;
                List<FramingSawRecipe> recipes = this.cache.getRecipes();
                if (idx > 0 && idx < recipes.size() && JeiCompat.handleShowRecipeRequest(this.cache.getRecipes().get(idx).m_8043_())) {
                    return true;
                }
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private boolean isScrollBarActive() {
        return ((FramingSawMenu)this.f_97732_).getRecipes().size() > 48;
    }

    private int getHiddenRows() {
        return (((FramingSawMenu)this.f_97732_).getRecipes().size() + 8 - 1) / 8 - 6;
    }

    private int calculateFirstIndex(int hiddenRows) {
        return (int)((double)(this.scrollOffset * (float)hiddenRows) + 0.5) * 8;
    }
}

