/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedInnerSlopedPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction orientation;
    private final boolean ySlope;

    public FramedInnerSlopedPrismModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        this.orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadFace = quad.m_111306_();
        if (this.isStateInvalid()) {
            quadMap.get(quadFace).add(quad);
            return;
        }
        boolean yFacing = Utils.isY(this.facing);
        boolean yOrient = Utils.isY(this.orientation);
        if (quadFace == this.facing) {
            boolean up;
            if (this.ySlope && yFacing) {
                up = this.orientation == Direction.UP;
                QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeVerticalSlope(this.orientation, up ? -45.0f : 45.0f)).export(quadMap.get(null));
                Direction oriCW = this.orientation.m_122427_();
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(oriCW, 0.5f)).apply(Modifiers.cutTopBottom(this.orientation.m_122424_(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(oriCW, up ? -45.0f : 45.0f)).export(quadMap.get(null));
                Direction oriCCW = this.orientation.m_122428_();
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(oriCCW, 0.5f)).apply(Modifiers.cutTopBottom(this.orientation.m_122424_(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(oriCCW, up ? -45.0f : 45.0f)).export(quadMap.get(null));
            } else if (!this.ySlope && !yFacing && yOrient) {
                up = this.orientation == Direction.UP;
                QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
            }
            if (!yFacing && !yOrient) {
                boolean right = this.orientation == this.facing.m_122427_();
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.orientation, 0.5f)).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeHorizontalSlope(right, 45.0f)).export(quadMap.get(null));
                if (!this.ySlope) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.m_122424_(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
                    QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.m_122424_(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
                }
            } else if (!yFacing) {
                up = this.orientation == Direction.UP;
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(true, 0.5f)).apply(Modifiers.cutSideUpDown(up, 0.0f, 1.0f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(false, 0.5f)).apply(Modifiers.cutSideUpDown(up, 1.0f, 0.0f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).export(quadMap.get(null));
            }
        } else if (quadFace == this.orientation) {
            if (yOrient) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122427_(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122428_(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                if (this.ySlope) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.facing.m_122424_())).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
                }
            } else if (yFacing) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadFace.m_122427_(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadFace.m_122428_(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                if (!this.ySlope) {
                    boolean up = this.facing == Direction.UP;
                    QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.facing.m_122424_())).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
                }
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
            }
        } else if (quadFace.m_122434_() != this.orientation.m_122434_() && quadFace.m_122434_() != this.facing.m_122434_()) {
            if (this.ySlope && !yFacing && !yOrient) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), 0.5f)).apply(Modifiers.cutTopBottom(this.orientation.m_122424_(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), 0.5f)).apply(Modifiers.cutTopBottom(this.orientation.m_122424_(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
            } else if (!this.ySlope && yFacing) {
                boolean up = this.facing == Direction.UP;
                float top = up ? 1.0f : 0.0f;
                float bottom = up ? 0.0f : 1.0f;
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(up, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.m_122424_(), top, bottom)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
            }
        }
    }

    private boolean isStateInvalid() {
        return this.orientation.m_122434_() == this.facing.m_122434_();
    }

    @Override
    protected boolean transformAllQuads(BlockState state) {
        if (((Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE)).booleanValue()) {
            return true;
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
        return Utils.isY(facing) || Utils.isY(orientation);
    }

    public static BlockState itemSource() {
        return (BlockState)((BlockState)((Block)FBContent.blockFramedInnerSlopedPrism.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)PropertyHolder.ORIENTATION, (Comparable)Direction.EAST);
    }
}

