/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.compat.CompatHandler;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.data.BlueprintBehaviours;
import xfacthd.framedblocks.common.data.camo.CamoFactories;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;
import xfacthd.framedblocks.common.net.OpenSignScreenPacket;
import xfacthd.framedblocks.common.net.SignUpdatePacket;
import xfacthd.framedblocks.common.util.ApiImpl;
import xfacthd.framedblocks.common.util.CommonConfig;
import xfacthd.framedblocks.common.util.EventHandler;
import xfacthd.framedblocks.common.util.FramedCreativeTab;
import xfacthd.framedblocks.common.util.ServerConfig;

@Mod(value="framedblocks")
@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class FramedBlocks {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)Utils.rl("main"), () -> "1", "1"::equals, "1"::equals);
    public static final CreativeModeTab FRAMED_TAB = new FramedCreativeTab();

    public FramedBlocks() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        FBContent.init(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        FramedBlocksAPI.INSTANCE.accept(new ApiImpl());
        modBus.addListener(FramedBlocks::onCommonSetup);
        modBus.addListener(FramedBlocks::onLoadComplete);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventHandler::onBlockLeftClick);
        forgeBus.addListener(FramingSawRecipeCache::onAddReloadListener);
        CompatHandler.init();
        CrashReportCallables.registerCrashCallable((String)"FramedBlocks BlockEntity Warning", FramedBlocks::getBlockEntityWarning);
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        CHANNEL.messageBuilder(SignUpdatePacket.class, 0, NetworkDirection.PLAY_TO_SERVER).encoder(SignUpdatePacket::encode).decoder(SignUpdatePacket::decode).consumerNetworkThread(SignUpdatePacket::handle).add();
        CHANNEL.messageBuilder(OpenSignScreenPacket.class, 1, NetworkDirection.PLAY_TO_CLIENT).encoder(OpenSignScreenPacket::encode).decoder(OpenSignScreenPacket::new).consumerNetworkThread(OpenSignScreenPacket::handle).add();
        BlueprintBehaviours.register();
        AbstractFramedDoubleBlock.cacheStatePairs();
        CompatHandler.commonSetup();
    }

    private static void onLoadComplete(FMLLoadCompleteEvent event) {
        CamoFactories.lock();
        FramedBlueprintItem.lockRegistration();
    }

    private static String getBlockEntityWarning() {
        if (!ServerConfig.allowBlockEntities) {
            return "Not applicable";
        }
        return "\n\t\tThe 'allowBlockEntities' setting in the framedblocks-server.toml config file is enabled.\n\t\tIf this crash happened in FramedBlocks code, please try the following solutions before reporting:\n\t\t- If you can identify the block that was used as a camo and resulted in the crash, add the block to the blacklist tag\n\t\t- If you can't identify the block or the crash wasn't fixed, make a backup of the world and disable the mentioned config setting\n\t\tIf the crash still happens, please report it on the FramedBlocks GitHub repository\n";
    }
}

