/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.ingredient.storage.IngredientComponentStorageWrapperHandlerItemStack;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionHelpers;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminalscompat.IntegratedTerminalsCompat;
import org.cyclops.integratedterminalscompat.modcompat.jei.JEIIntegratedTerminalsConfig;
import org.cyclops.integratedterminalscompat.network.packet.TerminalStorageIngredientItemStackCraftingGridSetRecipe;

public class TerminalStorageRecipeTransferHandler<T extends ContainerTerminalStorageBase<?>>
implements IRecipeTransferHandler<T, CraftingRecipe> {
    private final IRecipeTransferHandlerHelper recipeTransferHandlerHelper;
    private final Class<T> clazz;
    private final MenuType<T> menuType;
    private CraftingRecipe lastSimulatedRecipe;
    private long previousChangeId;
    private IRecipeTransferError lastSimulatedError;

    public TerminalStorageRecipeTransferHandler(IRecipeTransferHandlerHelper recipeTransferHandlerHelper, Class<T> clazz, MenuType<T> menuType) {
        this.recipeTransferHandlerHelper = recipeTransferHandlerHelper;
        this.clazz = clazz;
        this.menuType = menuType;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.of(this.menuType);
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, CraftingRecipe recipe, IRecipeSlotsView recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        if (Objects.equals(((ContainerTerminalStorageBase)((Object)container)).getSelectedTab(), TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString())) {
            ITerminalStorageTabCommon tabCommon = ((ContainerTerminalStorageBase)((Object)container)).getTabCommon(((ContainerTerminalStorageBase)((Object)container)).getSelectedTab());
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
            if (!doTransfer) {
                TerminalStorageTabIngredientComponentClient tabClient = (TerminalStorageTabIngredientComponentClient)((ContainerTerminalStorageBase)((Object)container)).getTabClient(((ContainerTerminalStorageBase)((Object)container)).getSelectedTab());
                if (this.lastSimulatedRecipe == recipe && this.previousChangeId == (long)tabClient.getLastChangeId()) {
                    return this.lastSimulatedError;
                }
                IngredientCollectionPrototypeMap hayStackCraftingGrid = new IngredientCollectionPrototypeMap(IngredientComponent.ITEMSTACK);
                for (int slot = 0; slot < tabCommonCrafting.getInventoryCrafting().m_6643_(); ++slot) {
                    hayStackCraftingGrid.add((Object)tabCommonCrafting.getInventoryCrafting().m_8020_(slot));
                }
                IngredientCollectionPrototypeMap hayStackPlayer = new IngredientCollectionPrototypeMap(IngredientComponent.ITEMSTACK);
                hayStackPlayer.addAll((Iterable)player.m_150109_().f_35974_);
                List unfilteredIngredients = tabClient.getUnfilteredIngredientsView(((ContainerTerminalStorageBase)((Object)container)).getSelectedChannel());
                IIngredientCollapsedCollectionMutable hayStack = IngredientCollectionHelpers.createCollapsedCollection((IngredientComponent)IngredientComponent.ITEMSTACK);
                hayStack.addAll((Iterable)unfilteredIngredients.stream().filter(i -> i.getCraftingOption() == null).map(TerminalStorageTabIngredientComponentClient.InstanceWithMetadata::getInstance).collect(Collectors.toList()));
                ArrayList slotsMissingItems = Lists.newArrayList();
                for (IRecipeSlotView slotView : recipeLayout.getSlotViews()) {
                    ITypedIngredient typedIngredient;
                    if (slotView.isEmpty() || slotView.getRole() != RecipeIngredientRole.INPUT || (typedIngredient = (ITypedIngredient)slotView.getAllIngredients().findFirst().get()).getType() != VanillaTypes.ITEM_STACK) continue;
                    boolean found = false;
                    for (ItemStack itemStack2 : slotView.getAllIngredients().map(ITypedIngredient::getIngredient).collect(Collectors.toSet())) {
                        int matchCondition;
                        if (hayStackCraftingGrid.contains((Object)itemStack2, (Object)(matchCondition = JEIIntegratedTerminalsConfig.getItemStackMatchCondition(itemStack2)))) {
                            hayStackPlayer.remove((Object)itemStack2);
                            found = true;
                            break;
                        }
                        if (hayStackPlayer.contains((Object)itemStack2, (Object)matchCondition)) {
                            hayStackPlayer.remove((Object)itemStack2);
                            found = true;
                            break;
                        }
                        if (!hayStack.contains((Object)itemStack2, (Object)matchCondition)) continue;
                        hayStack.remove((Object)itemStack2);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    slotsMissingItems.add(slotView);
                }
                this.lastSimulatedRecipe = recipe;
                this.previousChangeId = tabClient.getLastChangeId();
                if (!slotsMissingItems.isEmpty()) {
                    MutableComponent message = Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.missing");
                    this.lastSimulatedError = this.recipeTransferHandlerHelper.createUserErrorForMissingSlots((Component)message, (Collection)slotsMissingItems);
                    return this.lastSimulatedError;
                }
                this.lastSimulatedError = null;
                return null;
            }
            IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper playerInventory = new IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper(IngredientComponent.ITEMSTACK, (IItemHandler)new InvWrapper((Container)player.m_150109_()));
            HashMap slottedIngredientsFromPlayer = Maps.newHashMap();
            HashMap slottedIngredientsFromStorage = Maps.newHashMap();
            int slotOffset = tabCommonCrafting.getSlotCrafting().f_40219_;
            int slotId = 0;
            for (IRecipeSlotView slotView : recipeLayout.getSlotViews()) {
                ITypedIngredient typedIngredient;
                if (!slotView.isEmpty() && slotView.getRole() == RecipeIngredientRole.INPUT && (typedIngredient = (ITypedIngredient)slotView.getAllIngredients().findFirst().get()).getType() == VanillaTypes.ITEM_STACK) {
                    boolean found = false;
                    Set allIngredients = slotView.getAllIngredients().map(ITypedIngredient::getIngredient).collect(Collectors.toSet());
                    for (ItemStack itemStack3 : allIngredients) {
                        int matchCondition;
                        if (playerInventory.extract(itemStack3, Integer.valueOf(matchCondition = JEIIntegratedTerminalsConfig.getItemStackMatchCondition(itemStack3)), true).m_41619_()) continue;
                        found = true;
                        ItemStack extracted = playerInventory.extract(itemStack3, Integer.valueOf(matchCondition), false);
                        Slot slot = container.m_38853_(slotId + slotOffset);
                        slot.m_5852_(extracted);
                        slottedIngredientsFromPlayer.put(slotId, Pair.of((Object)itemStack3, (Object)JEIIntegratedTerminalsConfig.getItemStackMatchCondition(itemStack3)));
                        break;
                    }
                    if (!found) {
                        slottedIngredientsFromStorage.put(slotId, allIngredients.stream().map(itemStack -> Pair.of((Object)itemStack, (Object)JEIIntegratedTerminalsConfig.getItemStackMatchCondition(itemStack))).collect(Collectors.toList()));
                    }
                }
                ++slotId;
            }
            IntegratedTerminalsCompat._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetRecipe(((ContainerTerminalStorageBase)((Object)container)).getSelectedTab(), ((ContainerTerminalStorageBase)((Object)container)).getSelectedChannel(), maxTransfer, slottedIngredientsFromPlayer, slottedIngredientsFromStorage));
            return null;
        }
        return new TransferError();
    }

    public static class TransferError
    implements IRecipeTransferError {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }

        public void showError(PoseStack poseStack, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
        }
    }
}

