/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.ingredient.storage.IngredientComponentStorageWrapperHandlerItemStack;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridAutoRefill;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class SlotCraftingAutoRefill
extends ResultSlot {
    private final CraftingContainer inventoryCrafting;
    private final TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommon;
    private final TerminalStorageTabIngredientComponentServer<ItemStack, Integer> tabServer;
    private final ContainerTerminalStorageBase container;

    public SlotCraftingAutoRefill(Player player, CraftingContainer inventoryCrafting, Container inventoryIn, int slotIndex, int xPosition, int yPosition, TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommon, TerminalStorageTabIngredientComponentServer<ItemStack, Integer> tabServer, ContainerTerminalStorageBase container) {
        super(player, inventoryCrafting, inventoryIn, slotIndex, xPosition, yPosition);
        this.inventoryCrafting = inventoryCrafting;
        this.tabCommon = tabCommon;
        this.tabServer = tabServer;
        this.container = container;
    }

    public void m_142406_(Player thePlayer, ItemStack stack) {
        TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill = this.tabCommon.getAutoRefill();
        if (!thePlayer.f_19853_.f_46443_ && autoRefill != TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType.DISABLED) {
            NonNullList<ItemStack> beforeCraft = SlotCraftingAutoRefill.inventoryToList((Container)this.inventoryCrafting, true);
            super.m_142406_(thePlayer, stack);
            NonNullList<ItemStack> afterCraft = SlotCraftingAutoRefill.inventoryToList((Container)this.inventoryCrafting, false);
            NonNullList<ItemStack> removed = SlotCraftingAutoRefill.getRemoved(beforeCraft, afterCraft);
            IIngredientComponentStorage storage = this.tabServer.getIngredientNetwork().getChannel(this.container.getSelectedChannel());
            IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper player = new IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper(IngredientComponent.ITEMSTACK, (IItemHandler)new PlayerInvWrapper(thePlayer.m_150109_()));
            for (int i = 0; i < removed.size(); ++i) {
                ItemStack extracted;
                ItemStack removedStack = (ItemStack)removed.get(i);
                if (removedStack.m_41619_()) continue;
                switch (autoRefill) {
                    case STORAGE: {
                        extracted = (ItemStack)storage.extract((Object)removedStack, (Object)13, false);
                        break;
                    }
                    case PLAYER: {
                        extracted = (ItemStack)player.extract((Object)removedStack, (Object)13, false);
                        break;
                    }
                    case STORAGE_PLAYER: {
                        extracted = (ItemStack)storage.extract((Object)removedStack, (Object)13, false);
                        if (!extracted.m_41619_()) break;
                        extracted = (ItemStack)player.extract((Object)removedStack, (Object)13, false);
                        break;
                    }
                    case PLAYER_STORAGE: {
                        extracted = (ItemStack)player.extract((Object)removedStack, (Object)13, false);
                        if (!extracted.m_41619_()) break;
                        extracted = (ItemStack)storage.extract((Object)removedStack, (Object)13, false);
                        break;
                    }
                    default: {
                        extracted = ItemStack.f_41583_;
                    }
                }
                thePlayer.f_36096_.m_38946_();
                ItemStack existingStack = this.inventoryCrafting.m_8020_(i);
                existingStack.m_41769_(extracted.m_41613_());
                this.inventoryCrafting.m_6836_(i, existingStack);
                ((ServerPlayer)thePlayer).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(thePlayer.f_36096_.f_38840_, thePlayer.f_36096_.m_182424_(), i + this.f_40219_ + 1, this.inventoryCrafting.m_8020_(i)));
            }
        } else {
            super.m_142406_(thePlayer, stack);
        }
    }

    public static NonNullList<ItemStack> inventoryToList(Container inventory, boolean copy) {
        NonNullList list = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            list.set(i, (Object)(copy ? inventory.m_8020_(i).m_41777_() : inventory.m_8020_(i)));
        }
        return list;
    }

    public static NonNullList<ItemStack> getRemoved(NonNullList<ItemStack> before, NonNullList<ItemStack> after) {
        NonNullList removed = NonNullList.m_122780_((int)before.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < before.size(); ++i) {
            ItemStack beforeStack = (ItemStack)before.get(i);
            ItemStack afterStack = (ItemStack)after.get(i);
            if (beforeStack.m_41613_() <= afterStack.m_41613_()) continue;
            beforeStack.m_41764_(beforeStack.m_41613_() - afterStack.m_41613_());
            removed.set(i, (Object)beforeStack);
        }
        return removed;
    }
}

