/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.ListCodec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;
import shadows.placebo.Placebo;

public class PlaceboCodecs {
    public static <V> Codec<V> mapBacked(String name, Map<ResourceLocation, Codec<? extends V>> reg, Function<V, ResourceLocation> keyExtractor) {
        return new MapBackedCodec<V>(name, reg, keyExtractor);
    }

    public static <V> Codec<Set<V>> setCodec(Codec<V> elementCodec) {
        return new ListCodec(elementCodec).xmap(HashSet::new, ArrayList::new);
    }

    public static class MapBackedCodec<V>
    implements Codec<V> {
        protected final String name;
        protected final Map<ResourceLocation, Codec<? extends V>> registry;
        protected final Function<V, ResourceLocation> keyExtractor;

        public MapBackedCodec(String name, Map<ResourceLocation, Codec<? extends V>> registry, Function<V, ResourceLocation> keyExtractor) {
            this.name = name;
            this.registry = registry;
            this.keyExtractor = keyExtractor;
        }

        public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
            ResourceLocation key = (ResourceLocation)((Pair)ResourceLocation.f_135803_.decode(ops, ops.get(input, "type").getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0))).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0))).getFirst();
            Codec<? extends V> codec = this.registry.get(key);
            if (codec == null) {
                return DataResult.error((String)("Failure when parsing a " + this.name + ". Unrecognized type: " + key));
            }
            return codec.decode(ops, input);
        }

        public <T> DataResult<T> encode(V input, DynamicOps<T> ops, T prefix) {
            ResourceLocation key = this.keyExtractor.apply(input);
            if (key == null) {
                return DataResult.error((String)("Attempted to serialize an unnamed element of type " + this.name + ": " + input));
            }
            Codec<? extends V> codec = this.registry.get(key);
            if (codec == null) {
                return DataResult.error((String)("Attempted to serialize an unregistered element of type " + this.name + " with key: " + key));
            }
            Object encodedKey = ResourceLocation.f_135803_.encodeStart(ops, (Object)key).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
            Object encodedObj = codec.encode(input, ops, prefix).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
            return ops.mergeToMap(encodedObj, ops.createString("type"), encodedKey);
        }
    }
}

