/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.gas;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.starbuncle.gas.StarbyGasBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;

public class GasExtractGoal
extends GoToPosGoal<StarbyGasBehavior> {
    public GasExtractGoal(Starbuncle starbuncle, StarbyGasBehavior behavior) {
        super(starbuncle, (StarbyBehavior)behavior, () -> behavior.getGasStack().isEmpty());
    }

    public void m_8056_() {
        super.m_8056_();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    public BlockPos getDestination() {
        return ((StarbyGasBehavior)this.behavior).getTankToExtract();
    }

    public boolean onDestinationReached() {
        IGasHandler gasHandlerExtract = ((StarbyGasBehavior)this.behavior).getHandlerFromCap(this.targetPos);
        int tankIndexE = 0;
        if (gasHandlerExtract != null) {
            GasStack toExtract = (GasStack)gasHandlerExtract.getChemicalInTank(tankIndexE);
            BlockPos pos = ((StarbyGasBehavior)this.behavior).getTankForStorage(new GasStack(toExtract, (long)((StarbyGasBehavior)this.behavior).getRatio()));
            if (pos == null) {
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoRoom", "No Room for " + toExtract.getTypeRegistryName() + " from " + this.targetPos.toString()));
                return true;
            }
            IGasHandler gasHandlerStore = ((StarbyGasBehavior)this.behavior).getHandlerFromCap(pos);
            if (gasHandlerStore != null) {
                long maxRoom = -1L;
                for (int s = 0; s < gasHandlerStore.getTanks() && !(((GasStack)gasHandlerStore.getChemicalInTank(s)).isEmpty() ? (maxRoom = gasHandlerStore.getTankCapacity(s)) > 0L : ((GasStack)gasHandlerStore.getChemicalInTank(s)).isTypeEqual((ChemicalStack)toExtract) && (maxRoom = gasHandlerStore.getTankCapacity(s) - ((GasStack)gasHandlerStore.getChemicalInTank(s)).getAmount()) > 0L); ++s) {
                }
                if (maxRoom <= (long)((Integer)Configs.STARBALLOON_THRESHOLD.get()).intValue()) {
                    return true;
                }
                int takeAmount = (int)Math.min(toExtract.getAmount(), Math.min(maxRoom, (long)((StarbyGasBehavior)this.behavior).getRatio()));
                this.starbuncle.f_19853_.m_5594_(null, this.targetPos, SoundEvents.f_144098_, SoundSource.NEUTRAL, 0.5f, 1.3f);
                GasStack extracted = new GasStack(toExtract, (long)takeAmount);
                ((StarbyGasBehavior)this.behavior).setGasStack((GasStack)gasHandlerExtract.extractChemical((ChemicalStack)extracted, Action.EXECUTE));
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("SetHeld", "Taking " + takeAmount + "x " + extracted.getTypeRegistryName() + " from " + this.targetPos.toString()));
            } else {
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoHandler", "No gas handler at " + this.targetPos.toString()));
            }
        } else {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoHandler", "No gas handler at " + this.targetPos.toString()));
        }
        return true;
    }
}

