/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.fluid;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.common.block.LiquidJarTile;
import alexthw.starbunclemania.common.item.DirectionScroll;
import alexthw.starbunclemania.common.item.FluidScroll;
import alexthw.starbunclemania.registry.ModRegistry;
import alexthw.starbunclemania.starbuncle.StarHelper;
import alexthw.starbunclemania.starbuncle.fluid.FluidExtractGoal;
import alexthw.starbunclemania.starbuncle.fluid.FluidStoreGoal;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarbyFluidBehavior
extends StarbyListBehavior {
    public static final ResourceLocation TRANSPORT_ID = new ResourceLocation("starbunclemania", "starby_fluid_transport");
    @NotNull
    private FluidStack fluidStack = FluidStack.EMPTY;
    public int side = -1;
    public ItemStack fluidScroll;

    public StarbyFluidBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.m_128441_("Direction")) {
            this.side = tag.m_128451_("Direction");
        }
        if (tag.m_128441_("FluidName")) {
            this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
        }
        if (tag.m_128441_("fluidScroll")) {
            this.fluidScroll = ItemStack.m_41712_((CompoundTag)tag.m_128469_("fluidScroll"));
        }
        this.goals.add(new WrappedGoal(3, (Goal)new FluidStoreGoal(entity, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new FluidExtractGoal(entity, this)));
    }

    public boolean canGoToBed() {
        return this.getTankToExtract() == null && (this.getFluidStack().isEmpty() || this.getTankForStorage() == null);
    }

    @NotNull
    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public void setFluidStack(FluidStack fluid) {
        this.fluidStack = fluid;
        this.syncTag();
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockEntity be;
        super.onFinishedConnectionFirst(storedPos, storedEntity, playerEntity);
        if (storedPos != null && (be = this.level.m_7702_(storedPos)) != null && be.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent()) {
            this.addToPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.fluid_to"));
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockEntity be;
        super.onFinishedConnectionLast(storedPos, storedEntity, playerEntity);
        if (storedPos != null && (be = this.level.m_7702_(storedPos)) != null && be.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent()) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.fluid_from"));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof DirectionScroll && stack.m_41782_()) {
            this.side = stack.m_41784_().m_128451_("side");
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.filter_set"));
            this.syncTag();
        } else if (stack.m_41720_() instanceof FluidScroll && stack.m_41782_()) {
            this.fluidScroll = stack;
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.filter_set"));
            this.syncTag();
        }
        return super.mobInteract(player, hand);
    }

    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.storing_fluid", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.taking_fluid", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (!this.fluidStack.isEmpty()) {
            LiquidJarTile.displayFluidTooltip(tooltip, this.getFluidStack());
        }
        if (this.side >= 0) {
            tooltip.add((Component)Component.m_237113_((String)("Preferred Side : " + Direction.values()[this.side].name())));
        }
        if (this.fluidScroll != null && !this.fluidScroll.m_41619_()) {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.filtering_with", (Object[])new Object[]{this.fluidScroll.m_41786_().getString()}));
        }
    }

    public int getRatio() {
        return (Integer)Configs.STARBUCKET_RATIO.get();
    }

    protected ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }

    public BlockPos getTankForStorage(FluidStack fluidInTank) {
        if (!fluidInTank.isEmpty()) {
            for (BlockPos pos : this.TO_LIST) {
                if (!this.canStore(pos, fluidInTank)) continue;
                return pos;
            }
        }
        return null;
    }

    public BlockPos getTankForStorage() {
        return this.getTankForStorage(this.getFluidStack());
    }

    public BlockPos getTankToExtract() {
        for (BlockPos pos : this.FROM_LIST) {
            if (!this.canExtract(pos)) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    public static IFluidHandler getHandlerFromCap(BlockPos pos, Level level, int sideOrdinal) {
        BlockEntity be = level.m_7702_(pos);
        Direction side = (sideOrdinal = StarHelper.checkItemFramesForSide(pos, level, sideOrdinal, be)) < 0 ? Direction.UP : Direction.values()[sideOrdinal];
        return be != null && be.getCapability(ForgeCapabilities.FLUID_HANDLER, side).isPresent() && be.getCapability(ForgeCapabilities.FLUID_HANDLER, side).resolve().isPresent() ? (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, side).resolve().get() : null;
    }

    public IFluidHandler getHandlerFromCap(BlockPos pos) {
        return StarbyFluidBehavior.getHandlerFromCap(pos, this.level, this.side);
    }

    public boolean canStore(BlockPos pos, @NotNull FluidStack fluidStack) {
        IFluidHandler fluid = this.getHandlerFromCap(pos);
        if (fluid != null) {
            for (int i = 0; i < fluid.getTanks(); ++i) {
                if (!fluid.isFluidValid(i, fluidStack) || fluid.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) < (Integer)Configs.STARBUCKET_THRESHOLD.get()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canExtract(BlockPos pos) {
        IFluidHandler fluid = this.getHandlerFromCap(pos);
        if (fluid != null) {
            for (int i = 0; i < fluid.getTanks(); ++i) {
                if (fluid.getFluidInTank(i).isEmpty()) continue;
                if (FluidScroll.checkForFilters(pos, this.fluidScroll, fluid.getFluidInTank(i), this.starbuncle.f_19853_)) {
                    return false;
                }
                if (this.getTankForStorage(fluid.getFluidInTank(i)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (!this.getFluidStack().isEmpty()) {
            this.getFluidStack().writeToNBT(tag);
        }
        if (this.fluidScroll != null) {
            tag.m_128365_("itemScroll", (Tag)this.fluidScroll.serializeNBT());
        }
        if (this.side >= 0) {
            tag.m_128405_("Direction", this.side);
        }
        return super.toTag(tag);
    }

    public ItemStack getStackForRender() {
        ItemStack instance = ((Block)ModRegistry.FLUID_JAR.get()).m_5456_().m_7968_();
        CompoundTag tag = instance.m_41784_();
        if (!this.getFluidStack().isEmpty()) {
            tag.m_128365_("BlockEntityTag", (Tag)this.getFluidStack().writeToNBT(new CompoundTag()));
        }
        tag.m_128379_("Starbuncle", true);
        return instance;
    }
}

