/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.fluid;

import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidStoreGoal
extends GoToPosGoal<StarbyFluidBehavior> {
    public FluidStoreGoal(Starbuncle starbuncle, StarbyFluidBehavior behavior) {
        super(starbuncle, (StarbyBehavior)behavior, () -> !behavior.getFluidStack().isEmpty());
    }

    public void m_8056_() {
        super.m_8056_();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.STORING_ITEM;
    }

    @Nullable
    public BlockPos getDestination() {
        return ((StarbyFluidBehavior)this.behavior).getTankForStorage();
    }

    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyFluidBehavior)this.behavior).canStore(pos, ((StarbyFluidBehavior)this.behavior).getFluidStack());
    }

    public boolean onDestinationReached() {
        IFluidHandler fluidHandler = ((StarbyFluidBehavior)this.behavior).getHandlerFromCap(this.targetPos);
        int tankIndex = 0;
        if (fluidHandler != null) {
            int room = fluidHandler.getTankCapacity(tankIndex) - fluidHandler.getFluidInTank(tankIndex).getAmount();
            if (room <= 0) {
                return true;
            }
            int diff = Math.min(room, ((StarbyFluidBehavior)this.behavior).getFluidStack().getAmount());
            FluidStack fill = new FluidStack(((StarbyFluidBehavior)this.behavior).getFluidStack(), diff);
            fluidHandler.fill(fill, IFluidHandler.FluidAction.EXECUTE);
            ((StarbyFluidBehavior)this.behavior).getFluidStack().shrink(diff);
            ((StarbyFluidBehavior)this.behavior).syncTag();
            this.starbuncle.f_19853_.m_5594_(null, this.targetPos, SoundEvents.f_11778_, SoundSource.NEUTRAL, 0.5f, 1.3f);
        }
        return true;
    }
}

