/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.fluid;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidExtractGoal
extends GoToPosGoal<StarbyFluidBehavior> {
    public FluidExtractGoal(Starbuncle starbuncle, StarbyFluidBehavior behavior) {
        super(starbuncle, (StarbyBehavior)behavior, () -> behavior.getFluidStack().isEmpty() && !behavior.FROM_LIST.isEmpty());
    }

    public void m_8056_() {
        super.m_8056_();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    @Nullable
    public BlockPos getDestination() {
        return ((StarbyFluidBehavior)this.behavior).getTankToExtract();
    }

    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyFluidBehavior)this.behavior).canExtract(pos);
    }

    public boolean onDestinationReached() {
        IFluidHandler fluidHandlerExtract = ((StarbyFluidBehavior)this.behavior).getHandlerFromCap(this.targetPos);
        int tankIndexE = 0;
        if (fluidHandlerExtract != null) {
            FluidStack toExtract = fluidHandlerExtract.getFluidInTank(tankIndexE);
            BlockPos pos = ((StarbyFluidBehavior)this.behavior).getTankForStorage(toExtract);
            if (pos == null) {
                return true;
            }
            IFluidHandler fluidHandlerStore = ((StarbyFluidBehavior)this.behavior).getHandlerFromCap(pos);
            if (fluidHandlerStore != null) {
                int maxRoom = -1;
                for (int s = 0; s < fluidHandlerStore.getTanks() && !(fluidHandlerStore.getFluidInTank(s).isEmpty() ? (maxRoom = fluidHandlerStore.getTankCapacity(s)) > 0 : fluidHandlerStore.getFluidInTank(s).isFluidEqual(toExtract) && (maxRoom = fluidHandlerStore.getTankCapacity(s) - fluidHandlerStore.getFluidInTank(s).getAmount()) > 0); ++s) {
                }
                if (maxRoom <= (Integer)Configs.STARBUCKET_THRESHOLD.get()) {
                    return true;
                }
                int takeAmount = Math.min(toExtract.getAmount(), Math.min(maxRoom, ((StarbyFluidBehavior)this.behavior).getRatio()));
                this.starbuncle.f_19853_.m_5594_(null, this.targetPos, SoundEvents.f_11781_, SoundSource.NEUTRAL, 0.5f, 1.3f);
                FluidStack extracted = new FluidStack(toExtract, takeAmount);
                ((StarbyFluidBehavior)this.behavior).setFluidStack(extracted);
                fluidHandlerExtract.drain(extracted, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return true;
    }
}

