/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.glyph;

import alexthw.starbunclemania.StarbuncleMania;
import alexthw.starbunclemania.glyph.PlaceFluidEffect;
import alexthw.starbunclemania.glyph.WrappedExtractedItemHandler;
import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class PickupFluidEffect
extends AbstractEffect {
    public static final PickupFluidEffect INSTANCE = new PickupFluidEffect();

    public PickupFluidEffect() {
        super(StarbuncleMania.prefix("glyph_pickup_fluid"), "Pickup Fluid");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Cow cow;
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof Cow && !(cow = (Cow)entity).m_6162_()) {
            this.pickupCow(this.getTanks(world, shooter, spellContext), world, shooter);
        } else {
            this.onResolveBlock(new BlockHitResult(rayTraceResult.m_82450_(), Direction.UP, rayTraceResult.m_82443_().m_20097_(), true), world, shooter, spellStats, spellContext, resolver);
        }
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos adjustedPos = rayTraceResult.m_82425_();
        if (!world.m_6425_(adjustedPos).m_76170_() || world.m_8055_(adjustedPos).m_60734_() instanceof AbstractCauldronBlock) {
            adjustedPos = adjustedPos.m_121945_(rayTraceResult.m_82434_());
        }
        List posList = SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)adjustedPos, (BlockHitResult)rayTraceResult, (SpellStats)spellStats);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world));
        List<IFluidHandler> tanks = this.getTanks(world, shooter, spellContext);
        if (tanks.isEmpty()) {
            return;
        }
        for (BlockPos pos1 : posList) {
            MobJarTile jar;
            BlockState state = world.m_8055_(pos1);
            if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos1), world.m_8055_(pos1), (Entity)fakePlayer))) continue;
            Block block = state.m_60734_();
            if (block instanceof BucketPickup) {
                BucketPickup bp = (BucketPickup)block;
                this.pickup(pos1, world, shooter, tanks, bp, resolver, spellContext, new BlockHitResult(new Vec3((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_()), rayTraceResult.m_82434_(), pos1, false));
                continue;
            }
            if (!(state.m_155947_() || state.m_60734_() != Blocks.f_152476_ && state.m_60734_() != Blocks.f_152477_)) {
                this.pickupCauldron(pos1, world, shooter, tanks, resolver, spellContext, new BlockHitResult(new Vec3((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_()), rayTraceResult.m_82434_(), pos1, false));
                continue;
            }
            block = world.m_7702_(pos1);
            if (!(block instanceof MobJarTile) || !((jar = (MobJarTile)block).getEntity() instanceof Cow)) continue;
            this.pickupCow(tanks, world, shooter);
        }
        for (IFluidHandler tank : tanks) {
            if (!(tank instanceof WrappedExtractedItemHandler)) continue;
            WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
            wrap.extractedStack.returnOrDrop(world, shooter.m_20097_());
        }
    }

    private void pickupCauldron(BlockPos pPos, Level world, LivingEntity shooter, List<IFluidHandler> tanks, SpellResolver resolver, SpellContext spellContext, BlockHitResult resolveResult) {
        FlowingFluid fluid = world.m_8055_(pPos).m_60734_() == Blocks.f_152476_ ? Fluids.f_76193_ : Fluids.f_76195_;
        for (IFluidHandler tank : tanks) {
            FluidStack tester;
            if (tank.fill(tester = new FluidStack((Fluid)fluid, 1000), IFluidHandler.FluidAction.SIMULATE) != 1000) continue;
            world.m_46597_(pPos, Blocks.f_50256_.m_49966_());
            tank.fill(tester, IFluidHandler.FluidAction.EXECUTE);
            if (tank instanceof WrappedExtractedItemHandler) {
                WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
                wrap.updateContainer();
            }
            ShapersFocus.tryPropagateBlockSpell((BlockHitResult)resolveResult, (Level)world, (LivingEntity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
            break;
        }
    }

    private void pickupCow(List<IFluidHandler> tanks, Level world, LivingEntity shooter) {
        for (IFluidHandler tank : tanks) {
            FluidStack tester;
            if (tank.fill(tester = new FluidStack((Fluid)ForgeMod.MILK.get(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                tank.fill(tester, IFluidHandler.FluidAction.EXECUTE);
                break;
            }
            if (!(tank instanceof WrappedExtractedItemHandler)) continue;
            WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
            wrap.extractedStack.returnOrDrop(world, shooter.m_20097_());
        }
    }

    private void pickup(BlockPos pPos, Level world, LivingEntity shooter, List<IFluidHandler> tanks, BucketPickup bp, SpellResolver resolver, SpellContext spellContext, BlockHitResult resolveResult) {
        FluidState fluidState = world.m_6425_(pPos);
        for (IFluidHandler tank : tanks) {
            FluidStack tester;
            if (tank.fill(tester = new FluidStack(fluidState.m_76152_(), 1000), IFluidHandler.FluidAction.SIMULATE) != 1000 || !fluidState.m_76170_()) continue;
            bp.m_142598_((LevelAccessor)world, pPos, world.m_8055_(pPos));
            tank.fill(tester, IFluidHandler.FluidAction.EXECUTE);
            if (tank instanceof WrappedExtractedItemHandler) {
                WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
                wrap.updateContainer();
            }
            ShapersFocus.tryPropagateBlockSpell((BlockHitResult)resolveResult, (Level)world, (LivingEntity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
            break;
        }
    }

    public List<IFluidHandler> getTanks(Level world, @NotNull LivingEntity shooter, SpellContext spellContext) {
        ArrayList<IFluidHandler> handlers = new ArrayList<IFluidHandler>();
        if (shooter instanceof FakePlayer) {
            for (Direction side : Direction.values()) {
                IFluidHandler handler;
                BlockPos pos = shooter.m_20097_().m_7494_().m_121945_(side);
                BlockEntity be = world.m_7702_(pos);
                if (be == null || !be.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent() || (handler = StarbyFluidBehavior.getHandlerFromCap(pos, world, side.ordinal())) == null || !handler.getFluidInTank(0).isEmpty() && handler.getFluidInTank(0).getAmount() > handler.getTankCapacity(0) - 1000) continue;
                handlers.add(handler);
            }
        }
        PlaceFluidEffect.getTankItems(shooter, spellContext, handlers);
        return handlers;
    }

    public int getDefaultManaCost() {
        return 20;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentPierce.INSTANCE});
    }
}

