/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.block;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.potion.PotionData;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidSourcelinkTile
extends SourcelinkTile {
    public static int capacity = 6000;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    protected final FluidTank tank = new FluidTank(capacity){

        protected void onContentsChanged() {
            FluidSourcelinkTile.this.updateBlock();
            FluidSourcelinkTile.this.m_6596_();
        }

        public boolean isFluidValid(FluidStack stack) {
            return FluidSourcelinkTile.this.getSourceFromFluid(stack) > 0.0;
        }
    };

    public FluidSourcelinkTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FLUID_SOURCELINK_TILE.get(), pos, state);
    }

    boolean tester(IFluidHandler tank) {
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluid = tank.getFluidInTank(i);
            if (!(this.getSourceFromFluid(fluid) > 0.0)) continue;
            return this.tank.isEmpty() || this.tank.getFluid().isFluidEqual(fluid);
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ != null) {
            double sourceFromFluid;
            BlockEntity be;
            if (this.tank.getSpace() > 0 && this.f_58857_.m_46467_() % 20L == 0L && (be = this.f_58857_.m_7702_(this.m_58899_().m_7495_())) != null && be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).isPresent()) {
                IFluidHandler handler;
                IFluidHandler iFluidHandler = handler = be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN).resolve().isPresent() ? (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN).resolve().get() : null;
                if (handler != null && this.tester(handler)) {
                    this.tank.fill(handler.drain(Math.min(1000, this.tank.getSpace()), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                }
            }
            if (!this.f_58857_.m_5776_() && this.f_58857_.m_46467_() % 20L == 0L && this.canAcceptSource() && (sourceFromFluid = this.getSourceFromFluid(this.getFluid())) > 0.0 && this.canAcceptSource((int)sourceFromFluid)) {
                int drain = this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE).getAmount();
                this.addSource((int)((double)drain * sourceFromFluid));
            }
        }
    }

    double getSourceFromFluid(FluidStack tank) {
        if (!tank.isEmpty()) {
            ResourceLocation fluid = ForgeRegistries.FLUIDS.getKey((Object)tank.getFluid());
            if (fluid != null && Configs.FLUID_TO_SOURCE_MAP.containsKey(fluid)) {
                return Configs.FLUID_TO_SOURCE_MAP.get(fluid);
            }
            if (tank.hasTag() && tank.getFluid().m_205067_(ModRegistry.POTION)) {
                PotionData potion = PotionData.fromTag((CompoundTag)tank.getTag());
                double mana = 75.0;
                HashSet<MobEffect> effectTypes = new HashSet<MobEffect>();
                for (MobEffectInstance e : potion.fullEffects()) {
                    mana += (double)e.m_19557_() / 50.0;
                    mana += (double)(e.m_19564_() * 250);
                    mana += 150.0;
                    effectTypes.add(e.m_19544_());
                }
                if (effectTypes.size() > 1) {
                    mana *= 1.5 * (double)(effectTypes.size() - 1);
                }
                return mana / 250.0;
            }
        }
        return 0.0;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.FLUID_HANDLER ? this.holder.cast() : super.getCapability(capability, facing);
    }

    public boolean interact(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank);
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getMaxSource() {
        return 5000;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 8);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.tank.isEmpty()) {
            this.tank.writeToNBT(tag);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.tank.readFromNBT(pTag);
    }
}

