/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania;

import alexthw.starbunclemania.glyph.PickupFluidEffect;
import alexthw.starbunclemania.glyph.PlaceFluidEffect;
import alexthw.starbunclemania.registry.ModRegistry;
import alexthw.starbunclemania.starbuncle.energy.StarbyEnergyBehavior;
import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import alexthw.starbunclemania.starbuncle.gas.StarbyGasBehavior;
import alexthw.starbunclemania.starbuncle.heal.StarbyHealerBehavior;
import alexthw.starbunclemania.starbuncle.item.AdvancedItemTransportBehavior;
import alexthw.starbunclemania.starbuncle.sword.StarbyFighterBehavior;
import alexthw.starbunclemania.starbuncle.trash.StarbyVoidBehavior;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.entity.BehaviorRegistry;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.fml.ModList;

public class ArsNouveauRegistry {
    public static final List<AbstractSpellPart> registeredSpells = new ArrayList<AbstractSpellPart>();

    public static void register() {
        ArsNouveauRegistry.register((AbstractSpellPart)PlaceFluidEffect.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)PickupFluidEffect.INSTANCE);
        BehaviorRegistry.register((ResourceLocation)AdvancedItemTransportBehavior.TRANSPORT_ID, (entity, tag) -> new AdvancedItemTransportBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyEnergyBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyEnergyBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyFluidBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyFluidBehavior((Starbuncle)entity, tag));
        if (ModList.get().isLoaded("mekanism")) {
            BehaviorRegistry.register((ResourceLocation)StarbyGasBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyGasBehavior((Starbuncle)entity, tag));
        }
        BehaviorRegistry.register((ResourceLocation)StarbyVoidBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyVoidBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyFighterBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyFighterBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register((ResourceLocation)StarbyHealerBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyHealerBehavior((Starbuncle)entity, tag));
    }

    public static void postInit() {
        LightManager.register((EntityType)((EntityType)ModRegistry.STARBY_MOUNT.get()), p -> {
            if (p.f_19853_.m_45517_(LightLayer.BLOCK, p.m_20183_()) < 6) {
                return 10;
            }
            return 0;
        });
    }

    public static void register(AbstractSpellPart spellPart) {
        ArsNouveauAPI.getInstance().registerSpell(spellPart);
        registeredSpells.add(spellPart);
    }
}

