/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.core.item.ITrackedItem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class ItemTracker {
    protected static Map<Player, TrackedItemData> MAIN_HAND_DATA = new Object2ObjectOpenHashMap();
    protected static Map<Player, TrackedItemData> OFF_HAND_DATA = new Object2ObjectOpenHashMap();

    public static Map<Player, TrackedItemData> getMap(InteractionHand hand) {
        return hand == InteractionHand.OFF_HAND ? OFF_HAND_DATA : MAIN_HAND_DATA;
    }

    public static TrackedItemData getData(Player player, InteractionHand hand) {
        return ItemTracker.getMap(hand).get(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase != TickEvent.Phase.START || player.f_19853_.f_46443_) {
            return;
        }
        ItemTracker.updateData(player, InteractionHand.MAIN_HAND);
        ItemTracker.updateData(player, InteractionHand.OFF_HAND);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onUse(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCanceled() && event.getCancellationResult() == InteractionResult.SUCCESS && !event.getLevel().f_46443_) {
            ItemTracker.itemUsed(event.getEntity(), event.getHand(), event.getItemStack());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onUseOn(PlayerInteractEvent.RightClickBlock event) {
        if (!event.isCanceled() && event.getCancellationResult() == InteractionResult.SUCCESS && !event.getLevel().f_46443_) {
            ItemTracker.itemUsed(event.getEntity(), event.getHand(), event.getItemStack());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onUseEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled() && event.getCancellationResult() == InteractionResult.SUCCESS && !event.getLevel().f_46443_) {
            ItemTracker.itemUsed(event.getEntity(), event.getHand(), event.getItemStack());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onStartUsing(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity;
        if (!event.isCanceled() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_) {
                ItemTracker.itemUsed(player, player.m_7655_(), event.getItem());
                ItemTracker.itemUsing(player, player.m_7655_(), event.getItem(), event.getDuration());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTickUsing(LivingEntityUseItemEvent.Tick event) {
        LivingEntity livingEntity;
        if (!event.isCanceled() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_) {
                ItemTracker.itemUsing(player, player.m_7655_(), event.getItem(), event.getDuration());
            }
        }
    }

    @SubscribeEvent
    public static void onEndUsing(LivingEntityUseItemEvent.Stop event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_) {
                ItemTracker.itemUsing(player, player.m_7655_(), event.getItem(), -1);
            }
        }
    }

    @SubscribeEvent
    public static void onFinishUsing(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_) {
                ItemTracker.itemUsing(player, player.m_7655_(), event.getItem(), -1);
            }
        }
    }

    protected static void updateData(Player player, InteractionHand hand) {
        Map<Player, TrackedItemData> map = ItemTracker.getMap(hand);
        TrackedItemData data = map.get(player);
        ItemStack current = player.m_21120_(hand);
        if (data == null) {
            if (current.m_41720_() instanceof ITrackedItem) {
                ItemTracker.swapTo(player, hand, current);
            } else {
                map.remove(player);
            }
        } else if (!data.matches(current)) {
            Item item = data.stack.m_41720_();
            if (item instanceof ITrackedItem) {
                ITrackedItem tracked = (ITrackedItem)item;
                tracked.onSwapFrom(player, hand, data.stack, data.duration);
            }
            if (current.m_41720_() instanceof ITrackedItem) {
                ItemTracker.swapTo(player, hand, current);
            } else {
                map.remove(player);
            }
        }
    }

    protected static void swapTo(Player player, InteractionHand hand, ItemStack stack) {
        ItemTracker.getMap(hand).put(player, new TrackedItemData(stack));
        Item item = stack.m_41720_();
        if (item instanceof ITrackedItem) {
            ITrackedItem tracked = (ITrackedItem)item;
            tracked.onSwapTo(player, hand, stack);
        }
    }

    protected static void itemUsed(Player player, InteractionHand hand, ItemStack stack) {
        if (stack.m_41720_() instanceof ITrackedItem) {
            Map<Player, TrackedItemData> map = ItemTracker.getMap(hand);
            TrackedItemData data = map.get(player);
            if (data == null || !data.matches(stack)) {
                data = new TrackedItemData(stack);
                map.put(player, data);
            }
            data.lastUse = player.f_19853_.m_46467_();
        }
    }

    protected static void itemUsing(Player player, InteractionHand hand, ItemStack stack, int duration) {
        if (stack.m_41720_() instanceof ITrackedItem) {
            Map<Player, TrackedItemData> map = ItemTracker.getMap(hand);
            TrackedItemData data = map.get(player);
            if (data == null || !data.matches(stack)) {
                data = new TrackedItemData(stack);
                map.put(player, data);
            }
            data.duration = duration < 0 ? duration : stack.m_41779_() - duration;
        }
    }

    public static class TrackedItemData {
        public ItemStack stack;
        public long lastUse = -1L;
        public int duration = -1;

        public TrackedItemData(ItemStack stack) {
            this.stack = stack;
        }

        public boolean matches(ItemStack to) {
            Item item = this.stack.m_41720_();
            if (item instanceof ITrackedItem) {
                ITrackedItem tracked = (ITrackedItem)item;
                return tracked.matches(this.stack, to);
            }
            return ItemStack.m_41728_((ItemStack)this.stack, (ItemStack)to);
        }
    }
}

