/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.ElementSlot;
import cofh.core.util.helpers.GuiHelper;
import cofh.lib.inventory.container.slot.SlotCoFH;
import cofh.lib.util.Constants;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class ElementAugmentSlots
extends ElementBase {
    private final IntSupplier numSlots;
    private final List<SlotCoFH> augmentSlots;
    private final List<ElementSlot> slots = new ArrayList<ElementSlot>(9);

    public ElementAugmentSlots(IGuiAccess gui, int posX, int posY, @Nonnull IntSupplier numSlots, @Nonnull List<SlotCoFH> augmentSlots) {
        this(gui, posX, posY, numSlots, augmentSlots, null, Constants.TRUE);
    }

    public ElementAugmentSlots(IGuiAccess gui, int posX, int posY, @Nonnull IntSupplier numSlots, @Nonnull List<SlotCoFH> augmentSlots, String texture, Supplier<Boolean> drawUnderlay) {
        super(gui, posX, posY);
        int slotIndex;
        int i;
        this.numSlots = numSlots;
        this.augmentSlots = augmentSlots;
        for (i = 0; i < augmentSlots.size(); ++i) {
            slotIndex = i;
            this.augmentSlots.get(i).setEnabled(() -> slotIndex < this.numSlots.getAsInt() && this.visible());
        }
        for (i = 0; i < 9; ++i) {
            slotIndex = i;
            ElementSlot slot = GuiHelper.createSlot(gui, 18 * i, 0);
            slot.setVisible(() -> slotIndex < this.numSlots.getAsInt());
            if (texture != null && drawUnderlay != null) {
                slot.setUnderlayTexture(texture, drawUnderlay);
            }
            this.slots.add(slot);
        }
    }

    @Override
    public void drawBackground(PoseStack matrixStack, int mouseX, int mouseY) {
        for (ElementBase elementBase : this.slots) {
            if (!elementBase.visible()) continue;
            elementBase.drawBackground(matrixStack, mouseX, mouseY);
        }
    }

    @Override
    public void drawForeground(PoseStack matrixStack, int mouseX, int mouseY) {
        for (ElementBase elementBase : this.slots) {
            if (!elementBase.visible()) continue;
            elementBase.drawForeground(matrixStack, mouseX, mouseY);
        }
    }

    @Override
    public void update(int mouseX, int mouseY) {
        int i;
        int activeSlots = MathHelper.clamp(this.numSlots.getAsInt(), 0, 9);
        int absX = this.posX() + this.offsetX();
        int absY = this.posY() + this.offsetY();
        switch (activeSlots) {
            case 1: {
                this.augmentSlots.get((int)0).f_40220_ = absX + 18;
                this.augmentSlots.get((int)0).f_40221_ = absY + 18;
                break;
            }
            case 2: {
                for (i = 0; i < activeSlots; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 9 + 18 * (i % 2);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 18;
                }
                break;
            }
            case 3: {
                for (i = 0; i < 2; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 9 + 18 * (i % 2);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 9;
                }
                this.augmentSlots.get((int)2).f_40220_ = absX + 18;
                this.augmentSlots.get((int)2).f_40221_ = absY + 9 + 18;
                break;
            }
            case 4: {
                for (i = 0; i < activeSlots; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 9 + 18 * (i % 2);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 9 + 18 * (i / 2);
                }
                break;
            }
            case 5: {
                for (i = 0; i < activeSlots; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 18 * (i % 3) + 9 * (i / 3);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 9 + 18 * (i / 3);
                }
                break;
            }
            case 6: {
                for (i = 0; i < activeSlots; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 18 * (i % 3);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 9 + 18 * (i / 3);
                }
                break;
            }
            case 7: {
                for (i = 0; i < 2; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 9 + 18 * i;
                    this.augmentSlots.get((int)i).f_40221_ = absY;
                }
                for (i = 2; i < 5; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 18 * (i - 2);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 18;
                }
                for (i = 5; i < activeSlots; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 9 + 18 * (i - 5);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 36;
                }
                break;
            }
            case 8: {
                for (i = 0; i < 3; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 18 * i;
                    this.augmentSlots.get((int)i).f_40221_ = absY;
                }
                for (i = 3; i < 5; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 9 + 18 * (i - 3);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 18;
                }
                for (i = 5; i < activeSlots; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 18 * (i - 5);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 36;
                }
                break;
            }
            case 9: {
                for (i = 0; i < activeSlots; ++i) {
                    this.augmentSlots.get((int)i).f_40220_ = absX + 18 * (i % 3);
                    this.augmentSlots.get((int)i).f_40221_ = absY + 18 * (i / 3);
                }
                break;
            }
        }
        for (i = 0; i < activeSlots; ++i) {
            this.slots.get(i).setPosition(this.augmentSlots.get((int)i).f_40220_ - 1 - this.offsetX(), this.augmentSlots.get((int)i).f_40221_ - 1 - this.offsetY());
        }
    }
}

