/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.blocks;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.xnet.channels.IConnectable;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.cables.blocks.NetCableBlock;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.blocks.FacadeBlockItem;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.various.blocks.RedstoneProxyBlock;
import mcjty.xnet.modules.wireless.blocks.TileEntityWirelessRouter;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class ConnectorBlock
extends GenericCableBlock
implements ITooltipSettings,
EntityBlock {
    public static final ManualEntry MANUAL = ManualHelper.create((String)"xnet:simple/connector");
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(stack -> this.isAdvancedConnector()), TooltipBuilder.parameter((String)"info", stack -> Integer.toString(this.isAdvancedConnector() ? (Integer)Config.maxRfAdvancedConnector.get() : (Integer)Config.maxRfConnector.get()))});

    public ConnectorBlock(GenericCableBlock.CableBlockType type) {
        super(Material.f_76279_, type);
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ConnectorTileEntity(pPos, pState);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        BlockEntity te;
        if (!world.f_46443_ && (te = world.m_7702_(pos)) instanceof GenericTileEntity) {
            final GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @Nonnull
                public Component m_5446_() {
                    return ComponentFactory.literal((String)"Connector");
                }

                @Nonnull
                public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
                    return new GenericContainer(CableModule.CONTAINER_CONNECTOR, id, (Supplier)ContainerFactory.EMPTY, genericTileEntity, player);
                }
            }, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6240_(@Nonnull Level worldIn, @Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, @Nonnull ItemStack stack) {
        ConnectorTileEntity connectorTileEntity;
        if (te instanceof ConnectorTileEntity && (connectorTileEntity = (ConnectorTileEntity)te).getMimicBlock() != null) {
            ItemStack item = new ItemStack((ItemLike)FacadeModule.FACADE.get());
            FacadeBlockItem.setMimicBlock(item, connectorTileEntity.getMimicBlock());
            connectorTileEntity.setMimicBlock(null);
            ConnectorBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)item);
            return;
        }
        super.m_6240_(worldIn, player, pos, state, te, stack);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)te;
            if (connectorTileEntity.getMimicBlock() == null) {
                this.m_5707_(world, pos, state, player);
                return world.m_7731_(pos, Blocks.f_50016_.m_49966_(), world.f_46443_ ? 11 : 3);
            }
            this.m_5707_(world, pos, state, player);
            if (player.m_150110_().f_35937_) {
                connectorTileEntity.setMimicBlock(null);
            }
        } else {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        return true;
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        this.checkRedstone(world, pos);
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
    }

    public void onNeighborChange(BlockState state, LevelReader blockAccess, BlockPos pos, BlockPos neighbor) {
        BlockEntity te;
        if (!blockAccess.m_5776_() && (te = blockAccess.m_7702_(pos)) instanceof ConnectorTileEntity) {
            ConnectorTileEntity connector = (ConnectorTileEntity)te;
            connector.possiblyMarkNetworkDirty(neighbor);
        }
        super.onNeighborChange(state, blockAccess, pos, neighbor);
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    private void checkRedstone(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connector = (ConnectorTileEntity)te;
            int powered = world.m_46755_(pos);
            connector.setPowerInput(powered);
        }
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6378_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    public int m_6376_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    protected int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (state.m_60734_() instanceof ConnectorBlock && te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connector = (ConnectorTileEntity)te;
            return connector.getPowerOut(side.m_122424_());
        }
        return 0;
    }

    @Override
    protected ConnectorType getConnectorType(@Nonnull CableColor color, BlockGetter world, BlockPos connectorPos, Direction facing) {
        BlockPos pos = connectorPos.m_121945_(facing);
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if ((block instanceof NetCableBlock || block instanceof ConnectorBlock) && state.m_61143_((Property)COLOR) == color) {
            return ConnectorType.CABLE;
        }
        if (ConnectorBlock.isConnectable(world, connectorPos, facing) && color != CableColor.ROUTING) {
            return ConnectorType.BLOCK;
        }
        if (ConnectorBlock.isConnectableRouting(world, pos) && color == CableColor.ROUTING) {
            return ConnectorType.BLOCK;
        }
        return ConnectorType.NONE;
    }

    public static boolean isConnectableRouting(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            return false;
        }
        return te instanceof TileEntityRouter || te instanceof TileEntityWirelessRouter;
    }

    public static boolean isConnectable(BlockGetter world, BlockPos connectorPos, Direction facing) {
        BlockPos pos = connectorPos.m_121945_(facing);
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (state.m_60795_()) {
            return false;
        }
        BlockEntity tileEntity = world.m_7702_(connectorPos);
        if (!(tileEntity instanceof ConnectorTileEntity)) {
            return false;
        }
        ConnectorTileEntity connectorTE = (ConnectorTileEntity)tileEntity;
        if (!connectorTE.isEnabled(facing)) {
            return false;
        }
        BlockEntity te = world.m_7702_(pos);
        if (block instanceof IConnectable) {
            IConnectable.ConnectResult result = ((IConnectable)block).canConnect(world, connectorPos, pos, te, facing);
            if (result == IConnectable.ConnectResult.NO) {
                return false;
            }
            if (result == IConnectable.ConnectResult.YES) {
                return true;
            }
        }
        for (IConnectable connectable : XNet.xNetApi.getConnectables()) {
            IConnectable.ConnectResult result = connectable.canConnect(world, connectorPos, pos, te, facing);
            if (result == IConnectable.ConnectResult.NO) {
                return false;
            }
            if (result != IConnectable.ConnectResult.YES) continue;
            return true;
        }
        if (block instanceof ConnectorBlock) {
            return false;
        }
        if (block instanceof RedstoneProxyBlock || block == Blocks.f_50261_ || block == Blocks.f_50039_ || block == Blocks.f_50032_) {
            return true;
        }
        if (block.canConnectRedstone(state, world, pos, null) || state.m_60803_()) {
            return true;
        }
        if (te == null) {
            return false;
        }
        if (EnergyTools.isEnergyTE((BlockEntity)te, null)) {
            return true;
        }
        if (te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return true;
        }
        if (te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
            return true;
        }
        if (te instanceof TileEntityController) {
            return true;
        }
        return te instanceof TileEntityRouter;
    }

    @Override
    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        List<ItemStack> drops = super.m_7381_(state, builder);
        ServerLevel world = builder.m_78962_();
        for (ItemStack drop : drops) {
            WorldBlob worldBlob = XNetBlobData.get((Level)world).getWorldBlob((Level)world);
            ConsumerId consumer = worldBlob.getConsumerAt(new BlockPos((Vec3)builder.m_78982_(LootContextParams.f_81460_)));
            if (consumer == null) continue;
            drop.m_41784_().m_128405_("consumerId", consumer.id());
        }
        return drops;
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Block)this), stack, tooltip, flagIn);
    }

    @Override
    public void createCableSegment(Level world, BlockPos pos, ItemStack stack) {
        ConsumerId consumer;
        if (!stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("consumerId")) {
            consumer = new ConsumerId(stack.m_41783_().m_128451_("consumerId"));
        } else {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            consumer = worldBlob.newConsumer();
        }
        this.createCableSegment(world, pos, consumer);
    }

    public void createCableSegment(Level world, BlockPos pos, ConsumerId consumer) {
        XNetBlobData blobData = XNetBlobData.get(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        CableColor color = (CableColor)((Object)world.m_8055_(pos).m_61143_((Property)COLOR));
        worldBlob.createNetworkConsumer(pos, new ColorId(color.ordinal() + 1), consumer);
        blobData.save();
    }

    public static boolean isAdvancedConnector(Level world, BlockPos pos) {
        Block block = world.m_8055_(pos).m_60734_();
        if (block instanceof GenericCableBlock) {
            return ((GenericCableBlock)block).isAdvancedConnector();
        }
        return false;
    }

    @Override
    public boolean isAdvancedConnector() {
        return false;
    }
}

