/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.network.client;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.network.CloseCart;
import noobanidus.mods.lootr.network.OpenCart;
import noobanidus.mods.lootr.network.UpdateModelData;

public class ClientHandlers {
    public static void handleUpdateModel(UpdateModelData message, Supplier<NetworkEvent.Context> context) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            LootrAPI.LOG.info("Unable to update model data for location '" + message.pos + "' as level is null.");
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            LootrAPI.LOG.info("Unable to update model data for location '" + message.pos + "' as player is null.");
            return;
        }
        BlockEntity be = level.m_7702_(message.pos);
        if (be instanceof ILootBlockEntity) {
            ILootBlockEntity tile = (ILootBlockEntity)be;
            tile.getOpeners().remove(player.m_20148_());
            be.m_6596_();
            if (level.f_46443_) {
                level.getModelDataManager().requestRefresh(be);
            }
        } else {
            LootrAPI.LOG.info("Unable to update model data for location '" + message.pos + "' as block entity is null or not a Lootr block entity.");
        }
    }

    public static void handleOpenCart(OpenCart message, Supplier<NetworkEvent.Context> context) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as opened as level is null.");
            return;
        }
        Entity cart = level.m_6815_(message.entityId);
        if (cart == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as opened as entity is null.");
            return;
        }
        if (!(cart instanceof LootrChestMinecartEntity)) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as opened as entity is not a Lootr minecart.");
            return;
        }
        ((LootrChestMinecartEntity)cart).setOpened();
    }

    public static void handleCloseCart(CloseCart message, Supplier<NetworkEvent.Context> context) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as closed as level is null.");
            return;
        }
        Entity cart = level.m_6815_(message.entityId);
        if (cart == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as closed as entity is null.");
            return;
        }
        if (!(cart instanceof LootrChestMinecartEntity)) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + message.entityId + "' as closed as entity is not a Lootr minecart.");
            return;
        }
        ((LootrChestMinecartEntity)cart).setClosed();
    }
}

