/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.entities;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.event.HandleChunk;

@Mod.EventBusSubscriber(modid="lootr")
public class TileTicker {
    private static final Object listLock = new Object();
    private static final Object worldLock = new Object();
    private static boolean tickingList = false;
    private static final Set<Entry> tileEntries = new LinkedHashSet<Entry>();
    private static final Set<Entry> pendingEntries = new LinkedHashSet<Entry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(ResourceKey<Level> dimension, BlockPos position) {
        if (ConfigManager.isDimensionBlocked(dimension)) {
            return;
        }
        Entry newEntry = new Entry(dimension, position);
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntries.add(newEntry);
            } else {
                tileEntries.add(newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        block22: {
            HashSet<Entry> copy;
            if (event.phase != TickEvent.Phase.END) break block22;
            HashSet<Entry> toRemove = new HashSet<Entry>();
            Object object = listLock;
            synchronized (object) {
                tickingList = true;
                copy = new HashSet<Entry>(tileEntries);
                tickingList = false;
            }
            object = worldLock;
            synchronized (object) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                for (Entry entry : copy) {
                    RandomizableContainerBlockEntity be;
                    BlockEntity blockEntity;
                    ServerLevel level;
                    block24: {
                        block23: {
                            level = server.m_129880_(entry.getDimension());
                            if (level == null) {
                                toRemove.add(entry);
                                continue;
                            }
                            Map<ResourceKey<Level>, Set<ChunkPos>> map = HandleChunk.LOADED_CHUNKS;
                            synchronized (map) {
                                if (HandleChunk.LOADED_CHUNKS.get(entry.dimension) == null || !HandleChunk.LOADED_CHUNKS.get(entry.dimension).containsAll(entry.getChunkPositions())) {
                                    continue;
                                }
                            }
                            blockEntity = level.m_7702_(entry.getPosition());
                            if (!(blockEntity instanceof RandomizableContainerBlockEntity)) break block23;
                            be = (RandomizableContainerBlockEntity)blockEntity;
                            if (!(blockEntity instanceof ILootBlockEntity)) break block24;
                        }
                        toRemove.add(entry);
                        continue;
                    }
                    if (be.f_59605_ == null || ConfigManager.isBlacklisted(be.f_59605_)) {
                        toRemove.add(entry);
                        continue;
                    }
                    BlockState stateAt = level.m_8055_(entry.getPosition());
                    BlockState replacement = ConfigManager.replacement(stateAt);
                    if (replacement == null) {
                        toRemove.add(entry);
                        continue;
                    }
                    ResourceLocation table = be.f_59605_;
                    long seed = be.f_59606_;
                    be.f_59605_ = null;
                    level.m_46961_(entry.getPosition(), false);
                    level.m_7731_(entry.getPosition(), replacement, 2);
                    blockEntity = level.m_7702_(entry.getPosition());
                    if (blockEntity instanceof ILootBlockEntity) {
                        ((RandomizableContainerBlockEntity)blockEntity).m_59626_(table, seed);
                    } else {
                        LootrAPI.LOG.error("replacement " + replacement + " is not an ILootTile " + entry.getDimension() + " at " + entry.getPosition());
                    }
                    toRemove.add(entry);
                }
            }
            object = listLock;
            synchronized (object) {
                tickingList = true;
                tileEntries.removeAll(toRemove);
                tileEntries.addAll(pendingEntries);
                tickingList = false;
                pendingEntries.clear();
            }
        }
    }

    public static class Entry {
        private final ResourceKey<Level> dimension;
        private final BlockPos position;
        private final Set<ChunkPos> chunks = new HashSet<ChunkPos>();
        private final long addedAt;

        public Entry(ResourceKey<Level> dimension, BlockPos position) {
            this.dimension = dimension;
            this.position = position;
            ChunkPos chunkPos = new ChunkPos(this.position);
            int oX = chunkPos.f_45578_;
            int oZ = chunkPos.f_45579_;
            this.chunks.add(chunkPos);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    this.chunks.add(new ChunkPos(oX + x, oZ + z));
                }
            }
            this.addedAt = ServerLifecycleHooks.getCurrentServer().m_129921_();
        }

        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public Set<ChunkPos> getChunkPositions() {
            return this.chunks;
        }

        public long age(MinecraftServer server) {
            return (long)server.m_129921_() - this.addedAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.addedAt != entry.addedAt) {
                return false;
            }
            if (!this.dimension.equals(entry.dimension)) {
                return false;
            }
            return this.position.equals((Object)entry.position);
        }

        public int hashCode() {
            int result = this.dimension.hashCode();
            result = 31 * result + this.position.hashCode();
            result = 31 * result + (int)(this.addedAt ^ this.addedAt >>> 32);
            return result;
        }

        public String toString() {
            return "Entry{dimension=" + this.dimension + ", position=" + this.position + ", addedAt=" + this.addedAt + "}";
        }
    }
}

