/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edivad.edivadlib.Main;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public abstract class BaseAdvancementProvider
implements DataProvider {
    private final DataGenerator.PathProvider pathProvider;
    private final ExistingFileHelper existingFileHelper;
    private final String modId;

    public BaseAdvancementProvider(DataGenerator generator, ExistingFileHelper existingFileHelper, String modId) {
        this.existingFileHelper = existingFileHelper;
        this.modId = modId;
        this.pathProvider = generator.m_236036_(DataGenerator.Target.DATA_PACK, "advancements");
    }

    public void m_213708_(CachedOutput cache) {
        this.registerAdvancements(advancement -> {
            ResourceLocation id = advancement.m_138327_();
            if (this.existingFileHelper.exists(id, PackType.SERVER_DATA, ".json", "advancements")) {
                throw new IllegalStateException("Duplicate advancement " + id);
            }
            Path path = this.pathProvider.m_236048_(id);
            JsonObject json = advancement.m_138313_().m_138400_();
            this.existingFileHelper.trackGenerated(id, PackType.SERVER_DATA, ".json", "advancements");
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)path);
            }
            catch (IOException e) {
                Main.LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)e);
            }
        });
    }

    protected abstract void registerAdvancements(@NotNull Consumer<Advancement> var1);

    public String m_6055_() {
        return "Advancements: " + this.modId;
    }
}

