/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyNonzeroInt;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeParaboloid
extends Shape {
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.X, BuildGuide.screenHandler.translate("property.buildguide.direction"), () -> this.update(), this.directionNames);
    private PropertyPositiveFloat propertyHalfwidth1 = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.halfwidthdir", "Y"), () -> this.update());
    private PropertyPositiveFloat propertyHalfwidth2 = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.halfwidthdir", "Z"), () -> this.update());
    private PropertyNonzeroInt propertyHeight = new PropertyNonzeroInt(3, BuildGuide.screenHandler.translate("property.buildguide.height"), () -> this.update());
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("property.buildguide.evenmode"), () -> this.update());

    public ShapeParaboloid() {
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertyHalfwidth1);
        this.properties.add(this.propertyHalfwidth2);
        this.properties.add(this.propertyHeight);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        float hw1 = ((Float)this.propertyHalfwidth1.value).floatValue();
        float hw2 = ((Float)this.propertyHalfwidth2.value).floatValue();
        int h = (Integer)this.propertyHeight.value;
        double fac1 = Math.abs((double)h) / (double)hw1 / (double)hw1;
        double fac2 = Math.abs((double)h) / (double)hw2 / (double)hw2;
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        switch ((direction)((Object)this.propertyDir.value)) {
            case X: {
                this.setBaseposOffset(0.0, offset, offset);
                break;
            }
            case Y: {
                this.setBaseposOffset(offset, 0.0, offset);
                break;
            }
            case Z: {
                this.setBaseposOffset(offset, offset, 0.0);
            }
        }
        for (int a = (int)Math.floor((double)(-hw1) + offset); a <= (int)Math.ceil((double)hw1 + offset); ++a) {
            for (int b = (int)Math.floor((double)(-hw2) + offset); b <= (int)Math.ceil((double)hw2 + offset); ++b) {
                block17: for (int c = 0; c < Math.abs(h); ++c) {
                    if (!(fac1 * ((double)a - offset) * ((double)a - offset) + fac2 * ((double)b - offset) * ((double)b - offset) >= (double)c) || !(fac1 * ((double)a - offset - Math.signum((double)a - offset)) * ((double)a - offset - Math.signum((double)a - offset)) + fac2 * ((double)b - offset) * ((double)b - offset) < (double)c) && !(fac1 * ((double)a - offset) * ((double)a - offset) + fac2 * ((double)b - offset - Math.signum((double)b - offset)) * ((double)b - offset - Math.signum((double)b - offset)) < (double)c) && !(fac1 * ((double)a - offset) * ((double)a - offset) + fac2 * ((double)b - offset) * ((double)b - offset) < (double)(c + 1))) continue;
                    switch ((direction)((Object)this.propertyDir.value)) {
                        case X: {
                            this.addShapeCube(buffer, (int)((float)c * Math.signum(h)), a, b);
                            continue block17;
                        }
                        case Y: {
                            this.addShapeCube(buffer, a, (int)((float)c * Math.signum(h)), b);
                            continue block17;
                        }
                        case Z: {
                            this.addShapeCube(buffer, a, b, (int)((float)c * Math.signum(h)));
                        }
                    }
                }
            }
        }
        switch ((direction)((Object)this.propertyDir.value)) {
            case X: {
                this.propertyHalfwidth1.setName(BuildGuide.screenHandler.translate("property.buildguide.halfwidthdir", "Y"));
                this.propertyHalfwidth2.setName(BuildGuide.screenHandler.translate("property.buildguide.halfwidthdir", "Z"));
                break;
            }
            case Y: {
                this.propertyHalfwidth1.setName(BuildGuide.screenHandler.translate("property.buildguide.halfwidthdir", "X"));
                this.propertyHalfwidth2.setName(BuildGuide.screenHandler.translate("property.buildguide.halfwidthdir", "Z"));
                break;
            }
            case Z: {
                this.propertyHalfwidth1.setName(BuildGuide.screenHandler.translate("property.buildguide.halfwidthdir", "X"));
                this.propertyHalfwidth2.setName(BuildGuide.screenHandler.translate("property.buildguide.halfwidthdir", "Y"));
            }
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.paraboloid";
    }

    private static enum direction {
        X,
        Y,
        Z;

    }
}

